/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.block;

import com.github.jlangch.venice.impl.reader.LineReader;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.markdown.block.TitleBlock;

public class TitleBlockParser {
    private final LineReader reader;

    public TitleBlockParser(LineReader reader) {
        this.reader = reader;
    }

    public TitleBlock parse() {
        if (this.reader.eof()) {
            return new TitleBlock();
        }
        String line = StringUtil.trimToEmpty(this.reader.peek());
        if (TitleBlockParser.isBlockStart(line)) {
            int level = 0;
            while (!line.isEmpty() && line.startsWith("#")) {
                ++level;
                line = line.substring(1);
            }
            String text = StringUtil.trimToEmpty(line);
            if (!text.isEmpty()) {
                this.reader.consume();
                return new TitleBlock(text, level);
            }
        }
        return new TitleBlock();
    }

    public static boolean isBlockStart(String line) {
        return line.startsWith("#") && !line.matches("[#]+");
    }
}

