/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.loadpath;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.loadpath.Access;
import com.github.jlangch.venice.impl.util.loadpath.DirectoryLoadPath;
import com.github.jlangch.venice.impl.util.loadpath.FileLoadPath;
import com.github.jlangch.venice.impl.util.loadpath.ZipLoadPath;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;

public abstract class LoadPath {
    abstract File path();

    abstract boolean isOnPath(File var1, Access var2);

    abstract boolean isRegularFileOnLoadPath(File var1, Access var2);

    abstract boolean isDirectoryOnLoadPath(File var1, Access var2);

    abstract File normalize(File var1);

    abstract ByteBuffer load(File var1) throws IOException;

    abstract InputStream getInputStream(File var1) throws IOException;

    abstract BufferedReader getBufferedReader(File var1, Charset var2) throws IOException;

    abstract OutputStream getOutputStream(File var1, OpenOption ... var2) throws IOException;

    public File canonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new VncException(String.format("The file '%s' can not be converted to a canonical path!", file.getPath()), ex);
        }
    }

    public static LoadPath of(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        if (file.isDirectory()) {
            return new DirectoryLoadPath(file);
        }
        if (file.isFile()) {
            if (ZipLoadPath.isZipFile(file)) {
                return new ZipLoadPath(file);
            }
            return new FileLoadPath(file);
        }
        throw new VncException(String.format("The file '%s' is not a valid load path. It is neither an existing regular file or directory!", file.getPath()));
    }
}

