/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.io;

import com.github.jlangch.venice.FileException;
import com.github.jlangch.venice.impl.util.io.CharsetUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class FileUtil {
    private static final int MAX_DIR_LEVELS = 32;

    private FileUtil() {
    }

    public static byte[] load(File source) {
        try {
            return Files.readAllBytes(source.toPath());
        }
        catch (Exception ex) {
            throw new FileException("Failed to load file <" + source + ">.", ex);
        }
    }

    public static void copy(File source, File destination, boolean overwrite) {
        try {
            if (overwrite) {
                Files.copy(source.toPath(), destination.toPath(), new CopyOption[0]);
            } else {
                Files.copy(source.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception ex) {
            throw new FileException("Failed to copy file from <" + source + "> to <" + destination + ">.", ex);
        }
    }

    public static void save(byte[] data, File destination, boolean overwrite) {
        try {
            if (overwrite) {
                Files.write(destination.toPath(), data, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            } else {
                Files.write(destination.toPath(), data, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
            }
        }
        catch (Exception ex) {
            throw new FileException("Failed to save to file <" + destination + ">.", ex);
        }
    }

    public static void append(byte[] data, File destination) {
        try {
            Files.write(destination.toPath(), data, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (Exception ex) {
            throw new FileException("Failed to append to file <" + destination + ">.", ex);
        }
    }

    public static void save(InputStream inStream, File destination, boolean overwrite) {
        try {
            if (overwrite) {
                Files.copy(inStream, destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(inStream, destination.toPath(), new CopyOption[0]);
            }
        }
        catch (Exception ex) {
            throw new FileException("Failed to save stream  data to file <" + destination + ">.", ex);
        }
    }

    public static void save(String text, File destination, boolean overwrite) {
        FileUtil.save(text.getBytes(CharsetUtil.DEFAULT_CHARSET), destination, overwrite);
    }

    public static int deleteFiles(File path, FilenameFilter filter) {
        if (path == null) {
            throw new IllegalArgumentException("A path must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("A filter must not be null");
        }
        int count = 0;
        File[] files = path.listFiles(filter);
        if (files != null) {
            for (int ii = 0; ii < files.length; ++ii) {
                if (!files[ii].delete()) continue;
                ++count;
            }
        }
        return count;
    }

    public static File getTempDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static String getCurrentWorkDir() {
        File f = new File(".");
        String cwd = f.getAbsolutePath();
        return cwd.substring(0, cwd.length() - 2);
    }

    public static void touch(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        FileUtil.touch(file, System.currentTimeMillis());
    }

    public static void touch(File file, long modificationTime) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    throw new FileException("File <" + file + "> existed already");
                }
            }
            catch (IOException ex) {
                throw new FileException("Failed to create new file <" + file + ">.", ex);
            }
        }
        if (!file.canWrite()) {
            throw new FileException("Can not change modification date of read-only-file <" + file + ">.");
        }
        if (!file.setLastModified(modificationTime)) {
            throw new FileException("Can not change modification date of file <" + file + ">.");
        }
    }

    public static void delete(File file) {
        boolean deleted;
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        if (file.exists() && !(deleted = file.delete())) {
            throw new FileException("Failed to delete " + (file.isDirectory() ? "directory" : "file") + " <" + file + ">.");
        }
    }

    public static void mkdir(File dir) {
        boolean created;
        if (dir == null) {
            throw new IllegalArgumentException("A dir must not be null");
        }
        if (!dir.isDirectory() && !(created = dir.mkdir())) {
            throw new FileException("Failed to create directory <" + dir + ">.");
        }
    }

    public static void mkdirs(File dir) {
        boolean created;
        if (dir == null) {
            throw new IllegalArgumentException("A dir must not be null");
        }
        if (!dir.isDirectory() && !(created = dir.mkdirs())) {
            throw new FileException("Failed to create directory <" + dir + "> with its nonexistent parent directories.");
        }
    }

    public static void rmdir(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("A dir must not be null");
        }
        try {
            FileUtil.doRmDir(dir, 0);
        }
        catch (Exception ex) {
            throw new FileException("Failed to delete directory <" + dir + ">.", ex);
        }
    }

    public static void copydir(File srcdir, File dstdir) {
        if (srcdir == null) {
            throw new IllegalArgumentException("A source dir must not be null");
        }
        if (dstdir == null) {
            throw new IllegalArgumentException("A destination dir must not be null");
        }
        try {
            FileUtil.doCopyDir(srcdir, dstdir, 0);
        }
        catch (RuntimeException ex) {
            throw new FileException("Failed to copy directory <" + srcdir + ">.", ex);
        }
    }

    public static Date getFileCreationDate(File file) {
        try {
            BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return new Date(attr.creationTime().toMillis());
        }
        catch (Exception ex) {
            throw new FileException("Failed to get file creation date. File " + file.getPath(), ex);
        }
    }

    public static String replaceFileExt(String fileName, String fileExt) {
        if (fileName == null) {
            throw new IllegalArgumentException("A fileName must not be null");
        }
        if (fileExt == null) {
            throw new IllegalArgumentException("A fileExt must not be null");
        }
        String extension = fileExt;
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        int pos = fileName.lastIndexOf(46);
        return (pos < 0 ? fileName : fileName.substring(0, pos)) + "." + extension;
    }

    public static String getFileExt(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("A fileName must not be null");
        }
        int pos = fileName.lastIndexOf(46);
        return pos < 0 ? null : fileName.substring(pos + 1);
    }

    public static String getFileBaseName(String fileName) {
        int pos = fileName.lastIndexOf(46);
        return pos < 0 ? null : fileName.substring(0, pos);
    }

    public static String getFileExtensionLowerCase(String fileName) {
        String ext = FileUtil.getFileExt(fileName);
        return ext == null ? null : ext.toLowerCase();
    }

    public static boolean awaitFile(Path target, long timeoutMillis, Set<WatchEvent.Kind<?>> events) throws IOException, InterruptedException {
        Path name = target.getFileName();
        Path targetDir = target.getParent();
        long endWaitTime = System.currentTimeMillis() + timeoutMillis;
        if (FileUtil.awaitFileEarlyReturnCheck(target, events)) {
            return true;
        }
        try (WatchService ws = FileSystems.getDefault().newWatchService();){
            targetDir.register(ws, events.toArray(new WatchEvent.Kind[0]));
            if (FileUtil.awaitFileEarlyReturnCheck(target, events)) {
                boolean bl = true;
                return bl;
            }
            while (System.currentTimeMillis() < endWaitTime) {
                long timeout = Math.max(1L, endWaitTime - System.currentTimeMillis());
                WatchKey key = ws.poll(timeout, TimeUnit.MILLISECONDS);
                if (key == null) {
                    break;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    Path p = (Path)event.context();
                    if (!p.getFileName().equals(name)) continue;
                    boolean bl = true;
                    return bl;
                }
                if (key.reset()) continue;
                break;
            }
        }
        return false;
    }

    private static boolean awaitFileEarlyReturnCheck(Path target, Set<WatchEvent.Kind<?>> watchEvents) throws IOException, InterruptedException {
        return watchEvents.contains(StandardWatchEventKinds.ENTRY_CREATE) ? Files.exists(target, new LinkOption[0]) : watchEvents.contains(StandardWatchEventKinds.ENTRY_DELETE) && !Files.exists(target, new LinkOption[0]);
    }

    private static void doRmDir(File dir, int level) {
        if (level > 32) {
            throw new FileException("Reached max dir level (32)");
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                FileUtil.doRmDir(file, level + 1);
                continue;
            }
            if (file.delete()) continue;
            throw new RuntimeException("Could not delete file " + file.getAbsolutePath());
        }
        if (!dir.delete()) {
            throw new RuntimeException("Could not delete directory " + dir.getAbsolutePath());
        }
    }

    private static void doCopyDir(File srcdir, File dstdir, int level) {
        if (level > 32) {
            throw new FileException("Reached max dir level (32)");
        }
        if (!dstdir.exists()) {
            FileUtil.mkdir(dstdir);
        }
        for (File file : srcdir.listFiles()) {
            if (file.isDirectory()) {
                FileUtil.doCopyDir(new File(srcdir, file.getName()), new File(dstdir, file.getName()), level + 1);
                continue;
            }
            FileUtil.copy(file, new File(dstdir, file.getName()), true);
        }
    }
}

