/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.excel;

import com.github.jlangch.venice.ExcelException;
import com.github.jlangch.venice.impl.util.excel.ColorUtil;
import com.github.jlangch.venice.impl.util.excel.ExcelCellStyles;
import com.github.jlangch.venice.impl.util.excel.ExcelCharts;
import com.github.jlangch.venice.impl.util.time.TimeUtil;
import com.github.jlangch.venice.util.excel.CellAddr;
import com.github.jlangch.venice.util.excel.CellRangeAddr;
import com.github.jlangch.venice.util.excel.HeaderFooterPosition;
import com.github.jlangch.venice.util.excel.PageOrientation;
import com.github.jlangch.venice.util.excel.PaperSize;
import com.github.jlangch.venice.util.excel.chart.AreaDataSeries;
import com.github.jlangch.venice.util.excel.chart.BarDataSeries;
import com.github.jlangch.venice.util.excel.chart.BarGrouping;
import com.github.jlangch.venice.util.excel.chart.ImageType;
import com.github.jlangch.venice.util.excel.chart.LineDataSeries;
import com.github.jlangch.venice.util.excel.chart.PieDataSeries;
import com.github.jlangch.venice.util.excel.chart.Position;
import com.github.jlangch.venice.util.pdf.HtmlColor;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderFormatting;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FontFormatting;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.PageMargin;
import org.apache.poi.ss.usermodel.PatternFormatting;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelSheet {
    public static final float COL_WIDTH_MAGIC_FACTOR = 46.4f;
    private static final Boolean NULL_BOOLEAN = null;
    private final Sheet sheet;
    private final ExcelCellStyles cellStyles;
    private final FormulaEvaluator evaluator;

    public ExcelSheet(Sheet sheet, ExcelCellStyles cellFormats, FormulaEvaluator evaluator) {
        this.sheet = sheet;
        this.cellStyles = cellFormats;
        this.evaluator = evaluator;
    }

    public String getName() {
        return this.sheet.getSheetName();
    }

    public int getIndex() {
        return this.sheet.getWorkbook().getSheetIndex(this.sheet);
    }

    public void setPrintLayout(PaperSize paperSize, PageOrientation orientation, double headerMarginInches, double footerMarginInches, boolean gridLines, boolean fitToWidthOnly, boolean fitToPage) {
        PrintSetup ps = this.sheet.getPrintSetup();
        ps.setLandscape(orientation == PageOrientation.LANDSCAPE);
        ps.setPaperSize(paperSize.getLegacyApiValue());
        ps.setHeaderMargin(headerMarginInches);
        ps.setFooterMargin(footerMarginInches);
        this.sheet.setPrintGridlines(gridLines);
        if (fitToPage) {
            ps.setFitWidth((short)1);
            ps.setFitHeight((short)0);
            this.sheet.setFitToPage(true);
        } else if (fitToWidthOnly) {
            ps.setFitWidth((short)1);
        }
    }

    public void setPageMargins(double leftInches, double rightInches, double topInches, double bottomInches) {
        this.sheet.setMargin(PageMargin.LEFT, leftInches);
        this.sheet.setMargin(PageMargin.RIGHT, rightInches);
        this.sheet.setMargin(PageMargin.TOP, topInches);
        this.sheet.setMargin(PageMargin.BOTTOM, bottomInches);
    }

    public void setHeaderMargin(double inches) {
        this.sheet.setMargin(PageMargin.HEADER, inches);
    }

    public void setFooterMargin(double inches) {
        this.sheet.setMargin(PageMargin.FOOTER, inches);
    }

    public void setHeader(String text, HeaderFooterPosition position, int fontSizePts, boolean bold) {
        Header header = this.sheet.getHeader();
        String s = this.buildFooterHeaderString(text, position, fontSizePts, bold);
        switch (position) {
            case LEFT: {
                header.setLeft(s);
                break;
            }
            case CENTER: {
                header.setCenter(s);
                break;
            }
            case RIGHT: {
                header.setRight(s);
                break;
            }
            default: {
                header.setCenter(s);
            }
        }
    }

    public void setFooter(String text, HeaderFooterPosition position, int fontSizePts, boolean bold) {
        Footer footer = this.sheet.getFooter();
        String s = this.buildFooterHeaderString(text, position, fontSizePts, bold);
        switch (position) {
            case LEFT: {
                footer.setLeft(s);
                break;
            }
            case CENTER: {
                footer.setCenter(s);
                break;
            }
            case RIGHT: {
                footer.setRight(s);
                break;
            }
            default: {
                footer.setCenter(s);
            }
        }
    }

    public void setDisplayGridlines(boolean display) {
        this.sheet.setDisplayGridlines(display);
    }

    public int getFirstRowNum() {
        return this.sheet.getFirstRowNum();
    }

    public int getLastRowNum() {
        return this.sheet.getLastRowNum();
    }

    public int getFirstCellNum(int row) {
        Row r = this.sheet.getRow(row);
        return r == null ? -1 : (int)r.getFirstCellNum();
    }

    public int getLastCellNum(int row) {
        Row r = this.sheet.getRow(row);
        return r == null ? -1 : (int)r.getLastCellNum();
    }

    public void createFreezePane(int colSplit, int rowSplit) {
        this.sheet.createFreezePane(colSplit, rowSplit);
    }

    public void protectSheet(String password) {
        this.sheet.protectSheet(password);
    }

    public boolean isCellEmpty(int row, int col) {
        Cell cell = this.getCell(row, col);
        return cell == null || cell.getCellType() == CellType.BLANK;
    }

    public String getCellAddress_A1_style(int row, int col) {
        return new CellAddress(row, col).formatAsString();
    }

    public String getCellType(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell == null) {
            return "notfound";
        }
        return this.getCellType(cell.getCellType());
    }

    public String getCellFormulaResultType(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell == null) {
            return "notfound";
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return this.getCellType(cell.getCachedFormulaResultType());
        }
        return this.getCellType(cell.getCellType());
    }

    public void deleteRow(int row) {
        Row lastRow;
        int lastRowNum = this.sheet.getLastRowNum();
        if (row >= 0 && row < lastRowNum) {
            this.sheet.shiftRows(row + 1, lastRowNum, -1);
        }
        if (row == lastRowNum && (lastRow = this.sheet.getRow(row)) != null) {
            this.sheet.removeRow(lastRow);
        }
    }

    public void clearRow(int row, boolean clearValues, boolean clearStyles) {
        Row sourceRow = this.sheet.getRow(row);
        if (sourceRow == null) {
            return;
        }
        for (int ii = 0; ii < sourceRow.getLastCellNum(); ++ii) {
            Cell cell = sourceRow.getCell(ii);
            if (cell == null) continue;
            if (clearValues) {
                cell.setBlank();
                continue;
            }
            if (!clearStyles) continue;
            cell.setCellStyle(null);
        }
    }

    public void copyRowToEndOfSheet(int row, boolean copyValues, boolean copyStyles) {
        Row sourceRow = this.sheet.getRow(row);
        if (sourceRow == null) {
            return;
        }
        int lastRowNum = this.sheet.getLastRowNum();
        Row newRow = this.sheet.createRow(lastRowNum + 1);
        for (int ii = 0; ii < sourceRow.getLastCellNum(); ++ii) {
            Cell oldCell = sourceRow.getCell(ii);
            Cell newCell = newRow.createCell(ii);
            if (oldCell == null) continue;
            if (copyStyles) {
                newCell.setCellStyle(oldCell.getCellStyle());
            }
            if (!copyValues) continue;
            this.copyCellValue(oldCell, newCell);
        }
    }

    public void copyRow(int rowFrom, int rowTo, boolean copyValues, boolean copyStyles) {
        int lastRowNum = this.sheet.getLastRowNum();
        if (rowTo > lastRowNum) {
            this.copyRowToEndOfSheet(rowFrom, copyValues, copyStyles);
        } else {
            Row sourceRow = this.sheet.getRow(rowFrom);
            if (sourceRow == null) {
                return;
            }
            Row destRow = this.sheet.getRow(rowTo);
            if (destRow == null) {
                return;
            }
            this.clearRow(rowTo, true, copyStyles);
            for (int ii = 0; ii < sourceRow.getLastCellNum(); ++ii) {
                Cell oldCell = sourceRow.getCell(ii);
                Cell destCell = destRow.getCell(ii, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                if (oldCell == null) continue;
                if (copyStyles) {
                    destCell.setCellStyle(oldCell.getCellStyle());
                }
                if (!copyValues) continue;
                this.copyCellValue(oldCell, destCell);
            }
        }
    }

    public void insertEmptyRow(int row) {
        int lastRowNum = this.sheet.getLastRowNum();
        this.sheet.shiftRows(row, lastRowNum, 1);
        this.sheet.createRow(row);
    }

    public void insertEmptyRows(int row, int count) {
        for (int ii = 0; ii < count; ++ii) {
            int lastRowNum = this.sheet.getLastRowNum();
            this.sheet.shiftRows(row, lastRowNum, 1);
            this.sheet.createRow(row);
        }
    }

    public void copyCellStyle(int cellRowFrom, int cellColFrom, int cellRowTo, int cellColTo) {
        Cell cellFrom = this.getCell(cellRowFrom, cellColFrom);
        if (cellFrom != null) {
            Cell cellTo = this.getCellOrCreate(cellRowTo, cellColTo);
            CellStyle style = cellFrom.getCellStyle();
            cellTo.setCellStyle(style);
        }
    }

    public void addConditionalBackgroundColor(String condRule, String colorHtml, int regionFirstRow, int regionLastRow, int regionFirstCol, int regionLastCol) {
        if (!(this.sheet instanceof XSSFSheet)) {
            throw new RuntimeException("conditional background colors are available for XLSX documents only!");
        }
        SheetConditionalFormatting sheetCF = this.sheet.getSheetConditionalFormatting();
        ConditionalFormattingRule rule = sheetCF.createConditionalFormattingRule(condRule);
        PatternFormatting fill = rule.createPatternFormatting();
        fill.setFillBackgroundColor((org.apache.poi.ss.usermodel.Color)this.toXSSFColor(colorHtml));
        fill.setFillPattern((short)1);
        CellRangeAddress[] regions = new CellRangeAddress[]{new CellRangeAddress(regionFirstRow, regionLastRow, regionFirstCol, regionLastCol)};
        sheetCF.addConditionalFormatting(regions, rule);
    }

    public void addConditionalFontColor(String condRule, String colorHtml, int regionFirstRow, int regionLastRow, int regionFirstCol, int regionLastCol) {
        if (!(this.sheet instanceof XSSFSheet)) {
            throw new RuntimeException("conditional font colors are available for XLSX documents only!");
        }
        SheetConditionalFormatting sheetCF = this.sheet.getSheetConditionalFormatting();
        ConditionalFormattingRule rule = sheetCF.createConditionalFormattingRule(condRule);
        FontFormatting fontFmt = rule.createFontFormatting();
        fontFmt.setFontColor((org.apache.poi.ss.usermodel.Color)this.toXSSFColor(colorHtml));
        CellRangeAddress[] regions = new CellRangeAddress[]{new CellRangeAddress(regionFirstRow, regionLastRow, regionFirstCol, regionLastCol)};
        sheetCF.addConditionalFormatting(regions, rule);
    }

    public void addConditionalBorder(String condRule, BorderStyle borderTopStyle, BorderStyle borderRightStyle, BorderStyle borderBottomStyle, BorderStyle borderLeftStyle, String borderTopColorHtml, String borderRightColorHtml, String borderBottomColorHtml, String borderLeftColorHtml, int regionFirstRow, int regionLastRow, int regionFirstCol, int regionLastCol) {
        if (!(this.sheet instanceof XSSFSheet)) {
            throw new RuntimeException("conditional font colors are available for XLSX documents only!");
        }
        SheetConditionalFormatting sheetCF = this.sheet.getSheetConditionalFormatting();
        ConditionalFormattingRule rule = sheetCF.createConditionalFormattingRule(condRule);
        BorderFormatting fmt = rule.createBorderFormatting();
        if (borderTopStyle != null) {
            fmt.setBorderTop(borderTopStyle);
        }
        if (borderRightStyle != null) {
            fmt.setBorderRight(borderRightStyle);
        }
        if (borderBottomStyle != null) {
            fmt.setBorderBottom(borderBottomStyle);
        }
        if (borderLeftStyle != null) {
            fmt.setBorderLeft(borderLeftStyle);
        }
        if (borderTopColorHtml != null) {
            fmt.setTopBorderColor((org.apache.poi.ss.usermodel.Color)this.toXSSFColor(borderTopColorHtml));
        }
        if (borderRightColorHtml != null) {
            fmt.setRightBorderColor((org.apache.poi.ss.usermodel.Color)this.toXSSFColor(borderRightColorHtml));
        }
        if (borderBottomColorHtml != null) {
            fmt.setBottomBorderColor((org.apache.poi.ss.usermodel.Color)this.toXSSFColor(borderBottomColorHtml));
        }
        if (borderLeftColorHtml != null) {
            fmt.setLeftBorderColor((org.apache.poi.ss.usermodel.Color)this.toXSSFColor(borderLeftColorHtml));
        }
        CellRangeAddress[] regions = new CellRangeAddress[]{new CellRangeAddress(regionFirstRow, regionLastRow, regionFirstCol, regionLastCol)};
        sheetCF.addConditionalFormatting(regions, rule);
    }

    public void addTextDataValidation(List<String> validValues, boolean emptyCellAllowed, String errTitle, String errText, int regionFirstRow, int regionLastRow, int regionFirstCol, int regionLastCol) {
        XSSFDataValidationHelper validationHelper = this.sheet instanceof XSSFSheet ? new XSSFDataValidationHelper((XSSFSheet)this.sheet) : new HSSFDataValidationHelper((HSSFSheet)this.sheet);
        DataValidationConstraint constraint = validationHelper.createExplicitListConstraint(validValues.toArray(new String[0]));
        CellRangeAddressList addressList = new CellRangeAddressList(regionFirstRow, regionLastRow, regionFirstCol, regionLastCol);
        DataValidation dataValidation = validationHelper.createValidation(constraint, addressList);
        dataValidation.setEmptyCellAllowed(emptyCellAllowed);
        if (errTitle != null || errText != null) {
            dataValidation.setShowErrorBox(true);
            dataValidation.createErrorBox(errTitle == null ? "" : errTitle, errText == null ? "" : errText);
        }
        this.sheet.addValidationData(dataValidation);
    }

    public Object getValue(int row, int col) {
        Cell cell = this.getCell(row, col);
        return this.getValue(cell);
    }

    public String getString(int row, int col) {
        Cell cell = this.getCell(row, col);
        return this.getString(cell);
    }

    public Boolean getBoolean(int row, int col) {
        Cell cell = this.getCell(row, col);
        return this.getBoolean(cell);
    }

    public Long getInteger(int row, int col) {
        Cell cell = this.getCell(row, col);
        return this.getInteger(cell);
    }

    public Double getFloat(int row, int col) {
        Cell cell = this.getCell(row, col);
        return this.getFloat(cell);
    }

    public LocalDateTime getDate(int row, int col) {
        Cell cell = this.getCell(row, col);
        return this.getDate(cell);
    }

    public String getFormula(int row, int col) {
        Cell cell = this.getCell(row, col);
        return this.getFormula(cell);
    }

    public String getErrorCode(int row, int col) {
        Cell cell = this.getCell(row, col);
        return this.getErrorCode(cell);
    }

    public String getDataFormatString(int row, int col) {
        Cell cell = this.getCell(row, col);
        return this.getDataFormatString(cell);
    }

    public void lock(int row, int col, boolean locked) {
        Cell cell = this.getCell(row, col);
        if (cell != null) {
            CellStyle lockedCellStyle = this.cellStyles.createCellStyle();
            lockedCellStyle.cloneStyleFrom(cell.getCellStyle());
            lockedCellStyle.setLocked(locked);
            cell.setCellStyle(lockedCellStyle);
        }
    }

    public boolean isLocked(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell == null) {
            return false;
        }
        CellStyle style = cell.getCellStyle();
        return style == null ? false : style.getLocked();
    }

    public boolean isHidden(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell == null) {
            return false;
        }
        CellStyle style = cell.getCellStyle();
        return style == null ? false : style.getHidden();
    }

    public boolean isColumnHidden(int col) {
        return this.sheet.isColumnHidden(col);
    }

    public void setString(int row, int col, String value, String styleName) {
        this.setCellValue(this.getCellOrCreate(row, col), value, styleName);
    }

    public void setString(int row, int col, String value) {
        this.setCellValue(this.getCellOrCreate(row, col), value, "string");
    }

    public void setBoolean(int row, int col, Boolean value, String styleName) {
        this.setCellValue(this.getCellOrCreate(row, col), value, styleName);
    }

    public void setBoolean(int row, int col, Boolean value) {
        this.setCellValue(this.getCellOrCreate(row, col), value, "boolean");
    }

    public void setInteger(int row, int col, Integer value, String styleName) {
        this.setCellValue(this.getCellOrCreate(row, col), value, styleName);
    }

    public void setInteger(int row, int col, Integer value) {
        this.setCellValue(this.getCellOrCreate(row, col), value, "integer");
    }

    public void setInteger(int row, int col, Long value, String styleName) {
        this.setCellValue(this.getCellOrCreate(row, col), value, styleName);
    }

    public void setInteger(int row, int col, Long value) {
        this.setCellValue(this.getCellOrCreate(row, col), value, "integer");
    }

    public void setFloat(int row, int col, Float value, String styleName) {
        this.setCellValue(this.getCellOrCreate(row, col), value, styleName);
    }

    public void setFloat(int row, int col, Float value) {
        this.setCellValue(this.getCellOrCreate(row, col), value, "float");
    }

    public void setFloat(int row, int col, Double value, String styleName) {
        this.setCellValue(this.getCellOrCreate(row, col), value, styleName);
    }

    public void setFloat(int row, int col, Double value) {
        this.setCellValue(this.getCellOrCreate(row, col), value, "float");
    }

    public void setDate(int row, int col, Date value, String styleName) {
        this.setCellValue(this.getCellOrCreate(row, col), value, styleName);
    }

    public void setDate(int row, int col, LocalDate value, String styleName) {
        this.setCellValue(this.getCellOrCreate(row, col), value, styleName);
    }

    public void setDate(int row, int col, LocalDateTime value, String styleName) {
        this.setCellValue(this.getCellOrCreate(row, col), value, styleName);
    }

    public void setDate(int row, int col, ZonedDateTime value, String styleName) {
        this.setCellValue(this.getCellOrCreate(row, col), value, styleName);
    }

    public void setDate(int row, int col, Date value) {
        this.setCellValue(this.getCellOrCreate(row, col), value, "date");
    }

    public void setDate(int row, int col, LocalDate value) {
        this.setCellValue(this.getCellOrCreate(row, col), value, "date");
    }

    public void setDate(int row, int col, LocalDateTime value) {
        this.setCellValue(this.getCellOrCreate(row, col), value, "date");
    }

    public void setDate(int row, int col, ZonedDateTime value) {
        this.setCellValue(this.getCellOrCreate(row, col), value, "date");
    }

    public void setBlank(int row, int col) {
        this.getCellOrCreate(row, col).setBlank();
    }

    public void addImage(CellAddr anchor, byte[] data, ImageType type, Double scaleX, Double scaleY) {
        switch (type) {
            case PNG: {
                this.setImage(anchor, data, 6, scaleX, scaleY);
                break;
            }
            case JPEG: {
                this.setImage(anchor, data, 5, scaleX, scaleY);
                break;
            }
            default: {
                throw new ExcelException(String.format("Excel cell %s in sheet '%s': Invalid image type. Use PNG or JPEG", anchor.mapToOneBased(), this.sheet.getSheetName()));
            }
        }
    }

    public void addLineChart(String title, CellRangeAddr areaCellRangeAddr, Position legendPosition, String categoryAxisTitle, Position categoryAxisPosition, String valueAxisTitle, Position valueAxisPosition, boolean threeDimensional, boolean varyColors, CellRangeAddr categoriesCellRangeAddr, List<LineDataSeries> series) {
        new ExcelCharts(this.sheet).addLineChart(title, areaCellRangeAddr, legendPosition, categoryAxisTitle, categoryAxisPosition, valueAxisTitle, valueAxisPosition, threeDimensional, varyColors, categoriesCellRangeAddr, series);
    }

    public void addBarChart(String title, CellRangeAddr areaCellRangeAddr, Position legendPosition, String categoryAxisTitle, Position categoryAxisPosition, String valueAxisTitle, Position valueAxisPosition, boolean threeDimensional, boolean directionBar, BarGrouping grouping, boolean varyColors, CellRangeAddr categoriesCellRangeAddr, List<BarDataSeries> series) {
        new ExcelCharts(this.sheet).addBarChart(title, areaCellRangeAddr, legendPosition, categoryAxisTitle, categoryAxisPosition, valueAxisTitle, valueAxisPosition, threeDimensional, directionBar, grouping, varyColors, categoriesCellRangeAddr, series);
    }

    public void addAreaChart(String title, CellRangeAddr areaCellRangeAddr, Position legendPosition, String categoryAxisTitle, Position categoryAxisPosition, String valueAxisTitle, Position valueAxisPosition, boolean threeDimensional, CellRangeAddr categoriesCellRangeAddr, List<AreaDataSeries> series) {
        new ExcelCharts(this.sheet).addAreaChart(title, areaCellRangeAddr, legendPosition, categoryAxisTitle, categoryAxisPosition, valueAxisTitle, valueAxisPosition, threeDimensional, categoriesCellRangeAddr, series);
    }

    public void addPieChart(String title, CellRangeAddr areaCellRangeAddr, Position legendPosition, boolean threeDimensional, boolean varyColors, CellRangeAddr categoriesCellRangeAddr, List<PieDataSeries> series) {
        new ExcelCharts(this.sheet).addPieChart(title, areaCellRangeAddr, legendPosition, threeDimensional, varyColors, categoriesCellRangeAddr, series);
    }

    public void setColumnWidthInPoints(int col, int width) {
        this.sheet.setColumnWidth(col, (int)((float)width * 46.4f));
    }

    public void setRowHeightInPoints(int row, int height) {
        this.getRowCreate(row).setHeight((short)(height * 20));
    }

    public void setValue(int row, int col, Object value) {
        this.setValue(row, col, value, null);
    }

    public void setValue(int row, int col, Object value, String styleName) {
        if (value == null) {
            this.setCellValue(this.getCellCreate(row, col), null, null);
        } else if (value instanceof String) {
            this.setString(row, col, (String)value, this.coalesce(styleName, "string"));
        } else if (value instanceof Boolean) {
            this.setBoolean(row, col, (Boolean)value, this.coalesce(styleName, "boolean"));
        } else if (value instanceof Integer) {
            this.setInteger(row, col, (Integer)value, this.coalesce(styleName, "integer"));
        } else if (value instanceof Long) {
            this.setInteger(row, col, (Long)value, this.coalesce(styleName, "integer"));
        } else if (value instanceof Float) {
            this.setFloat(row, col, (Float)value, this.coalesce(styleName, "float"));
        } else if (value instanceof Double) {
            this.setFloat(row, col, (Double)value, this.coalesce(styleName, "float"));
        } else if (value instanceof BigDecimal) {
            this.setFloat(row, col, ((BigDecimal)value).doubleValue(), this.coalesce(styleName, "float"));
        } else if (value instanceof BigInteger) {
            this.setInteger(row, col, ((BigInteger)value).longValue(), this.coalesce(styleName, "integer"));
        } else if (value instanceof LocalDate) {
            this.setDate(row, col, (LocalDate)value, this.coalesce(styleName, "date"));
        } else if (value instanceof LocalDateTime) {
            this.setDate(row, col, (LocalDateTime)value, this.coalesce(styleName, "datetime"));
        } else if (value instanceof ZonedDateTime) {
            this.setDate(row, col, (ZonedDateTime)value, this.coalesce(styleName, "datetime"));
        } else if (value instanceof Date) {
            this.setDate(row, col, (Date)value, this.coalesce(styleName, "datetime"));
        } else {
            throw new IllegalArgumentException("Invalid value type " + value.getClass().getSimpleName());
        }
    }

    public void setValueKeepCellStyle(int row, int col, Object value) {
        if (value == null) {
            this.setCellValue(this.getCellCreate(row, col), null, null);
        } else if (value instanceof String) {
            this.setString(row, col, (String)value, null);
        } else if (value instanceof Boolean) {
            this.setBoolean(row, col, (Boolean)value, null);
        } else if (value instanceof Integer) {
            this.setInteger(row, col, (Integer)value, null);
        } else if (value instanceof Long) {
            this.setInteger(row, col, (Long)value, null);
        } else if (value instanceof Float) {
            this.setFloat(row, col, (Float)value, null);
        } else if (value instanceof Double) {
            this.setFloat(row, col, (Double)value, null);
        } else if (value instanceof BigDecimal) {
            this.setFloat(row, col, ((BigDecimal)value).doubleValue(), null);
        } else if (value instanceof BigInteger) {
            this.setInteger(row, col, ((BigInteger)value).longValue(), null);
        } else if (value instanceof LocalDate) {
            this.setDate(row, col, (LocalDate)value, null);
        } else if (value instanceof LocalDateTime) {
            this.setDate(row, col, (LocalDateTime)value, null);
        } else if (value instanceof ZonedDateTime) {
            this.setDate(row, col, (ZonedDateTime)value, null);
        } else if (value instanceof Date) {
            this.setDate(row, col, (Date)value, null);
        } else {
            throw new IllegalArgumentException("Invalid value type " + value.getClass().getSimpleName());
        }
    }

    public void setBgColor(int row, int col, Color bgColor) {
        Cell cell = this.getCellOrCreate(row, col);
        if (cell != null) {
            this.setBgColor(cell, bgColor);
        }
    }

    public void setBgColorIndex(int row, int col, short bgColor) {
        Cell cell = this.getCellOrCreate(row, col);
        if (cell != null) {
            this.setBgColorIndex(cell, bgColor);
        }
    }

    public void setStyle(int row, int col, String styleName) {
        Cell cell = this.getCellOrCreate(row, col);
        if (cell != null) {
            this.setStyle(cell, styleName);
        }
    }

    public void setFormula(int row, int col, String formula) {
        this.setFormula(row, col, formula, null);
    }

    public void setFormula(int row, int col, String formula, String styleName) {
        Cell cell = this.getCellOrCreate(row, col);
        cell.setCellFormula(formula);
        CellStyle style = this.cellStyles.getCellStyle(styleName);
        if (style != null) {
            cell.setCellStyle(style);
        }
    }

    public void removeFormula(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell != null) {
            cell.removeFormula();
        }
    }

    public void setUrlHyperlink(int row, int col, String text, String urlAddress) {
        Hyperlink link = this.sheet.getWorkbook().getCreationHelper().createHyperlink(HyperlinkType.URL);
        link.setAddress(urlAddress);
        Cell cell = this.getCellOrCreate(row, col);
        cell.setCellValue(text);
        cell.setHyperlink(link);
    }

    public void setEmailHyperlink(int row, int col, String text, String emailAddress) {
        Hyperlink link = this.sheet.getWorkbook().getCreationHelper().createHyperlink(HyperlinkType.EMAIL);
        link.setAddress("mailto:" + emailAddress);
        Cell cell = this.getCellOrCreate(row, col);
        cell.setCellValue(text);
        cell.setHyperlink(link);
    }

    public void removeHyperlink(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell != null) {
            cell.removeHyperlink();
        }
    }

    public void removeComment(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell != null) {
            cell.removeCellComment();
        }
    }

    public Map<String, Object> getCellStyleInfo(int row, int col) {
        CellStyle style;
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        Cell cell = this.getCell(row, col);
        if (cell != null && (style = cell.getCellStyle()) != null) {
            info.put("cell.type", this.getCellType(cell.getCellType()));
            info.put("cell.col", col);
            info.put("cell.row", row);
            Font font = this.cellStyles.getFont(style);
            info.put("font.name", font.getFontName());
            info.put("font.size", font.getFontHeightInPoints());
            info.put("font.bold", font.getBold());
            info.put("font.italic", font.getItalic());
            info.put("h-align", style.getAlignment().name().toLowerCase());
            info.put("v-align", style.getVerticalAlignment().name().toLowerCase());
            info.put("border.top", style.getBorderTop().name().toLowerCase());
            info.put("border.bottom", style.getBorderBottom().name().toLowerCase());
            info.put("border.left", style.getBorderLeft().name().toLowerCase());
            info.put("border.right", style.getBorderRight().name().toLowerCase());
            info.put("fill.bg.color", style.getFillBackgroundColor());
            info.put("fill.fg.color", style.getFillForegroundColor());
            info.put("fill.pattern", style.getFillPattern().name().toLowerCase());
        }
        return info;
    }

    public void addMergedRegion(int rowFrom, int rowTo, int colFrom, int colTo) {
        this.sheet.addMergedRegion(new CellRangeAddress(rowFrom, rowTo, colFrom, colTo));
    }

    public void addMergedRegion(String ref) {
        this.sheet.addMergedRegion(CellRangeAddress.valueOf((String)ref));
    }

    public void setDisplayZeros(boolean value) {
        this.sheet.setDisplayZeros(value);
    }

    public void autoSizeColumn(int col) {
        this.sheet.autoSizeColumn(col);
    }

    public void setColumnHidden(int col, boolean hidden) {
        this.sheet.setColumnHidden(col, hidden);
    }

    public void autoSizeColumns() {
        Row row;
        int firstRow = this.sheet.getFirstRowNum();
        if (firstRow >= 0 && (row = this.sheet.getRow(firstRow)) != null) {
            for (int col = 0; col < row.getLastCellNum(); ++col) {
                this.sheet.autoSizeColumn(col);
            }
        }
    }

    public void evaluateAllFormulas() {
        this.evaluator.evaluateAll();
    }

    public void evaluateCell(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell != null) {
            this.evaluator.evaluate(cell);
        }
    }

    private void setImage(CellAddr anchorAddr, byte[] data, int imageType, Double scaleX, Double scaleY) {
        CreationHelper helper = this.sheet.getWorkbook().getCreationHelper();
        Drawing drawing = this.sheet.createDrawingPatriarch();
        int pictureIdx = this.sheet.getWorkbook().addPicture(data, imageType);
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setCol1(anchorAddr.getCol());
        anchor.setRow1(anchorAddr.getRow());
        Picture pict = drawing.createPicture(anchor, pictureIdx);
        if (scaleX == null || scaleY == null) {
            pict.resize();
        } else {
            pict.resize(scaleX.doubleValue(), scaleY.doubleValue());
        }
    }

    private void setCellValue(Cell cell, Object value, String styleName) {
        CellStyle style;
        if (styleName != null && (style = this.cellStyles.getCellStyle(styleName)) != null) {
            cell.setCellStyle(style);
        }
        if (value == null) {
            cell.setBlank();
        } else if (value instanceof String) {
            if (this.sheet.getWorkbook() instanceof XSSFWorkbook) {
                cell.setCellValue((RichTextString)new XSSFRichTextString(value.toString()));
            } else {
                cell.setCellValue(value.toString());
            }
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).longValue());
        } else if (value instanceof Long) {
            cell.setCellValue((double)((Long)value).longValue());
        } else if (value instanceof Float) {
            cell.setCellValue(((Float)value).doubleValue());
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)value).doubleValue());
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof LocalDate) {
            cell.setCellValue(TimeUtil.convertLocalDateToDate((LocalDate)value));
        } else if (value instanceof LocalDateTime) {
            cell.setCellValue(TimeUtil.convertLocalDateTimeToDate((LocalDateTime)value));
        } else if (value instanceof ZonedDateTime) {
            cell.setCellValue(TimeUtil.convertZonedDateTimeToDate((ZonedDateTime)value));
        }
    }

    private Cell getCell(int row, int col) {
        Row r = this.sheet.getRow(row);
        return r == null ? null : r.getCell(col, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
    }

    private Cell getCellCreate(int row, int col) {
        return this.getRowCreate(row).createCell(col);
    }

    private Cell getCellOrCreate(int row, int col) {
        Row r = this.getRowCreate(row);
        Cell cell = r.getCell(col, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
        return cell == null ? r.createCell(col) : cell;
    }

    private Row getRowCreate(int row) {
        Row r = this.sheet.getRow(row);
        return r != null ? r : this.sheet.createRow(row);
    }

    private String coalesce(String s1, String s2) {
        return s1 != null ? s1 : s2;
    }

    private void setBgColor(Cell cell, Color bgColor) {
        Workbook workbook = this.sheet.getWorkbook();
        CellStyle style = workbook.createCellStyle();
        style.cloneStyleFrom(cell.getCellStyle());
        if (workbook instanceof XSSFWorkbook) {
            ((XSSFCellStyle)style).setFillForegroundColor(new XSSFColor(bgColor, null));
        } else if (workbook instanceof HSSFWorkbook) {
            HSSFColor hssfColor = ColorUtil.bestHSSFColor((HSSFWorkbook)workbook, bgColor);
            style.setFillForegroundColor(hssfColor.getIndex());
        }
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cell.setCellStyle(style);
    }

    private void setBgColorIndex(Cell cell, short bgColor) {
        Workbook workbook = this.sheet.getWorkbook();
        CellStyle style = workbook.createCellStyle();
        style.cloneStyleFrom(cell.getCellStyle());
        style.setFillForegroundColor(bgColor);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cell.setCellStyle(style);
    }

    private void setStyle(Cell cell, String styleName) {
        CellStyle style = this.cellStyles.getCellStyle(styleName);
        if (style != null) {
            cell.setCellStyle(style);
        }
    }

    private Object getValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        CellValue cellValue = this.evaluator.evaluate(cell);
        if (cellValue == null) {
            return null;
        }
        switch (cellValue.getCellType()) {
            case BLANK: {
                return null;
            }
            case STRING: {
                return cellValue.getStringValue();
            }
            case BOOLEAN: {
                return cellValue.getBooleanValue();
            }
            case NUMERIC: {
                return DateUtil.isCellDateFormatted((Cell)cell) ? cell.getLocalDateTimeCellValue() : Double.valueOf(cellValue.getNumberValue());
            }
            case ERROR: {
                return null;
            }
        }
        throw new ExcelException(String.format("Excel cell %s in sheet '%s': failed to read value", new CellAddr(cell.getRowIndex(), cell.getColumnIndex()).mapToOneBased(), this.sheet.getSheetName()));
    }

    private String getString(Cell cell) {
        if (cell == null) {
            return null;
        }
        CellValue cellValue = this.evaluator.evaluate(cell);
        if (cellValue == null) {
            return null;
        }
        switch (cellValue.getCellType()) {
            case BLANK: {
                return null;
            }
            case STRING: {
                return cellValue.getStringValue();
            }
            case BOOLEAN: {
                return Boolean.toString(cellValue.getBooleanValue());
            }
            case NUMERIC: {
                return DateUtil.isCellDateFormatted((Cell)cell) ? cell.getLocalDateTimeCellValue().toString() : Double.toString(cellValue.getNumberValue());
            }
        }
        throw new ExcelException(String.format("Excel cell %s in sheet '%s': does not contain a string value", new CellAddr(cell.getRowIndex(), cell.getColumnIndex()).mapToOneBased(), this.sheet.getSheetName()));
    }

    private Boolean getBoolean(Cell cell) {
        if (cell == null) {
            return NULL_BOOLEAN;
        }
        CellValue cellValue = this.evaluator.evaluate(cell);
        if (cellValue == null) {
            return null;
        }
        if (cellValue.getCellType() == CellType.BLANK) {
            return NULL_BOOLEAN;
        }
        if (cellValue.getCellType() == CellType.BOOLEAN) {
            return cellValue.getBooleanValue();
        }
        throw new ExcelException(String.format("Excel cell %s in sheet '%s': does not contain a boolean value", new CellAddr(cell.getRowIndex(), cell.getColumnIndex()).mapToOneBased(), this.sheet.getSheetName()));
    }

    private Long getInteger(Cell cell) {
        if (cell == null) {
            return null;
        }
        CellValue cellValue = this.evaluator.evaluate(cell);
        if (cellValue == null) {
            return null;
        }
        if (cellValue.getCellType() == CellType.BLANK) {
            return null;
        }
        if (cellValue.getCellType() == CellType.NUMERIC) {
            return (long)(cellValue.getNumberValue() + 0.5);
        }
        throw new ExcelException(String.format("Excel cell [%s in sheet '%s': does not contain an integer value", new CellAddr(cell.getRowIndex(), cell.getColumnIndex()).mapToOneBased(), this.sheet.getSheetName()));
    }

    private Double getFloat(Cell cell) {
        if (cell == null) {
            return null;
        }
        CellValue cellValue = this.evaluator.evaluate(cell);
        if (cellValue == null) {
            return null;
        }
        if (cellValue.getCellType() == CellType.BLANK) {
            return null;
        }
        if (cellValue.getCellType() == CellType.NUMERIC) {
            return cellValue.getNumberValue();
        }
        throw new ExcelException(String.format("Excel cell %s in sheet '%s': does not contain a float value. It actually holds a %s.", new CellAddr(cell.getRowIndex(), cell.getColumnIndex()).mapToOneBased(), this.sheet.getSheetName(), cell.getCellType().name()));
    }

    private LocalDateTime getDate(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == CellType.BLANK) {
            return null;
        }
        if (cell.getCellType() == CellType.NUMERIC && DateUtil.isCellDateFormatted((Cell)cell)) {
            return cell.getLocalDateTimeCellValue();
        }
        if (cell.getCellType() == CellType.FORMULA) {
            Cell cellEval = this.evaluator.evaluateInCell(cell);
            switch (cellEval.getCachedFormulaResultType()) {
                case BLANK: {
                    return null;
                }
                case NUMERIC: {
                    return cellEval.getLocalDateTimeCellValue();
                }
            }
            throw new ExcelException(String.format("Excel formula cell %s in sheet '%s': does not contain a date. It actually holds a %s.", new CellAddr(cell.getRowIndex(), cell.getColumnIndex()).mapToOneBased(), this.sheet.getSheetName(), cell.getCellType().name()));
        }
        throw new ExcelException(String.format("Excel cell %s in sheet '%s': does not contain a date. It actually holds a %s.", new CellAddr(cell.getRowIndex(), cell.getColumnIndex()).mapToOneBased(), this.sheet.getSheetName(), cell.getCellType().name()));
    }

    private String getFormula(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == CellType.BLANK) {
            return null;
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return cell.getCellFormula();
        }
        throw new ExcelException(String.format("Excel cell %s in sheet '%s': does not contain a formula. It actually holds a %s.", new CellAddr(cell.getRowIndex(), cell.getColumnIndex()).mapToOneBased(), this.sheet.getSheetName(), cell.getCellType().name()));
    }

    private String getErrorCode(Cell cell) {
        if (cell == null) {
            return null;
        }
        CellValue cellValue = this.evaluator.evaluate(cell);
        if (cellValue.getCellType() == CellType.ERROR) {
            return cellValue.formatAsString();
        }
        return null;
    }

    private String getDataFormatString(Cell cell) {
        if (cell == null) {
            return null;
        }
        CellStyle style = cell.getCellStyle();
        if (style == null) {
            return null;
        }
        return style.getDataFormatString();
    }

    public String getCellType(CellType type) {
        if (type == CellType.BLANK) {
            return "blank";
        }
        if (type == CellType.STRING) {
            return "string";
        }
        if (type == CellType.BOOLEAN) {
            return "boolean";
        }
        if (type == CellType.NUMERIC) {
            return "numeric";
        }
        if (type == CellType.FORMULA) {
            return "formula";
        }
        if (type == CellType.ERROR) {
            return "error";
        }
        return "unknown";
    }

    private void copyCellValue(Cell from, Cell to) {
        switch (from.getCellType()) {
            case STRING: {
                to.setCellValue(from.getStringCellValue());
                break;
            }
            case NUMERIC: {
                to.setCellValue(from.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                to.setCellValue(from.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                to.setCellFormula(from.getCellFormula());
                break;
            }
            case BLANK: {
                to.setBlank();
                break;
            }
        }
    }

    private XSSFColor toXSSFColor(String colorHtml) {
        Color color = HtmlColor.getColor(colorHtml);
        byte[] rgbColor = new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()};
        return new XSSFColor(rgbColor, null);
    }

    public String buildFooterHeaderString(String text, HeaderFooterPosition position, int fontSizePts, boolean bold) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(HSSFHeader.fontSize((short)((short)fontSizePts)));
        if (bold) {
            tmp.append(HSSFHeader.startBold());
        }
        String s = text;
        s = s.replace("{page}", HSSFHeader.page());
        s = s.replace("{num-pages}", HSSFHeader.numPages());
        s = s.replace("{numPages}", HSSFHeader.numPages());
        s = s.replace("{date}", HSSFHeader.date());
        s = s.replace("{time}", HSSFHeader.time());
        tmp.append(s);
        if (bold) {
            tmp.append(HSSFHeader.endBold());
        }
        return tmp.toString();
    }
}

