/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.callstack;

import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import java.util.function.Supplier;

public class WithCallStack
implements AutoCloseable {
    public WithCallStack(CallFrame callFrame) {
        if (callFrame == null) {
            throw new IllegalArgumentException("A 'callFrame' must not be null");
        }
        ThreadContext.getCallStack().push(callFrame);
    }

    @Override
    public void close() {
        ThreadContext.getCallStack().pop();
    }

    public static <T> T call(CallFrame callFrame, Supplier<T> func) {
        try (WithCallStack cs = new WithCallStack(callFrame);){
            T t = func.get();
            return t;
        }
    }

    public static void run(CallFrame callFrame, Runnable func) {
        try (WithCallStack cs = new WithCallStack(callFrame);){
            func.run();
        }
    }
}

