/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMutable;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.EmptyIterator;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VncMutableList
extends VncSequence
implements VncMutable {
    public static final String TYPE = ":core/mutable-list";
    private static final long serialVersionUID = -1848883965231344442L;
    private final ArrayList<VncVal> value;

    public VncMutableList() {
        this((Collection<? extends VncVal>)null, (VncVal)null);
    }

    public VncMutableList(VncVal meta) {
        this((Collection<? extends VncVal>)null, meta);
    }

    public VncMutableList(Collection<? extends VncVal> vals, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = vals == null ? new ArrayList() : (vals instanceof ArrayList ? (ArrayList<Object>)vals : new ArrayList<VncVal>(vals));
    }

    public static VncMutableList ofAll(Iterable<? extends VncVal> iter) {
        CopyOnWriteArrayList<VncVal> list = new CopyOnWriteArrayList<VncVal>();
        for (VncVal vncVal : iter) {
            list.add(vncVal);
        }
        return new VncMutableList(list, null);
    }

    public static VncMutableList ofAll(Iterable<? extends VncVal> iter, VncVal meta) {
        CopyOnWriteArrayList<VncVal> list = new CopyOnWriteArrayList<VncVal>();
        for (VncVal vncVal : iter) {
            list.add(vncVal);
        }
        return new VncMutableList(list, meta);
    }

    public static VncMutableList of(VncVal ... mvs) {
        return new VncMutableList(Arrays.asList(mvs), (VncVal)Constants.Nil);
    }

    @Override
    public VncMutableList emptyWithMeta() {
        return new VncMutableList(this.getMeta());
    }

    @Override
    public VncMutableList withVariadicValues(VncVal ... replaceVals) {
        return VncMutableList.of(replaceVals).withMeta(this.getMeta());
    }

    @Override
    public VncMutableList withValues(List<? extends VncVal> replaceVals) {
        return new VncMutableList(replaceVals, this.getMeta());
    }

    @Override
    public VncMutableList withValues(List<? extends VncVal> replaceVals, VncVal meta) {
        return new VncMutableList(replaceVals, meta);
    }

    @Override
    public VncMutableList withMeta(VncVal meta) {
        return new VncMutableList(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/sequence"), new VncKeyword(":core/collection"), new VncKeyword(":core/val")));
    }

    @Override
    public Iterator<VncVal> iterator() {
        return this.isEmpty() ? EmptyIterator.empty() : this.value.iterator();
    }

    @Override
    public Stream<VncVal> stream() {
        return this.value.stream();
    }

    @Override
    public void forEach(Consumer<? super VncVal> action) {
        this.value.forEach((? super E v) -> action.accept((VncVal)v));
    }

    @Override
    public VncList filter(Predicate<? super VncVal> predicate) {
        return VncList.ofAll(this.value.stream().filter(predicate), this.getMeta());
    }

    @Override
    public VncList map(Function<? super VncVal, ? extends VncVal> mapper) {
        return VncList.ofAll(this.value.stream().map(mapper), this.getMeta());
    }

    @Override
    public List<VncVal> getJavaList() {
        return this.value;
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public void clear() {
        this.value.clear();
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.value.size()) {
            throw new VncException(String.format("nth: index %d out of range for a mutable list of size %d.", idx, this.size()));
        }
        return this.value.get(idx);
    }

    @Override
    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        return idx >= 0 && idx < this.value.size() ? this.value.get(idx) : defaultVal;
    }

    @Override
    public VncVal first() {
        return this.isEmpty() ? Constants.Nil : this.value.get(0);
    }

    @Override
    public VncVal last() {
        return this.isEmpty() ? Constants.Nil : this.value.get(this.value.size() - 1);
    }

    @Override
    public VncMutableList rest() {
        return this.value.size() <= 1 ? new VncMutableList(this.getMeta()) : this.slice(1);
    }

    @Override
    public VncMutableList butlast() {
        return this.value.size() <= 1 ? new VncMutableList(this.getMeta()) : this.slice(0, this.value.size() - 1);
    }

    @Override
    public VncMutableList drop(int n) {
        return this.slice(n);
    }

    @Override
    public VncMutableList dropWhile(Predicate<? super VncVal> predicate) {
        for (int i = 0; i < this.value.size(); ++i) {
            boolean drop = predicate.test(VncList.of(this.value.get(i)));
            if (drop) continue;
            return this.slice(i);
        }
        return new VncMutableList(this.getMeta());
    }

    @Override
    public VncMutableList dropRight(int n) {
        if (this.value.isEmpty()) {
            return this;
        }
        return n >= this.value.size() ? this.emptyWithMeta() : this.slice(0, this.value.size() - n);
    }

    @Override
    public VncMutableList take(int n) {
        return this.slice(0, n);
    }

    @Override
    public VncMutableList takeWhile(Predicate<? super VncVal> predicate) {
        for (int i = 0; i < this.value.size(); ++i) {
            boolean take = predicate.test(VncList.of(this.value.get(i)));
            if (take) continue;
            return this.slice(0, i);
        }
        return this;
    }

    @Override
    public VncMutableList takeRight(int n) {
        if (n >= this.value.size()) {
            return this;
        }
        return n <= 0 ? this.emptyWithMeta() : this.slice(this.value.size() - n);
    }

    @Override
    public VncMutableList reverse() {
        ArrayList<VncVal> seq = new ArrayList<VncVal>(this.value);
        Collections.reverse(seq);
        return new VncMutableList(seq, this.getMeta());
    }

    @Override
    public VncMutableList shuffle() {
        ArrayList<VncVal> seq = new ArrayList<VncVal>(this.value);
        Collections.shuffle(seq);
        return new VncMutableList(seq, this.getMeta());
    }

    @Override
    public VncMutableList distinct() {
        return new VncMutableList(this.stream().distinct().collect(Collectors.toList()), this.getMeta());
    }

    @Override
    public VncMutableList slice(int start, int end) {
        if (start >= this.value.size()) {
            return new VncMutableList(this.getMeta());
        }
        return new VncMutableList(this.value.subList(start, Math.min(end, this.value.size())), this.getMeta());
    }

    @Override
    public VncMutableList slice(int start) {
        return this.slice(start, this.value.size());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.value, this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.value, this.getMeta());
    }

    @Override
    public VncMutableList addAtStart(VncVal val) {
        this.value.add(0, val);
        return this;
    }

    @Override
    public VncMutableList addAllAtStart(VncSequence list, boolean reverseAdd) {
        List<VncVal> items = list.getJavaList();
        if (reverseAdd) {
            Collections.reverse(items);
        }
        this.value.addAll(0, items);
        return this;
    }

    @Override
    public VncMutableList addAtEnd(VncVal val) {
        this.value.add(val);
        return this;
    }

    @Override
    public VncMutableList addAllAtEnd(VncSequence list) {
        for (VncVal v : list) {
            this.value.add(v);
        }
        return this;
    }

    @Override
    public VncMutableList setAt(int idx, VncVal val) {
        this.value.set(idx, val);
        return this;
    }

    @Override
    public VncMutableList removeAt(int idx) {
        this.value.remove(idx);
        return this;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.MUTABLELIST;
    }

    @Override
    public boolean isVncList() {
        return true;
    }

    @Override
    public Object convertToJavaObject() {
        return this.stream().map((? super T v) -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncMutableList(o)) {
            int c = Integer.compare(this.size(), ((VncMutableList)o).size());
            if (c != 0) {
                return c;
            }
            for (int ii = 0; ii < this.size(); ++ii) {
                c = this.nth(ii).compareTo(((VncMutableList)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncMutableList other = (VncMutableList)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return "(" + Printer.join(this, " ", true) + ")";
    }

    @Override
    public String toString(boolean print_machine_readably) {
        return "(" + Printer.join(this, " ", print_machine_readably) + ")";
    }
}

