/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.threadpool;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadPoolUtil {
    public static ThreadFactory createCountedThreadFactory(String poolName, boolean deamon) {
        return new CountedThreadFactory(poolName, deamon);
    }

    public static class CountedThreadFactory
    implements ThreadFactory {
        private final String poolName;
        private final boolean deamon;
        private final AtomicLong counter = new AtomicLong(1L);

        public CountedThreadFactory(String poolName, boolean deamon) {
            this.poolName = poolName;
            this.deamon = deamon;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(this.deamon);
            thread.setName(this.poolName + "-" + this.counter.getAndIncrement());
            return thread;
        }
    }
}

