/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.threadpool;

import com.github.jlangch.venice.VncException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class ManagedExecutor {
    private ExecutorService executor;

    protected abstract ExecutorService createExecutorService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getExecutor() {
        ManagedExecutor managedExecutor = this;
        synchronized (managedExecutor) {
            if (this.executor == null) {
                this.executor = this.createExecutorService();
            }
            return this.executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean exists() {
        ManagedExecutor managedExecutor = this;
        synchronized (managedExecutor) {
            return this.executor != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isShutdown() {
        ManagedExecutor managedExecutor = this;
        synchronized (managedExecutor) {
            return this.executor == null ? true : this.executor.isShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitTermination(long timeoutMillis) {
        ManagedExecutor managedExecutor = this;
        synchronized (managedExecutor) {
            if (this.executor != null) {
                try {
                    this.executor.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
                }
                catch (Exception ex) {
                    throw new VncException("Failed awaiting for executor termination", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isTerminated() {
        ManagedExecutor managedExecutor = this;
        synchronized (managedExecutor) {
            return this.executor == null ? true : this.executor.isTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        ManagedExecutor managedExecutor = this;
        synchronized (managedExecutor) {
            if (this.executor != null) {
                try {
                    this.executor.shutdown();
                }
                catch (Exception exception) {
                }
                finally {
                    this.executor = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdownNow() {
        ManagedExecutor managedExecutor = this;
        synchronized (managedExecutor) {
            if (this.executor != null) {
                try {
                    this.executor.shutdownNow();
                }
                catch (Exception exception) {
                }
                finally {
                    this.executor = null;
                }
            }
        }
    }
}

