/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.threadpool;

import com.github.jlangch.venice.impl.threadpool.ThreadPoolUtil;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;

public class GlobalThreadFactory {
    private static String defaultName = "venice-thread";
    private static Map<String, ThreadPoolUtil.CountedThreadFactory> threadFactories = new ConcurrentHashMap<String, ThreadPoolUtil.CountedThreadFactory>();

    public static Thread newThread(Runnable runnable) {
        return GlobalThreadFactory.newThread(null, runnable);
    }

    public static Thread newThread(String name, Runnable runnable) {
        ThreadFactory tf = threadFactories.computeIfAbsent(GlobalThreadFactory.makeName(name), n -> new ThreadPoolUtil.CountedThreadFactory((String)n, true));
        return tf.newThread(runnable);
    }

    private static String makeName(String name) {
        String n = StringUtil.trimToNull(name);
        return n == null ? defaultName : n;
    }
}

