/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.thread;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.debug.agent.DebugAgent;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.thread.ThreadContextSnapshot;
import com.github.jlangch.venice.impl.util.CollectionUtil;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import com.github.jlangch.venice.impl.util.callstack.CallStack;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ThreadBridge {
    private final ThreadContextSnapshot parentThreadSnapshot;
    private final boolean deactivateDebugAgent;
    private final CallFrame[] callFrames;

    private ThreadBridge(String name, ThreadContextSnapshot parentThreadSnapshot, boolean deactivateDebugAgent, CallFrame[] callFrames) {
        this.parentThreadSnapshot = parentThreadSnapshot;
        this.deactivateDebugAgent = deactivateDebugAgent;
        this.callFrames = callFrames;
    }

    public static ThreadBridge create(String name) {
        return ThreadBridge.create(name, new CallFrame[0], new Options[0]);
    }

    public static ThreadBridge create(String name, CallFrame callFrame, Options ... options) {
        return ThreadBridge.create(name, new CallFrame[]{callFrame}, options);
    }

    public static ThreadBridge create(String name, CallFrame[] callFrames, Options ... options) {
        HashSet<Options> opts = new HashSet<Options>(CollectionUtil.toList(options));
        boolean deactivateDebugAgent = opts.contains((Object)Options.DEACTIVATE_DEBUG_AGENT);
        ThreadBridge.validateName(name);
        return new ThreadBridge(name, ThreadContext.snapshot(), deactivateDebugAgent, callFrames);
    }

    public <T> Callable<T> bridgeCallable(Callable<T> callable) {
        Callable<Object> wrapper = () -> {
            try {
                ThreadContext.inheritFrom(this.parentThreadSnapshot);
                if (this.callFrames != null) {
                    CallStack cs = ThreadContext.getCallStack();
                    for (CallFrame cf : this.callFrames) {
                        cs.push(cf);
                    }
                }
                if (this.deactivateDebugAgent) {
                    DebugAgent.unregister();
                }
                Object v = callable.call();
                return v;
            }
            finally {
                ThreadContext.remove();
            }
        };
        return wrapper;
    }

    public Runnable bridgeRunnable(Runnable runnable) {
        Runnable wrapper = () -> {
            try {
                ThreadContext.inheritFrom(this.parentThreadSnapshot);
                if (this.deactivateDebugAgent) {
                    DebugAgent.unregister();
                }
                runnable.run();
            }
            finally {
                ThreadContext.remove();
            }
        };
        return wrapper;
    }

    public <T> Consumer<T> bridgeConsumer(Consumer<T> consumer) {
        Consumer<Object> wrapper = t -> {
            try {
                ThreadContext.inheritFrom(this.parentThreadSnapshot);
                if (this.callFrames != null) {
                    CallStack cs = ThreadContext.getCallStack();
                    for (CallFrame cf : this.callFrames) {
                        cs.push(cf);
                    }
                }
                if (this.deactivateDebugAgent) {
                    DebugAgent.unregister();
                }
                consumer.accept(t);
            }
            finally {
                ThreadContext.remove();
            }
        };
        return wrapper;
    }

    public <T, U> BiConsumer<T, U> bridgeBiConsumer(BiConsumer<T, U> consumer) {
        BiConsumer<Object, Object> wrapper = (t, u) -> {
            try {
                ThreadContext.inheritFrom(this.parentThreadSnapshot);
                if (this.callFrames != null) {
                    CallStack cs = ThreadContext.getCallStack();
                    for (CallFrame cf : this.callFrames) {
                        cs.push(cf);
                    }
                }
                if (this.deactivateDebugAgent) {
                    DebugAgent.unregister();
                }
                consumer.accept(t, u);
            }
            finally {
                ThreadContext.remove();
            }
        };
        return wrapper;
    }

    public <T> Supplier<T> bridgeSupplier(Supplier<T> supplier) {
        Supplier<Object> wrapper = () -> {
            try {
                ThreadContext.inheritFrom(this.parentThreadSnapshot);
                if (this.callFrames != null) {
                    CallStack cs = ThreadContext.getCallStack();
                    for (CallFrame cf : this.callFrames) {
                        cs.push(cf);
                    }
                }
                if (this.deactivateDebugAgent) {
                    DebugAgent.unregister();
                }
                Object t = supplier.get();
                return t;
            }
            finally {
                ThreadContext.remove();
            }
        };
        return wrapper;
    }

    public <T, R> Function<T, R> bridgeFunction(Function<T, R> func) {
        Function<Object, Object> wrapper = t -> {
            try {
                ThreadContext.inheritFrom(this.parentThreadSnapshot);
                if (this.callFrames != null) {
                    CallStack cs = ThreadContext.getCallStack();
                    for (CallFrame cf : this.callFrames) {
                        cs.push(cf);
                    }
                }
                if (this.deactivateDebugAgent) {
                    DebugAgent.unregister();
                }
                Object r = func.apply(t);
                return r;
            }
            finally {
                ThreadContext.remove();
            }
        };
        return wrapper;
    }

    public <T, U, R> BiFunction<T, U, R> bridgeBiFunction(BiFunction<T, U, R> func) {
        BiFunction<Object, Object, Object> wrapper = (t, u) -> {
            try {
                ThreadContext.inheritFrom(this.parentThreadSnapshot);
                if (this.callFrames != null) {
                    CallStack cs = ThreadContext.getCallStack();
                    for (CallFrame cf : this.callFrames) {
                        cs.push(cf);
                    }
                }
                if (this.deactivateDebugAgent) {
                    DebugAgent.unregister();
                }
                Object r = func.apply(t, u);
                return r;
            }
            finally {
                ThreadContext.remove();
            }
        };
        return wrapper;
    }

    public boolean isSameAsCurrentThread() {
        return this.parentThreadSnapshot.isSameAsCurrentThread();
    }

    public static void handleUncaughtException(Thread t, Throwable e) {
        if (e instanceof VncException) {
            ((VncException)e).printVeniceStackTrace(System.err);
        } else {
            e.printStackTrace(System.err);
        }
    }

    private static void validateName(String name) {
        if (StringUtil.isBlank(name)) {
            throw new VncException("A ThreadBridge name must not be blank!");
        }
    }

    public static enum Options {
        DEACTIVATE_DEBUG_AGENT;

    }
}

