/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.sandbox;

import com.github.jlangch.venice.impl.sandbox.SandboxFunctionGroups;
import com.github.jlangch.venice.impl.sandbox.SandboxRuleCompiler;
import com.github.jlangch.venice.impl.util.Tuple2;
import com.github.jlangch.venice.javainterop.SandboxRules;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CompiledSandboxRules {
    private final ConcurrentHashMap<Class<?>, String> whiteListedClasses = new ConcurrentHashMap();
    private final ConcurrentHashMap<Tuple2<Class<?>, String>, String> whiteListedMethods = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> whiteListedClasspathResources = new ConcurrentHashMap();
    private final List<Pattern> whiteListClassPatterns;
    private final List<Pattern> whiteListMethodPatterns;
    private final List<Pattern> whiteListClasspathPatterns;
    private final Set<String> blackListVeniceFunctions;
    private final Set<String> whiteListVeniceModules;
    private final Set<String> whiteListSystemProps;
    private final Set<String> whiteListSystemEnvs;
    private final Integer maxExecTimeSeconds;
    private final Integer maxFutureThreadPoolSize;

    private CompiledSandboxRules(List<Pattern> whiteListClassPatterns, List<Pattern> whiteListMethodPatterns, List<Pattern> whiteListClasspathPatterns, Set<String> blackListVeniceFunctions, Set<String> whiteListVeniceModules, Set<String> whiteListSystemProps, Set<String> whiteListSystemEnvs, Integer maxExecTimeSeconds, Integer maxFutureThreadPoolSize) {
        this.whiteListClassPatterns = whiteListClassPatterns == null ? Collections.emptyList() : whiteListClassPatterns;
        this.whiteListMethodPatterns = whiteListMethodPatterns == null ? Collections.emptyList() : whiteListMethodPatterns;
        this.whiteListClasspathPatterns = whiteListClasspathPatterns == null ? Collections.emptyList() : whiteListClasspathPatterns;
        this.blackListVeniceFunctions = blackListVeniceFunctions == null ? Collections.emptySet() : blackListVeniceFunctions;
        this.whiteListVeniceModules = whiteListVeniceModules == null ? Collections.emptySet() : whiteListVeniceModules;
        this.whiteListSystemProps = whiteListSystemProps;
        this.whiteListSystemEnvs = whiteListSystemEnvs;
        this.maxExecTimeSeconds = maxExecTimeSeconds;
        this.maxFutureThreadPoolSize = maxFutureThreadPoolSize;
    }

    public static CompiledSandboxRules compile(SandboxRules sandbox) {
        if (sandbox == null) {
            return new CompiledSandboxRules(null, null, null, null, null, null, null, null, null);
        }
        List<String> rules = sandbox.unique().getRules().stream().filter(s -> s != null).map(s -> s.trim()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        return new CompiledSandboxRules(rules.stream().filter(s -> s.startsWith("class:")).map(s -> s.substring("class:".length())).map(s -> {
            int pos = s.indexOf(58);
            return pos < 0 ? s : s.substring(0, pos);
        }).map(s -> SandboxRuleCompiler.compile(s)).collect(Collectors.toList()), rules.stream().filter(s -> s.startsWith("class:")).map(s -> s.substring("class:".length())).filter(s -> s.indexOf(58) >= 0).map(s -> SandboxRuleCompiler.compile(s)).collect(Collectors.toList()), rules.stream().filter(s -> s.startsWith("classpath:")).map(s -> s.substring("classpath:".length())).map(s -> SandboxRuleCompiler.compile(s)).collect(Collectors.toList()), CompiledSandboxRules.veniceFunctions(rules), rules.stream().filter(s -> s.startsWith("venice:module:")).map(s -> s.substring("venice:module:".length())).collect(Collectors.toSet()), CompiledSandboxRules.allowAccessToAllSystemProperties(rules) ? null : rules.stream().filter(s -> s.startsWith("system.property:")).map(s -> s.substring("system.property:".length())).collect(Collectors.toSet()), CompiledSandboxRules.allowAccessToAllSystemEnvs(rules) ? null : rules.stream().filter(s -> s.startsWith("system.env:")).map(s -> s.substring("system.env:".length())).collect(Collectors.toSet()), sandbox.getMaxExecTimeSeconds(), sandbox.getMaxFutureThreadPoolSize());
    }

    public boolean isWhiteListed(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isArray() || clazz.isPrimitive()) {
            return true;
        }
        if (this.whiteListedClasses.containsKey(clazz)) {
            return true;
        }
        String className = clazz.getName();
        boolean matches = this.whiteListClassPatterns.stream().anyMatch(p -> p.matcher(className).matches());
        if (matches) {
            this.whiteListedClasses.put(clazz, "");
            return true;
        }
        return false;
    }

    public boolean isWhiteListed(Class<?> clazz, String accessor) {
        if (clazz == null || accessor == null) {
            return false;
        }
        if (!this.isWhiteListed(clazz)) {
            return false;
        }
        if (clazz.isArray()) {
            return this.isWhiteListed(clazz.getComponentType());
        }
        Tuple2 tuple = new Tuple2(clazz, accessor);
        if (this.whiteListedMethods.containsKey(tuple)) {
            return true;
        }
        String path = clazz.getName() + ":" + accessor;
        boolean matches = this.whiteListMethodPatterns.stream().anyMatch(p -> p.matcher(path).matches());
        if (matches) {
            this.whiteListedMethods.put(tuple, "");
            return true;
        }
        return false;
    }

    public boolean isWhiteListedClasspathResource(String resource) {
        if (resource == null) {
            return false;
        }
        if (this.whiteListedClasspathResources.containsKey(resource)) {
            return true;
        }
        boolean matches = this.whiteListClasspathPatterns.stream().anyMatch(p -> p.matcher(resource).matches());
        if (matches) {
            this.whiteListedClasspathResources.put(resource, "");
            return true;
        }
        return false;
    }

    public boolean isBlackListedVeniceFunction(String funcName) {
        return this.blackListVeniceFunctions.contains(funcName);
    }

    public boolean isWhiteListedVeniceModule(String moduleName) {
        return this.whiteListVeniceModules.contains(moduleName);
    }

    public boolean isWhiteListedSystemProperty(String property) {
        return this.whiteListSystemProps == null || property != null && this.whiteListSystemProps.contains(property);
    }

    public boolean isWhiteListedSystemEnv(String name) {
        return this.whiteListSystemEnvs == null || name != null && this.whiteListSystemEnvs.contains(name);
    }

    public Integer getMaxExecTimeSeconds() {
        return this.maxExecTimeSeconds;
    }

    public Integer getMaxFutureThreadPoolSize() {
        return this.maxFutureThreadPoolSize;
    }

    private static boolean allowAccessToAllSystemProperties(List<String> rules) {
        return rules.stream().anyMatch(s -> s.equals("system.property:*"));
    }

    private static boolean allowAccessToAllSystemEnvs(List<String> rules) {
        return rules.stream().anyMatch(s -> s.equals("system.env:*"));
    }

    private static Set<String> veniceFunctions(List<String> rules) {
        HashSet<String> blacklisted = new HashSet<String>();
        for (String rule : rules) {
            String r;
            if (rule.startsWith("blacklist:venice:func:")) {
                r = rule.substring("blacklist:venice:func:".length());
                if (SandboxFunctionGroups.isValidGroup(r)) {
                    blacklisted.addAll(SandboxFunctionGroups.groupFunctions(r));
                    continue;
                }
                blacklisted.add(r);
                continue;
            }
            if (!rule.startsWith("whitelist:venice:func:")) continue;
            r = rule.substring("whitelist:venice:func:".length());
            if (SandboxFunctionGroups.isValidGroup(r)) {
                blacklisted.removeAll(SandboxFunctionGroups.groupFunctions(r));
                continue;
            }
            blacklisted.remove(r);
        }
        return blacklisted;
    }
}

