/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.impl.repl.ReplConfig;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ReplRestart {
    public static final int RESTART_EXIT_CODE = 99;
    private static final File RESTART_FILE = new File(".repl.restart");
    private static final DateTimeFormatter dtFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    private final List<String> lines;
    private final LocalDateTime createdAt;
    private final LocalDateTime readAt = LocalDateTime.now();

    private ReplRestart(List<String> lines) {
        this.lines = lines;
        this.createdAt = lines.isEmpty() ? null : ReplRestart.parse(lines.get(0));
    }

    public static void restart(boolean macroExpandOnLoad, ReplConfig.ColorMode colorMode) {
        ReplRestart.write(macroExpandOnLoad, colorMode);
        System.exit(99);
    }

    public static ReplRestart read() {
        try {
            return new ReplRestart(Files.readAllLines(RESTART_FILE.toPath()).stream().map(s -> StringUtil.trimToNull(s)).filter(s -> s != null).collect(Collectors.toList()));
        }
        catch (Exception ex) {
            return new ReplRestart(new ArrayList<String>());
        }
    }

    public static void write(boolean macroEpxandOnLoad, ReplConfig.ColorMode mode) {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(ReplRestart.format(LocalDateTime.now()));
            if (macroEpxandOnLoad) {
                lines.add("-macropexand");
            }
            if (mode != null) {
                lines.add("ColorMode." + mode.name());
            }
            Files.write(RESTART_FILE.toPath(), lines, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean exists() {
        try {
            return RESTART_FILE.exists();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void remove() {
        try {
            RESTART_FILE.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasMacroExpand() {
        try {
            return this.lines.stream().anyMatch(s -> s.equals("-macropexand"));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public ReplConfig.ColorMode getColorMode() {
        try {
            if (this.lines.stream().anyMatch(s -> s.equals("ColorMode.Light"))) {
                return ReplConfig.ColorMode.Light;
            }
            if (this.lines.stream().anyMatch(s -> s.equals("ColorMode.Dark"))) {
                return ReplConfig.ColorMode.Dark;
            }
            return ReplConfig.ColorMode.None;
        }
        catch (Exception ex) {
            return ReplConfig.ColorMode.None;
        }
    }

    public boolean oudated() {
        return this.createdAt == null || ChronoUnit.DAYS.between(this.createdAt, this.readAt) > 30L;
    }

    private static String format(LocalDateTime dt) {
        return dtFormatter.format(dt);
    }

    private static LocalDateTime parse(String s) {
        try {
            return LocalDateTime.parse(s, dtFormatter);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

