/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.thread.ThreadBridge;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import com.github.jlangch.venice.impl.util.callstack.CallStack;
import com.github.jlangch.venice.impl.util.reflect.Boxing;
import com.github.jlangch.venice.impl.util.reflect.ReflectionUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class DynamicInvocationHandler
implements InvocationHandler {
    private final Class<?> clazz;
    private final Map<String, VncFunction> methods;
    private final ThreadBridge threadBridge;
    private final CallFrame callFrameProxy;
    private final boolean java8;

    private DynamicInvocationHandler(Class<?> clazz, Map<String, VncFunction> methods, CallFrame callFrameProxy) {
        this.clazz = clazz;
        this.methods = methods;
        this.threadBridge = ThreadBridge.create("proxy");
        this.callFrameProxy = callFrameProxy;
        this.java8 = "1.8".equals(System.getProperty("java.specification.version"));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        VncFunction fn = this.methods.get(method.getName());
        if (fn != null) {
            VncList fnArgs = DynamicInvocationHandler.toVncArgs(args);
            CallFrame callFrameMethod = new CallFrame("proxy(:" + method.getName() + ")->" + fn.getQualifiedName(), fn.getMeta());
            Callable<Object> impl = () -> {
                CallStack callStack = ThreadContext.getCallStack();
                callStack.push(this.callFrameProxy);
                callStack.push(callFrameMethod);
                try {
                    Object object = fn.apply(fnArgs).convertToJavaObject();
                    return object;
                }
                finally {
                    callStack.pop();
                    callStack.pop();
                }
            };
            if (this.threadBridge.isSameAsCurrentThread()) {
                return impl.call();
            }
            return this.threadBridge.bridgeCallable(() -> impl.call()).call();
        }
        if (method.isDefault()) {
            return this.invokeDefaultMethod(proxy, method, args);
        }
        throw new UnsupportedOperationException(String.format("ProxyMethod %s", method.getName()));
    }

    public static Object proxify(CallFrame callFrame, Class<?> clazz, VncMap handlers) {
        return Proxy.newProxyInstance(DynamicInvocationHandler.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new DynamicInvocationHandler(clazz, DynamicInvocationHandler.handlerMap(handlers), callFrame));
    }

    private static String name(VncVal val) {
        if (Types.isVncKeyword(val)) {
            return ((VncKeyword)val).getValue();
        }
        if (Types.isVncString(val)) {
            return ((VncString)val).getValue();
        }
        throw new VncException("A proxy handler map key must be of type VncKeyword or VncString");
    }

    private static Map<String, VncFunction> handlerMap(VncMap handlers) {
        HashMap<String, VncFunction> map = new HashMap<String, VncFunction>();
        handlers.entries().forEach(e -> {
            VncFunction fn = Coerce.toVncFunction(e.getValue());
            fn.sandboxFunctionCallValidation();
            map.put(DynamicInvocationHandler.name(e.getKey()), fn);
        });
        return map;
    }

    private static VncList toVncArgs(Object[] args) {
        if (args == null || args.length == 0) {
            return VncList.empty();
        }
        VncVal[] vncArgs = new VncVal[args.length];
        for (int ii = 0; ii < args.length; ++ii) {
            vncArgs[ii] = JavaInteropUtil.convertToVncVal(args[ii]);
        }
        return VncList.of(vncArgs);
    }

    private Object invokeDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
        List<Method> methods = ReflectionUtil.getAllPublicDefaultMethods(this.clazz, method.getName(), args == null ? 0 : args.length, false);
        if (methods.size() == 0) {
            throw new UnsupportedOperationException(String.format("ProxyMethod %s", method.getName()));
        }
        Method m = methods.get(0);
        Object[] boxedArgs = Boxing.boxArgs(m.getParameterTypes(), args);
        if (this.java8) {
            Constructor ctor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            ctor.setAccessible(true);
            return ((MethodHandles.Lookup)ctor.newInstance(this.clazz)).in(this.clazz).unreflectSpecial(m, this.clazz).bindTo(proxy).invokeWithArguments(boxedArgs);
        }
        return MethodHandles.lookup().findSpecial(this.clazz, m.getName(), MethodType.methodType(m.getReturnType(), m.getParameterTypes()), this.clazz).bindTo(proxy).invokeWithArguments(boxedArgs);
    }
}

