/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.impl.util.kira.KiraTemplateEvaluator;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import com.github.jlangch.venice.util.pdf.HtmlColor;
import com.github.jlangch.venice.util.pdf.PdfRenderer;
import com.github.jlangch.venice.util.pdf.PdfTextStripper;
import com.github.jlangch.venice.util.pdf.PdfUrlExtractor;
import com.github.jlangch.venice.util.pdf.PdfWatermark;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfReader;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfFunctions {
    private static final String BLACK = "#000000";
    public static VncFunction pdf_render = new VncFunction("pdf/render", (VncVal)VncFunction.meta().arglists("(pdf/render xhtml & options)").doc("Renders a PDF.\n\nOptions: \n\n| :base-url url     | a base url for resources . E.g.: \"classpath:/\"  |\n| :resources resmap | a resource map for dynamic resources              |\n").examples("(do                                                              \n   (load-module :kira)                                           \n                                                                 \n   (defn format-ts [t] (time/format t \"yyyy-MM-dd\"))           \n                                                                 \n   ;; define the template                                        \n   (def template (str/strip-indent                               \n      \"\"\"<?xml version=\"1.0\" encoding=\"UTF-8\"?>           \n      <html lang=\"en\" xmlns=\"http://www.w3.org/1999/xhtml\">  \n        <body>                                                   \n          <div>${ (kira/escape-xml title) }$</div>               \n          <div>${ (kira/escape-xml ts test/format-ts) }$</div>   \n        </body>                                                  \n      </html>                                                    \n      \"\"\"))                                                   \n                                                                 \n   (def data { :title \"Hello, world\"                           \n               :ts (time/local-date 2000 8 1) })                 \n                                                                 \n   (def xhtml (kira/eval template [\"${\" \"}$\"] data))         \n                                                                 \n   (pdf/render xhtml))                                           ", "(pdf/render xhtml :base-url \"classpath:/\")", "(pdf/render xhtml \n            :base-url \"classpath:/\"\n            :resources {\"/chart_1.png\" (chart-create :2018) \n                        \"/chart_2.png\" (chart-create :2019) })").seeAlso("pdf/text-to-pdf").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            VncString xhtml = Coerce.toVncString(args.first());
            VncHashMap options = VncHashMap.ofAll(args.slice(1));
            VncVal baseUrl = ((VncMap)options).get(new VncKeyword("base-url"));
            VncVal resources = ((VncMap)options).get(new VncKeyword("resources"));
            int dotsPerPixel = PdfFunctions.getIntOption("dots-per-pixel", options, 20L);
            float dotsPerPoint = PdfFunctions.getFloatOption("dots-per-point", options, 26.66666603088379);
            return new VncByteBuffer(PdfRenderer.render(xhtml.getValue(), baseUrl == Constants.Nil ? null : Coerce.toVncString(baseUrl).getValue(), resources == Constants.Nil ? null : PdfFunctions.mapResources(Coerce.toVncMap(resources)), dotsPerPixel, dotsPerPoint));
        }
    };
    public static VncFunction pdf_watermark = new VncFunction("pdf/watermark", (VncVal)VncFunction.meta().arglists("(pdf/watermark pdf options-map)", "(pdf/watermark pdf & options)").doc("Adds a watermark text to the pages of a PDF. The passed PDF pdf is a bytebuf. Returns the new PDF as a bytebuf.\n\nOptions: \n\n| :text s              | watermark text (string), defaults to \"WATERMARK\" |\n| :font-size n         | font size in pt (double), defaults to 24.0 |\n| :font-char-spacing n | font character spacing (double), defaults to 0.0 |\n| :color s             | font color (HTML color string), defaults to #000000 |\n| :opacity n           | opacity 0.0 ... 1.0 (double), defaults to 0.4 |\n| :outline-color s     | font outline color (HTML color string), defaults to #000000 |\n| :outline-opacity n   | outline opacity 0.0 ... 1.0 (double), defaults to 0.8 |\n| :outline-witdh n     | outline width  0.0 ... 10.0 (double), defaults to 0.5 |\n| :angle n             | angle 0.0 ... 360.0 (double), defaults to 45.0 |\n| :over-content b      | print text over the content (boolean), defaults to true |\n| :skip-top-pages n    | the number of top pages to skip (long), defaults to 0 |\n| :skip-bottom-pages n | the number of bottom pages to skip (long), defaults to 0 |\n").examples("(pdf/watermark pdf :text \"CONFIDENTIAL\" :font-size 64 :font-char-spacing 10.0)", "(let [watermark { :text \"CONFIDENTIAL\"      \n                  :font-size 64               \n                  :font-char-spacing 10.0 } ] \n   (pdf/watermark pdf watermark))                ").seeAlso("pdf/merge", "pdf/copy", "pdf/pages").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            VncVal pdf = args.first();
            VncMap options = Types.isVncMap(args.second()) ? Coerce.toVncMap(args.second()) : VncHashMap.ofAll(args.slice(1));
            String text = PdfFunctions.getStringOption("text", options, "WATERMARK");
            float fontSize = PdfFunctions.getFloatOption("font-size", options, 24.0);
            float fontCharSpacing = PdfFunctions.getFloatOption("font-char-spacing", options, 0.0);
            Color color = HtmlColor.getColor(PdfFunctions.getStringOption("color", options, PdfFunctions.BLACK));
            float opacity = PdfFunctions.getFloatOption("opacity", options, 0.4);
            Color outlineColor = HtmlColor.getColor(PdfFunctions.getStringOption("outline-color", options, PdfFunctions.BLACK));
            float outlineOpacity = PdfFunctions.getFloatOption("outline-opacity", options, 0.8);
            float outlineWidth = PdfFunctions.getFloatOption("outline-width", options, 0.5);
            float angle = PdfFunctions.getFloatOption("angle", options, 45.0);
            boolean overContent = PdfFunctions.getBooleanOption("over-content", options, true);
            int skipTopPages = PdfFunctions.getIntOption("skip-top-pages", options, 0L);
            int skipBottomPages = PdfFunctions.getIntOption("skip-bottom-pages", options, 0L);
            if (StringUtil.isBlank(text)) {
                return pdf;
            }
            return new VncByteBuffer(new PdfWatermark().addWatermarkText(Coerce.toVncByteBuffer(pdf).getValue(), text, fontSize, fontCharSpacing, color, opacity, outlineColor, outlineOpacity, outlineWidth, angle, overContent, skipTopPages, skipBottomPages));
        }
    };
    public static VncFunction pdf_check_required_libs = new VncFunction("pdf/check-required-libs", (VncVal)VncFunction.meta().arglists("(pdf/check-required-libs)").doc("Checks if the 3rd party libraries required for generating PDFs are available. Throws an exception if not.").examples("(pdf/check-required-libs)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            if (ReflectionAccessor.classExists("com.lowagie.text.Anchor") && ReflectionAccessor.classExists("com.lowagie.text.pdf.PdfCopy") && ReflectionAccessor.classExists("org.xhtmlrenderer.DefaultCSSMarker") && ReflectionAccessor.classExists("org.xhtmlrenderer.pdf.AbstractFormField")) {
                return Constants.Nil;
            }
            throw new VncException("The PDF libraries are not on the classpath! \n\n(do \n  (load-module :maven) \n  (maven/download \"org.xhtmlrenderer:flying-saucer-core:9.3.2\") \n  (maven/download \"org.xhtmlrenderer:lying-saucer-pdf-openpdf:9.3.2\") \n  (maven/download \"com.github.librepdf:openpdf:1.3.35\") \n  (maven/download \"com.github.librepdf:pdf-toolbox:1.3.35\") \n  (maven/download \"com.github.librepdf:openpdf-fonts-extra:1.3.35\")) \n");
        }
    };
    public static VncFunction pdf_available_Q = new VncFunction("pdf/available?", (VncVal)VncFunction.meta().arglists("(pdf/available?)").doc("Checks if the 3rd party libraries required for generating PDFs are available.").examples("(pdf/available?)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            try {
                pdf_check_required_libs.apply(VncList.empty());
                return VncBoolean.True;
            }
            catch (Exception ex) {
                return VncBoolean.False;
            }
        }
    };
    public static VncFunction pdf_merge = new VncFunction("pdf/merge", (VncVal)VncFunction.meta().arglists("(pdf/merge pdfs)").doc("Merge multiple PDFs into a single PDF. The PDFs are passed as bytebuf. Returns the new PDF as a bytebuf.").examples("(pdf/merge pdf1 pdf2)", "(pdf/merge pdf1 pdf2 pdf3)").seeAlso("pdf/copy", "pdf/pages", "pdf/watermark").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            if (args.isEmpty()) {
                throw new VncException("pdf/merge: A PDF list must not be empty");
            }
            if (args.size() == 1) {
                return args.first();
            }
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                Document document = new Document();
                PdfCopy copy = new PdfCopy(document, (OutputStream)os);
                document.open();
                for (VncVal val : args) {
                    if (val == Constants.Nil) continue;
                    ByteBuffer pdf = Coerce.toVncByteBuffer(val).getValue();
                    PdfReader reader = new PdfReader(pdf.array());
                    for (int ii = 1; ii <= reader.getNumberOfPages(); ++ii) {
                        copy.addPage(copy.getImportedPage(reader, ii));
                    }
                    copy.freeReader(reader);
                    reader.close();
                }
                document.close();
                copy.close();
                return new VncByteBuffer(os.toByteArray());
            }
            catch (Exception ex) {
                throw new VncException(String.format("pdf/merge: Failed to merge %d PDFs", args.size()), ex);
            }
        }
    };
    public static VncFunction pdf_copy = new VncFunction("pdf/copy", (VncVal)VncFunction.meta().arglists("(pdf/copy pdf & page-nr)").doc("Copies pages from a PDF to a new PDF. The PDF is passed as bytebuf. Returns the new PDF as a bytebuf.").examples("; copy the first and second page \n(pdf/copy pdf :1 :2)", "; copy the last and second last page \n(pdf/copy pdf :-1 :-2)", "; copy the pages 1, 2, 6-10, and 12 \n(pdf/copy pdf :1 :2 :6-10 :12)").seeAlso("pdf/merge", "pdf/pages", "pdf/watermark").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            ByteBuffer pdf = Coerce.toVncByteBuffer(args.first()).getValue();
            ArrayList<List<Integer>> pages = new ArrayList<List<Integer>>();
            for (VncVal p : args.rest()) {
                String spec = Coerce.toVncKeyword(p).getValue();
                if (spec.matches("^[0-9]+$")) {
                    pages.add(Arrays.asList(Integer.parseInt(spec)));
                    continue;
                }
                if (spec.matches("^-[0-9]+$")) {
                    pages.add(Arrays.asList(Integer.parseInt(spec)));
                    continue;
                }
                if (spec.matches("^[0-9]+-[0-9]+$")) {
                    String[] range = spec.split("-");
                    int start = Integer.parseInt(range[0]);
                    int end = Integer.parseInt(range[1]);
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (int ii = start; ii <= end; ++ii) {
                        arrayList.add(ii);
                    }
                    pages.add(arrayList);
                    continue;
                }
                throw new VncException("pdf/copy: Invalid page specifier " + spec);
            }
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                Document document = new Document();
                PdfCopy copy = new PdfCopy(document, (OutputStream)os);
                document.open();
                PdfReader reader = new PdfReader(pdf.array());
                int numPages = reader.getNumberOfPages();
                for (List list : pages) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        int p = (Integer)iterator.next();
                        int page = p < 0 ? numPages + p + 1 : p;
                        if (page <= 0 || page > numPages) continue;
                        copy.addPage(copy.getImportedPage(reader, page));
                    }
                }
                copy.freeReader(reader);
                reader.close();
                document.close();
                copy.close();
                return new VncByteBuffer(os.toByteArray());
            }
            catch (Exception ex) {
                throw new VncException("pdf/copy: Failed to copy PDFs", ex);
            }
        }
    };
    public static VncFunction pdf_pages = new VncFunction("pdf/pages", (VncVal)VncFunction.meta().arglists("(pdf/pages pdf)").doc("Returns the number of pages of a PDF. The PDF is passed as bytebuf.\n\nUses the openPDF libraries.").examples("(->> (str/lorem-ipsum :paragraphs 30)  \n     (pdf/text-to-pdf)                 \n     (pdf/pages))                        ").seeAlso("pdf/merge", "pdf/copy", "pdf/watermark").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            ByteBuffer pdf = Coerce.toVncByteBuffer(args.first()).getValue();
            try {
                PdfReader reader = new PdfReader(pdf.array());
                int pages = reader.getNumberOfPages();
                reader.close();
                return new VncLong(pages);
            }
            catch (Exception ex) {
                throw new VncException("pdf/pages: Failed to count the PDF's pages", ex);
            }
        }
    };
    public static VncFunction pdf_text_to_pdf = new VncFunction("pdf/text-to-pdf", (VncVal)VncFunction.meta().arglists("(pdf/text-to-pdf text & options)").doc("Creates a PDF from simple text. The tool process line-feeds '\\n' and form-feeds. To start a new page just insert a form-feed marker \"<form-feed>\".\n\nOptions: \n\n| :font-size n      | font size in pt (double), defaults to 9.0 |\n| :font-weight n    | font weight (0...1000) (long), defaults to 200 |\n| :font-monospace b | if true use monospaced font, defaults to false |\n").examples("(->> (pdf/text-to-pdf \"Lorem Ipsum...\")   \n     (io/spit \"text.pdf\"))                  ").seeAlso("pdf/render", "pdf/to-text").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            try {
                String text = Coerce.toVncString(args.first()).getValue();
                VncHashMap options = VncHashMap.ofAll(args.slice(1));
                float fontSize = PdfFunctions.getFloatOption("font-size", options, 9.0);
                int fontWeight = PdfFunctions.getIntOption("font-weight", options, 200L);
                boolean fontMonoSpace = PdfFunctions.getBooleanOption("font-monospace", options, false);
                List pages = PdfFunctions.splitIntoPages(text).stream().map(p -> PdfFunctions.splitIntoLines(p)).collect(Collectors.toList());
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("pages", pages);
                data.put("fontSize", Float.valueOf(fontSize));
                data.put("fontWeight", fontWeight);
                data.put("fontFamiliy", fontMonoSpace ? "Courier" : "Helvetica, Sans-Serif");
                String template = PdfFunctions.loadText2PdfTemplate();
                KiraTemplateEvaluator evaluator = new KiraTemplateEvaluator();
                String xhtml = evaluator.runAsync(() -> evaluator.evaluateKiraTemplate(template, data));
                return new VncByteBuffer(PdfRenderer.render(xhtml));
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException("Failed to render text PDF", ex);
            }
        }
    };
    public static VncFunction pdf_to_text = new VncFunction("pdf/to-text", (VncVal)VncFunction.meta().arglists("(pdf/to-text pdf)").doc("Extracts the text from a PDF.                           \n\npdf may be a:                                           \n\n * string file path, e.g: \"/temp/foo.pdf\"             \n * bytebuffer                                           \n * `java.io.File`, e.g: `(io/file \"/temp/foo.pdf\")`   \n * `java.io.InputStream`                                ").examples("(-> (pdf/text-to-pdf \"Lorem Ipsum...\")   \n    (pdf/to-text)                          \n    (println))                             ").seeAlso("pdf/text-to-pdf", "pdf/render").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            ILoadPaths loadpaths = ThreadContext.getInterceptor().getLoadPaths();
            VncVal arg = args.first();
            try {
                File file = PdfFunctions.convertToFile(arg);
                if (file != null) {
                    ByteBuffer data = loadpaths.loadBinaryResource(file);
                    String text = PdfTextStripper.text(data.array());
                    return new VncString(text);
                }
                if (Types.isVncByteBuffer(arg)) {
                    VncByteBuffer data = (VncByteBuffer)arg;
                    String text = PdfTextStripper.text(data.getBytes());
                    return new VncString(text);
                }
                if (Types.isVncJavaObject(arg, InputStream.class)) {
                    InputStream is = Coerce.toVncJavaObject(args.first(), InputStream.class);
                    String text = PdfTextStripper.text(is);
                    return new VncString(text);
                }
                throw new VncException(String.format("Function 'pdf/to-tex' does not allow %s as pdf input", Types.getType(args.first())));
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException("Failed to extract text from PDF", ex);
            }
        }
    };
    public static VncFunction pdf_extract_urls = new VncFunction("pdf/extract-urls", (VncVal)VncFunction.meta().arglists("(pdf/extract-urls pdf)").doc("Extracts the URLs from a PDF.                           \n\npdf may be a:                                           \n\n * string file path, e.g: \"/temp/foo.pdf\"             \n * bytebuffer                                           \n * `java.io.File`, e.g: `(io/file \"/temp/foo.pdf\")`   \n * `java.io.InputStream`                                \n\nReturns a list of URLs given as maps with the keys:     \n`:url`, `:url-text`, and `:page-num`").examples("(do                                                                      \n   (def xhtml \"\"\"                                                     \n              <?xml version=\"1.0\" encoding=\"UTF-8\"?>                 \n              <html lang=\"en\" xmlns=\"http://www.w3.org/1999/xhtml\">  \n                <body>                                                   \n                   <a href=\"https://github.com/\">GitHub</a>            \n                   <a href=\"https://duckduckgo.com/\">DuckDuckGo</a>    \n                </body>                                                  \n              </html>                                                    \n              \"\"\")                                                    \n                                                                         \n     (pdf/extract-urls (pdf/render xhtml)))                              ").seeAlso("pdf/render").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            ILoadPaths loadpaths = ThreadContext.getInterceptor().getLoadPaths();
            VncVal arg = args.first();
            try {
                File file = PdfFunctions.convertToFile(arg);
                if (file != null) {
                    ByteBuffer data = loadpaths.loadBinaryResource(file);
                    return PdfFunctions.mapPdfUrls(PdfUrlExtractor.extract(data.array()));
                }
                if (Types.isVncByteBuffer(arg)) {
                    VncByteBuffer data = (VncByteBuffer)arg;
                    return PdfFunctions.mapPdfUrls(PdfUrlExtractor.extract(data.getBytes()));
                }
                if (Types.isVncJavaObject(arg, InputStream.class)) {
                    InputStream is = Coerce.toVncJavaObject(args.first(), InputStream.class);
                    return PdfFunctions.mapPdfUrls(PdfUrlExtractor.extract(is));
                }
                throw new VncException(String.format("Function 'pdf/to-tex' does not allow %s as pdf input", Types.getType(args.first())));
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException("Failed to extract text from PDF", ex);
            }
        }
    };
    public static VncFunction pdf_page_to_image = new VncFunction("pdf/page-to-image", (VncVal)VncFunction.meta().arglists("(pdf/page-to-image pdf page-nr)", "(pdf/page-to-image pdf page-nr dpi)").doc("Converts a page from the PDF to an image buffer. \n\nThe passed PDF pdf is a bytebuf. Returns the image buffer as a:java.awt.image.BufferedImage that can be further processed or saved with the  `:images` module. ").seeAlso("pdf/render", "pdf/to-text").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            this.sandboxFunctionCallValidation();
            ByteBuffer pdf = Coerce.toVncByteBuffer(args.first()).getValue();
            long pageNr = Coerce.toVncLong(args.second()).toJavaLong();
            Double dpi = null;
            if (args.size() == 3) {
                if (Types.isVncLong(args.third())) {
                    dpi = Coerce.toVncLong(args.third()).toJavaDouble();
                } else {
                    if (!Types.isVncDouble(args.third())) {
                        throw new VncException(String.format("Function 'page-to-image' does not allow %s as dpi value", Types.getType(args.third())));
                    }
                    dpi = Coerce.toVncDouble(args.third()).toJavaDouble();
                }
            }
            try (PDDocument doc = Loader.loadPDF((byte[])pdf.array());){
                PDFRenderer pdfRenderer = new PDFRenderer(doc);
                BufferedImage img = dpi != null ? pdfRenderer.renderImage((int)pageNr, dpi.floatValue()) : pdfRenderer.renderImage((int)pageNr);
                VncJavaObject vncJavaObject = new VncJavaObject(img);
                return vncJavaObject;
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException("Failed to convert PDF page to an image", ex);
            }
        }
    };
    public static VncFunction pdf_page_count = new VncFunction("pdf/page-count", (VncVal)VncFunction.meta().arglists("(pdf/page-count pdf)").doc("Returns the number of pages in a PDF.\n\nUses the pdfbox libraries.").seeAlso("pdf/render", "pdf/to-text").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            ByteBuffer pdf = Coerce.toVncByteBuffer(args.first()).getValue();
            try (PDDocument doc = Loader.loadPDF((byte[])pdf.array());){
                VncLong vncLong = new VncLong(doc.getNumberOfPages());
                return vncLong;
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException("Failed to get the number of PDF pages", ex);
            }
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(pdf_check_required_libs).add(pdf_available_Q).add(pdf_render).add(pdf_watermark).add(pdf_merge).add(pdf_copy).add(pdf_pages).add(pdf_text_to_pdf).add(pdf_to_text).add(pdf_extract_urls).add(pdf_page_to_image).add(pdf_page_count).toMap();

    private static Map<String, ByteBuffer> mapResources(VncMap resourceMap) {
        HashMap<String, ByteBuffer> resources = new HashMap<String, ByteBuffer>();
        for (VncMapEntry entry : resourceMap.entries()) {
            resources.put(Coerce.toVncString(entry.getKey()).getValue(), Coerce.toVncByteBuffer(entry.getValue()).getValue());
        }
        return resources;
    }

    private static String loadText2PdfTemplate() {
        return new ClassPathResource("com/github/jlangch/venice/templates/text-2-pdf.kira").getResourceAsString();
    }

    private static List<String> splitIntoPages(String text) {
        ArrayList<String> pages = new ArrayList<String>();
        if (StringUtil.isNotEmpty(text)) {
            int lastPos = 0;
            while (lastPos < text.length()) {
                int pos = text.indexOf("\n<form-feed>\n", lastPos);
                if (pos >= 0) {
                    pages.add(text.substring(lastPos, pos));
                    lastPos = pos + "\n<form-feed>\n".length();
                    continue;
                }
                pos = text.indexOf("<form-feed>", lastPos);
                if (pos >= 0) {
                    pages.add(text.substring(lastPos, pos));
                    lastPos = pos + "<form-feed>".length();
                    continue;
                }
                pages.add(text.substring(lastPos));
                break;
            }
        }
        return pages;
    }

    private static List<String> splitIntoLines(String text) {
        return StringUtil.splitIntoLines(text).stream().map(s -> StringUtil.isBlank(s) ? "\u2002" : s).map(s -> StringUtil.replaceLeadingSpaces(s, '\u00a0')).collect(Collectors.toList());
    }

    private static String getStringOption(String optName, VncMap options, String defaultVal) {
        VncVal val = options.get(new VncKeyword(optName), new VncString(defaultVal));
        if (Types.isVncString(val)) {
            return ((VncString)val).getValue();
        }
        throw new VncException("Invalid '" + optName + "' option type " + Types.getType(val) + ". Expected a string!");
    }

    private static float getFloatOption(String optName, VncMap options, double defaultVal) {
        VncVal val = options.get(new VncKeyword(optName), new VncDouble(defaultVal));
        if (Types.isVncLong(val)) {
            return ((VncLong)val).getValue().floatValue();
        }
        if (Types.isVncInteger(val)) {
            return ((VncInteger)val).getValue().floatValue();
        }
        if (Types.isVncDouble(val)) {
            return ((VncDouble)val).toJavaFloat();
        }
        throw new VncException("Invalid '" + optName + "' option type " + Types.getType(val) + ". Expected a double!");
    }

    private static int getIntOption(String optName, VncMap options, long defaultVal) {
        VncVal val = options.get(new VncKeyword(optName), new VncLong(defaultVal));
        if (Types.isVncLong(val)) {
            return ((VncLong)val).getIntValue();
        }
        if (Types.isVncInteger(val)) {
            return ((VncInteger)val).getValue();
        }
        if (Types.isVncDouble(val)) {
            return ((VncDouble)val).getValue().intValue();
        }
        throw new VncException("Invalid '" + optName + "' option type " + Types.getType(val) + ". Expected a long!");
    }

    private static boolean getBooleanOption(String optName, VncMap options, boolean defaultVal) {
        VncVal val = options.get(new VncKeyword(optName), VncBoolean.of(defaultVal));
        if (Types.isVncBoolean(val)) {
            return ((VncBoolean)val).getValue();
        }
        throw new VncException("Invalid '" + optName + "' option type " + Types.getType(val) + ". Expected a boolean!");
    }

    private static File convertToFile(VncVal f) {
        if (Types.isVncString(f)) {
            return new File(((VncString)f).getValue());
        }
        if (Types.isVncJavaObject(f, File.class)) {
            return Coerce.toVncJavaObject(f, File.class);
        }
        if (Types.isVncJavaObject(f, Path.class)) {
            return Coerce.toVncJavaObject(f, Path.class).toFile();
        }
        return null;
    }

    private static VncList mapPdfUrls(List<PdfUrlExtractor.Url> urls) {
        return VncList.ofList(urls.stream().map(u -> VncHashMap.of(new VncKeyword("url"), new VncString(u.getUrl()), new VncKeyword("url-text"), new VncString(u.getUrlText()), new VncKeyword("page-num"), new VncLong(u.getPageNum()))).collect(Collectors.toList()));
    }
}

