/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Map;

public class InetFunctions {
    public static VncFunction ip4_Q = new VncFunction("inet/ip4?", (VncVal)VncFunction.meta().arglists("(inet/ip4? addr)").doc("Returns true if addr is an IPv4 address.").examples("(inet/ip4? \"222.192.0.0\")", "(inet/ip4? (inet/inet-addr \"222.192.0.0\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal addr = args.first();
            if (Types.isVncString(addr)) {
                return VncBoolean.of(((VncString)addr).getValue().contains("."));
            }
            if (Types.isVncJavaObject(addr)) {
                Object inet = ((VncJavaObject)addr).getDelegate();
                return VncBoolean.of(inet instanceof Inet4Address);
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction ip6_Q = new VncFunction("inet/ip6?", (VncVal)VncFunction.meta().arglists("(inet/ip6? addr)").doc("Returns true if addr is an IPv6 address.").examples("(inet/ip6? \"2001:0db8:85a3:08d3:1319:8a2e:0370:7347\")", "(inet/ip6? (inet/inet-addr \"2001:0db8:85a3:08d3:1319:8a2e:0370:7347\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal addr = args.first();
            if (Types.isVncString(addr)) {
                return VncBoolean.of(((VncString)addr).getValue().contains(":"));
            }
            if (Types.isVncJavaObject(addr)) {
                Object inet = ((VncJavaObject)addr).getDelegate();
                return VncBoolean.of(inet instanceof Inet6Address);
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction multicast_addr_Q = new VncFunction("inet/multicast-addr?", (VncVal)VncFunction.meta().arglists("(inet/multicast-addr? addr)").doc("Returns true if addr is a multicast address.").examples("(inet/multicast-addr? \"224.0.0.1\")", "(inet/multicast-addr? (inet/inet-addr \"224.0.0.1\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal addr = args.first();
            if (Types.isVncString(addr)) {
                String ipAddr = ((VncString)addr).getValue();
                try {
                    return VncBoolean.of(InetAddress.getByName(ipAddr).isMulticastAddress());
                }
                catch (Exception ex) {
                    throw new VncException("Not an IP address: '" + ipAddr + "'");
                }
            }
            if (Types.isVncJavaObject(addr, InetAddress.class)) {
                InetAddress inet = Coerce.toVncJavaObject(addr, InetAddress.class);
                return VncBoolean.of(inet.isMulticastAddress());
            }
            throw new VncException("Not an IP address: '" + addr + "'");
        }
    };
    public static VncFunction linklocal_addr_Q = new VncFunction("inet/linklocal-addr?", (VncVal)VncFunction.meta().arglists("(inet/linklocal-addr? addr)").doc("Returns true if addr is a link local address.").examples("(inet/linklocal-addr? \"169.254.0.0\")", "(inet/linklocal-addr? (inet/inet-addr \"169.254.0.0\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal addr = args.first();
            if (Types.isVncString(addr)) {
                String ipAddr = ((VncString)addr).getValue();
                try {
                    return VncBoolean.of(InetAddress.getByName(ipAddr).isLinkLocalAddress());
                }
                catch (Exception ex) {
                    throw new VncException("Not an IP address: '" + ipAddr + "'");
                }
            }
            if (Types.isVncJavaObject(addr, InetAddress.class)) {
                InetAddress inet = Coerce.toVncJavaObject(addr, InetAddress.class);
                return VncBoolean.of(inet.isLinkLocalAddress());
            }
            throw new VncException("Not an IP address: '" + addr + "'");
        }
    };
    public static VncFunction sitelocal_addr_Q = new VncFunction("inet/sitelocal-addr?", (VncVal)VncFunction.meta().arglists("(inet/sitelocal-addr? addr)").doc("Returns true if addr is a site local address.").examples("(inet/sitelocal-addr? \"192.168.0.0\")", "(inet/sitelocal-addr? (inet/inet-addr \"192.168.0.0\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal addr = args.first();
            if (Types.isVncString(addr)) {
                String ipAddr = ((VncString)addr).getValue();
                try {
                    return VncBoolean.of(InetAddress.getByName(ipAddr).isSiteLocalAddress());
                }
                catch (Exception ex) {
                    throw new VncException("Not an IP address: '" + ipAddr + "'");
                }
            }
            if (Types.isVncJavaObject(addr, InetAddress.class)) {
                InetAddress inet = Coerce.toVncJavaObject(addr, InetAddress.class);
                return VncBoolean.of(inet.isSiteLocalAddress());
            }
            throw new VncException("Not an IP address: '" + addr + "'");
        }
    };
    public static VncFunction inet_addr = new VncFunction("inet/inet-addr", (VncVal)VncFunction.meta().arglists("(inet/inet-addr addr)").doc("Converts a stringified IPv4 or IPv6 to a Java InetAddress.").examples("(inet/inet-addr \"222.192.0.0\")", "(inet/inet-addr \"2001:0db8:85a3:08d3:1319:8a2e:0370:7347\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            String ip = Coerce.toVncString(args.first()).getValue();
            try {
                return new VncJavaObject(InetAddress.getByName(ip));
            }
            catch (Exception ex) {
                throw new VncException("Not an IP address: '" + ip + "'");
            }
        }
    };
    public static VncFunction inet_addr_to_bytes = new VncFunction("inet/inet-addr-to-bytes", (VncVal)VncFunction.meta().arglists("(inet/inet-addr-to-bytes addr)").doc("Converts a stringified IPv4/IPv6 address or a Java InetAddress to an InetAddress byte vector.").examples("(inet/inet-addr-to-bytes \"222.192.12.0\")", "(inet/inet-addr-to-bytes \"2001:0db8:85a3:08d3:1319:8a2e:0370:7347\")", "(inet/inet-addr-to-bytes (inet/inet-addr \"222.192.0.0\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal ip = args.first();
            if (Types.isVncString(ip)) {
                String ip_ = ((VncString)ip).getValue();
                try {
                    byte[] bytes = InetAddress.getByName(ip_).getAddress();
                    VncVal[] ints = new VncInteger[bytes.length];
                    for (int ii = 0; ii < bytes.length; ++ii) {
                        ints[ii] = new VncInteger(Byte.toUnsignedInt(bytes[ii]));
                    }
                    return VncVector.of(ints);
                }
                catch (Exception ex) {
                    throw new VncException("Not an IP address: '" + ip_ + "'");
                }
            }
            if (Types.isVncJavaObject(ip, InetAddress.class)) {
                InetAddress ip_ = (InetAddress)((VncJavaObject)ip).getDelegate();
                byte[] bytes = ip_.getAddress();
                VncVal[] ints = new VncInteger[bytes.length];
                for (int ii = 0; ii < bytes.length; ++ii) {
                    ints[ii] = new VncInteger(Byte.toUnsignedInt(bytes[ii]));
                }
                return VncVector.of(ints);
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'inet/in-range?'", Types.getType(ip)));
        }
    };
    public static VncFunction inet_addr_from_bytes = new VncFunction("inet/inet-addr-from-bytes", (VncVal)VncFunction.meta().arglists("(inet/inet-addr-bytes addr)").doc("Converts a IPv4 or IPv6 byte address (a vector of unsigned integers) to a Java InetAddress.").examples("(inet/inet-addr-from-bytes [222I 192I 12I 0I])", "(inet/inet-addr-from-bytes [32I 1I 13I 184I 133I 163I 8I 211I 19I 25I 138I 46I 3I 112I 115I 71I])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncList ints = Coerce.toVncList(args.first());
            try {
                byte[] addr = new byte[ints.size()];
                for (int ii = 0; ii < ints.size(); ++ii) {
                    addr[ii] = Coerce.toVncInteger(ints.nth(ii)).getValue().byteValue();
                }
                return new VncJavaObject(InetAddress.getByAddress(addr));
            }
            catch (Exception ex) {
                throw new VncException("Not an IP address: '" + args.first() + "'");
            }
        }
    };
    public static VncFunction inet_reachable_Q = new VncFunction("inet/reachable?", (VncVal)VncFunction.meta().arglists("(inet/reachable? addr timeout)").doc("Test whether that address is reachable. Best effort is made by the implementation to try to reach the host, but firewalls and server configuration may block requests resulting in a unreachable status while some specific ports may be accessible. A typical implementation will use ICMP ECHO REQUESTs if the privilege can be obtained, otherwise it will try to establish a TCP connection on port 7 (Echo) of the destination host.\n\nThe timeout value, in milliseconds, indicates the maximum amount of time the try should take. If the operation times out before getting an answer, the host is deemed unreachable.").examples("(inet/reachable? \"google.com\" 500)", "(inet/reachable? \"74.125.193.113\" 500)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncString addr = Coerce.toVncString(args.first());
            VncLong timeoutMillis = Coerce.toVncLong(args.second());
            try {
                InetAddress inet = InetAddress.getByName(addr.getValue());
                return VncBoolean.of(inet.isReachable(timeoutMillis.toJavaInteger()));
            }
            catch (Exception ex) {
                throw new VncException("Failed to check address: '" + args.first() + "'");
            }
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(inet_addr).add(ip4_Q).add(ip6_Q).add(multicast_addr_Q).add(linklocal_addr_Q).add(sitelocal_addr_Q).add(inet_addr_to_bytes).add(inet_addr_from_bytes).add(inet_reachable_Q).toMap();
}

