/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.ConcurrencyFunctions;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.IOFunctions;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.aviron.filewatcher.Aviron_FileWatcher_FsWatch;
import com.github.jlangch.venice.impl.util.aviron.filewatcher.Aviron_FileWatcher_JavaWatchService;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import com.github.jlangch.venice.impl.util.io.FileUtil;
import com.github.jlangch.venice.util.OS;
import java.io.File;
import java.io.IOException;
import java.nio.file.StandardWatchEventKinds;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.repackage.com.github.jlangch.aviron.events.FileWatchErrorEvent;
import org.repackage.com.github.jlangch.aviron.events.FileWatchFileEvent;
import org.repackage.com.github.jlangch.aviron.events.FileWatchTerminationEvent;
import org.repackage.com.github.jlangch.aviron.filewatcher.FsWatchMonitor;
import org.repackage.com.github.jlangch.aviron.filewatcher.IFileWatcher;
import org.repackage.com.github.jlangch.aviron.util.service.Service;

public class IOFunctionsFileWatcher {
    public static VncFunction io_watch_dir = new VncFunction("io/watch-dir", (VncVal)VncFunction.meta().arglists("(io/watch-dir dir & options)").doc("Watch a directory for changes, and call the function `event-fn` when it does. Calls the optional `failure-fn` if errors occur. On closing the watcher `termination-fn` is called.\n\nOptions: \n\n| [![width: 25%]] | [![width: 75%]] |\n| :include-all-subdirs true/false | If `true` includes in addtion to the main dir recursively all subdirs. If `false` just watches on the main dir. Defaults to `false`.|\n| :file-fn fn | A four argument function that receives the 'path', a dir? (true if path is a dir), a file? (true if path is a file), and an 'action' {:created, :deleted, :modified} of the changed file. Defaults to `nil`.|\n| :error-fn fn | A two argument function called in error case that receives the watch path and the failure exception. Defaults to `nil`.|\n| :termination-fn fn | A one argument function called when the watcher terminates. It receives the main watch dir.  Defaults to `nil`.|\n\n\nSpecific MacOS options (fswatch): \n\n| [![width: 25%]] | [![width: 75%]] |\n| :fswatch-monitor m | An optional platform dependent monitor {:fsevents_monitor, :kqueue_monitor, :poll_monitor} to use with `fswatch`. Pass `nil` to  let`fswatch` choose the optimal platform. Defaults to `nil`.\u00b6Run `fswatch --list-monitors` to get list of the available platform monitors.|\n| :fswatch-program p |An optional path to the `fswatch` program, e.g.: \"fswatch\", \"/opt/homebrew/bin/fswatch\".\u00b6Defaults to `\"/opt/homebrew/bin/fswatch\"`.|\n\n**Important**\n\nThe *watcher* is a resource that **must be closed** with either `(io/close-watcher w)`  or by using a `(try-with [w (io/watch-dir ...` resource protection statement!\n\n**Linux** \n\nOn Linux the Java WatchService is used to watch dirs for file changes!\n\n**MacOS** \n\nThe Java WatchService doesn't run properly on MacOS due to limitations in the Java WatchService implementation! As a workaround on MacOS the file watcher is impemented on top of the *fswatch* tool. The required *fswatch* tool can be installed from *Homebrew*.\n\n```                        \n   $ brew install fswatch  \n```                        \n\nDocumentation:\n* [fswatch Github](https://github.com/emcrisostomo/fswatch/)\n* [fswatch Manual](https://emcrisostomo.github.io/fswatch/doc/1.17.1/fswatch.html)\n* [fswatch Installation](https://formulae.brew.sh/formula/fswatch)\n").examples("(try-with [w (io/watch-dir \"/tmp\" #(println %1 %2))]    \n  ;; wait 30s and terminate                               \n  (sleep 30 :seconds))                                    ", "(do                                                                          \n  (def dir (io/temp-dir \"watchdir-\"))                                      \n  (io/delete-file-on-exit dir)                                               \n                                                                             \n  (def lock 0)                                                               \n                                                                             \n  (defn log [format & args]                                                  \n    (locking lock (println (apply str/format format args))))                 \n                                                                             \n  (defn file-event [path dir? file? action]                                  \n    (log \"File:       %s %-9s, dir: %b, file: %b\"                          \n         path action dir? file?))                                            \n                                                                             \n  (defn error-event [path exception]                                         \n    (log \"Failure:    %s %s\" path (:message e)))                           \n                                                                             \n  (defn termination-event [path]                                             \n    (log \"Terminated: %s\" path))                                           \n                                                                             \n  (log \"Watching:  %s\" dir)                                                \n                                                                             \n  (try-with [w (io/watch-dir dir                                             \n                   dir                                                       \n                   :include-all-subdirs true                                 \n                   :file-fn             file-event                           \n                   :error-fn            error-event                          \n                   :termination-fn      termination-event)]                  \n                                                                             \n                   ;; on MacOS you might want to add the option              \n                   ;; :fswatch-program  \"/opt/homebrew/bin/fswatch\"        \n                                                                             \n    (let [f (io/file dir \"test1.txt\")]                                     \n      (io/touch-file f)                   ;; created                         \n      (io/delete-file-on-exit f)                                             \n      (sleep 1000)                                                           \n      (io/spit f \"AAA\" :append true)    ;; modifed                         \n      (sleep 1000)                                                           \n      (io/delete-file f))                 ;; deleted                         \n                                                                             \n    ;; wait that all events can be processed before the watcher is closed    \n    (sleep 3000))                                                            \n                                                                             \n  ;; wait to receive the termination event                                   \n  (sleep 1 :seconds))                                                        ").seeAlso("io/registered-watch-dirs", "io/close-watcher", "io/await-for").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File dir = IOFunctions.convertToFile(args.first(), "Function 'io/watch-dir' does not allow %s as file").getAbsoluteFile();
            if (!dir.isDirectory()) {
                throw new VncException(String.format("Function 'io/watch-dir': dir '%s' is not a directory", dir.toString()));
            }
            VncHashMap options = VncHashMap.ofAll(args.rest());
            VncVal registerAllSubDirsOpt = options.get(new VncKeyword("include-all-subdirs"), VncBoolean.False);
            VncVal eventFnOpt = options.get(new VncKeyword("file-fn"));
            VncVal errorFnOpt = options.get(new VncKeyword("error-fn"));
            VncVal terminationFnOpt = options.get(new VncKeyword("termination-fn"));
            VncVal monitorOpt = options.get(new VncKeyword("fswatch-monitor"));
            VncVal fswatchBinaryOpt = options.get(new VncKeyword("fswatch-program"), new VncString("/opt/homebrew/bin/fswatch"));
            VncFunction eventFn = Coerce.toVncFunctionOptional(eventFnOpt);
            VncFunction errorFn = Coerce.toVncFunctionOptional(errorFnOpt);
            VncFunction terminationFn = Coerce.toVncFunctionOptional(terminationFnOpt);
            boolean registerAllSubDirs = Coerce.toVncBoolean(registerAllSubDirsOpt).getValue();
            FsWatchMonitor monitor = monitorOpt == Constants.Nil ? null : FsWatchMonitor.valueOf(Coerce.toVncKeyword(registerAllSubDirsOpt).getSimpleName());
            String fswatchBinary = Coerce.toVncString(fswatchBinaryOpt).toString();
            if (OS.isLinux() || OS.isMacOSX()) {
                try {
                    Service fw = OS.isMacOSX() ? new Aviron_FileWatcher_FsWatch(new CallFrame[]{new CallFrame(this, args)}, dir.toPath(), registerAllSubDirs, IOFunctionsFileWatcher.createFileEventListener(eventFn), IOFunctionsFileWatcher.createErrorEventListener(errorFn), IOFunctionsFileWatcher.createTerminationEventListener(terminationFn), monitor, fswatchBinary) : new Aviron_FileWatcher_JavaWatchService(new CallFrame[]{new CallFrame(this, args)}, dir.toPath(), registerAllSubDirs, IOFunctionsFileWatcher.createFileEventListener(eventFn), IOFunctionsFileWatcher.createErrorEventListener(errorFn), IOFunctionsFileWatcher.createTerminationEventListener(terminationFn));
                    fw.start();
                    return new VncJavaObject(fw);
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Function 'io/watch-dir' failed to watching dir '%s'", dir.toString()), ex);
                }
            }
            throw new VncException("Function 'io/watch-dir' is not supported on this operating system!");
        }
    };
    public static VncFunction io_registered_watch_dirs = new VncFunction("io/registered-watch-dirs", (VncVal)VncFunction.meta().arglists("(io/registered-watch-dirs watcher)").doc("Returns the registred watch directories of a watcher.").seeAlso("io/watch-dir", "io/close-watcher").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            IFileWatcher fw = Coerce.toVncJavaObject(args.first(), IFileWatcher.class);
            return VncList.ofColl(fw.getRegisteredPaths().stream().map(p -> new VncJavaObject(p.toFile())).collect(Collectors.toList()));
        }
    };
    public static VncFunction io_close_watcher = new VncFunction("io/close-watcher", (VncVal)VncFunction.meta().arglists("(io/close-watcher watcher)").doc("Closes a watcher created from 'io/watch-dir'.").seeAlso("io/watch-dir", "io/registered-watch-dirs").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            IFileWatcher fw = Coerce.toVncJavaObject(args.first(), IFileWatcher.class);
            try {
                fw.close();
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException("Function 'io/close-watcher' failed to close watch service", ex);
            }
        }
    };
    public static VncFunction io_await_for = new VncFunction("io/await-for", (VncVal)VncFunction.meta().arglists("(io/await-for timeout time-unit file & modes)").doc("Blocks the current thread until the file has been created, deleted, or modified according to the passed modes {:created, :deleted, :modified}, or the timeout has elapsed. Returns logical false if returning due to timeout, logical true otherwise. \n\nSupported time units are: {:milliseconds, :seconds, :minutes, :hours, :days}").examples("(io/await-for 10 :seconds \"/tmp/data.json\" :created)").seeAlso("io/watch-dir").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 3);
            this.sandboxFunctionCallValidation();
            long timeout = Coerce.toVncLong(args.first()).getValue();
            TimeUnit unit = IOFunctionsFileWatcher.toTimeUnit(Coerce.toVncKeyword(args.second()));
            long timeoutMillis = unit.toMillis(Math.max(0L, timeout));
            File file = IOFunctions.convertToFile(args.third(), "Function 'io/await-for' does not allow %s as file").getAbsoluteFile();
            HashSet events = new HashSet();
            block13: for (VncVal v : args.slice(3)) {
                VncKeyword mode = Coerce.toVncKeyword(v);
                switch (mode.getSimpleName()) {
                    case "created": {
                        events.add(StandardWatchEventKinds.ENTRY_CREATE);
                        continue block13;
                    }
                    case "deleted": {
                        events.add(StandardWatchEventKinds.ENTRY_DELETE);
                        continue block13;
                    }
                    case "modified": {
                        events.add(StandardWatchEventKinds.ENTRY_MODIFY);
                        continue block13;
                    }
                }
                throw new VncException(String.format("Function 'io/await-for' invalid mode '%s'. Use one or multiple of {:created, :deleted, :modified}", mode.toString()));
            }
            if (events.isEmpty()) {
                throw new VncException("Function 'io/await-for' missing a mode. Pass one or multiple of {:created, :deleted, :modified}");
            }
            try {
                return VncBoolean.of(FileUtil.awaitFile(file.getCanonicalFile().toPath(), timeoutMillis, events));
            }
            catch (java.lang.InterruptedException ex) {
                throw new InterruptedException("Interrupted while calling function 'io/await-for'", ex);
            }
            catch (IOException ex) {
                throw new VncException(String.format("Function 'io/await-for' failed to await for file '%s'", file.getPath()), ex);
            }
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(io_watch_dir).add(io_registered_watch_dirs).add(io_close_watcher).add(io_await_for).toMap();

    private static Consumer<FileWatchFileEvent> createFileEventListener(VncFunction fn) {
        return fn == null ? null : event -> ConcurrencyFunctions.future.applyOf(CoreFunctions.partial.applyOf(fn, new VncString(event.getPath().toString()), VncBoolean.of(event.isDir()), VncBoolean.of(event.isFile()), new VncKeyword(event.getType().name().toLowerCase())));
    }

    private static Consumer<FileWatchErrorEvent> createErrorEventListener(VncFunction fn) {
        return fn == null ? null : event -> ConcurrencyFunctions.future.applyOf(CoreFunctions.partial.applyOf(fn, new VncString(event.getPath().toString()), event.getException() == null ? Constants.Nil : new VncJavaObject(event.getException())));
    }

    private static Consumer<FileWatchTerminationEvent> createTerminationEventListener(VncFunction fn) {
        return fn == null ? null : event -> ConcurrencyFunctions.future.applyOf(CoreFunctions.partial.applyOf(fn, new VncString(event.getPath().toString())));
    }

    private static TimeUnit toTimeUnit(VncKeyword unit) {
        switch (unit.getValue()) {
            case "milliseconds": {
                return TimeUnit.MILLISECONDS;
            }
            case "seconds": {
                return TimeUnit.SECONDS;
            }
            case "minutes": {
                return TimeUnit.MINUTES;
            }
            case "hours": {
                return TimeUnit.HOURS;
            }
            case "days": {
                return TimeUnit.DAYS;
            }
        }
        throw new VncException("Invalid time-unit " + unit.getValue() + ". Use one of {:milliseconds, :seconds, :minutes, :hours, :days}");
    }
}

