/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.impl.functions.ArrayFunctions;
import com.github.jlangch.venice.impl.functions.BytebufFunctions;
import com.github.jlangch.venice.impl.functions.CidrFunctions;
import com.github.jlangch.venice.impl.functions.ConcurrencyFunctions;
import com.github.jlangch.venice.impl.functions.CoreConcurrencyFunctions;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.CoreSystemFunctions;
import com.github.jlangch.venice.impl.functions.CronSchedulerFunctions;
import com.github.jlangch.venice.impl.functions.CsvFunctions;
import com.github.jlangch.venice.impl.functions.DagFunctions;
import com.github.jlangch.venice.impl.functions.ExceptionFunctions;
import com.github.jlangch.venice.impl.functions.IOFunctions;
import com.github.jlangch.venice.impl.functions.IOFunctionsFileWatcher;
import com.github.jlangch.venice.impl.functions.IOFunctionsSpitSlurp;
import com.github.jlangch.venice.impl.functions.IOFunctionsStreams;
import com.github.jlangch.venice.impl.functions.IPCFunctions;
import com.github.jlangch.venice.impl.functions.InetFunctions;
import com.github.jlangch.venice.impl.functions.JsonFunctions;
import com.github.jlangch.venice.impl.functions.LoadPathFunctions;
import com.github.jlangch.venice.impl.functions.MBeanFunctions;
import com.github.jlangch.venice.impl.functions.MathFunctions;
import com.github.jlangch.venice.impl.functions.PdfFunctions;
import com.github.jlangch.venice.impl.functions.RegexFunctions;
import com.github.jlangch.venice.impl.functions.SandboxFunctions;
import com.github.jlangch.venice.impl.functions.ScheduleFunctions;
import com.github.jlangch.venice.impl.functions.ShellFunctions;
import com.github.jlangch.venice.impl.functions.StringFunctions;
import com.github.jlangch.venice.impl.functions.SystemFunctions;
import com.github.jlangch.venice.impl.functions.TimeFunctions;
import com.github.jlangch.venice.impl.functions.TransducerFunctions;
import com.github.jlangch.venice.impl.functions.ZipFunctions;
import com.github.jlangch.venice.impl.javainterop.JavaInteropFunctions;
import com.github.jlangch.venice.impl.specialforms.SpecialForms_DefFunctions;
import com.github.jlangch.venice.impl.specialforms.SpecialForms_ImportFunctions;
import com.github.jlangch.venice.impl.specialforms.SpecialForms_LoadCodeMacros;
import com.github.jlangch.venice.impl.specialforms.SpecialForms_MethodFunctions;
import com.github.jlangch.venice.impl.specialforms.SpecialForms_NamespaceFunctions;
import com.github.jlangch.venice.impl.specialforms.SpecialForms_OtherFunctions;
import com.github.jlangch.venice.impl.specialforms.SpecialForms_TryCatchFunctions;
import com.github.jlangch.venice.impl.specialforms.SpecialForms_TypeFunctions;
import com.github.jlangch.venice.impl.specialforms.SpecialForms_VarFunctions;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncVal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Functions {
    public static final Map<VncVal, VncVal> functions = new HashMap<VncVal, VncVal>();

    public static void main(String[] args) {
        System.out.println("// SpecialForms:");
        System.out.print(String.join((CharSequence)",\n", Functions.getSpecialForms()));
        System.out.println(",\n");
        System.out.println("// Module functions:");
        System.out.print(String.join((CharSequence)",\n", Functions.getVncFunctions(LoadPathFunctions.ns)));
        System.out.println(",\n");
        System.out.println();
        System.out.println("// I/O:");
        System.out.print(String.join((CharSequence)",\n", Functions.getIoFunctions()));
        System.out.println(",\n");
        System.out.println();
        System.out.println("// Concurrency:");
        System.out.print(String.join((CharSequence)",\n", Functions.getVncFunctions(ConcurrencyFunctions.ns)));
        System.out.println(",\n");
        System.out.println();
        System.out.println("// Java Interop");
        System.out.print(String.join((CharSequence)",\n", Functions.getVncFunctions(JavaInteropFunctions.ns)));
        System.out.println(",\n");
        System.out.println();
        System.out.println("// Scheduler");
        System.out.print(String.join((CharSequence)",\n", Functions.getVncFunctions(ScheduleFunctions.ns)));
        System.out.println(",\n");
        System.out.println();
        System.out.println("// System");
        System.out.print(String.join((CharSequence)",\n", Functions.getVncFunctions(SystemFunctions.ns)));
        System.out.println(",\n");
        System.out.println();
        System.out.println("// Shell");
        System.out.print(String.join((CharSequence)",\n", Functions.getVncFunctions(ShellFunctions.ns)));
        System.out.println("\n");
    }

    public static List<String> getSpecialForms() {
        return functions.values().stream().filter(f -> f instanceof VncSpecialForm).map(f -> "\"" + ((VncSpecialForm)f).getName() + "\"").sorted().collect(Collectors.toList());
    }

    public static List<String> getIoFunctions() {
        return functions.values().stream().filter(f -> f instanceof VncFunction && "io".equals(((VncFunction)f).getNamespace())).map(f -> "\"" + ((VncFunction)f).getQualifiedName() + "\"").sorted().collect(Collectors.toList());
    }

    public static List<String> getVncFunctions(Map<VncVal, VncVal> ns) {
        return ns.values().stream().filter(f -> f instanceof VncFunction).map(f -> "\"" + ((VncFunction)f).getQualifiedName() + "\"").sorted().collect(Collectors.toList());
    }

    static {
        functions.putAll(SpecialForms_DefFunctions.ns);
        functions.putAll(SpecialForms_ImportFunctions.ns);
        functions.putAll(SpecialForms_TypeFunctions.ns);
        functions.putAll(SpecialForms_MethodFunctions.ns);
        functions.putAll(SpecialForms_NamespaceFunctions.ns);
        functions.putAll(SpecialForms_TryCatchFunctions.ns);
        functions.putAll(SpecialForms_VarFunctions.ns);
        functions.putAll(SpecialForms_OtherFunctions.ns);
        functions.putAll(SpecialForms_LoadCodeMacros.ns);
        functions.putAll(CoreFunctions.ns);
        functions.putAll(CoreConcurrencyFunctions.ns);
        functions.putAll(CoreSystemFunctions.ns);
        functions.putAll(ExceptionFunctions.ns);
        functions.putAll(BytebufFunctions.ns);
        functions.putAll(TransducerFunctions.ns);
        functions.putAll(LoadPathFunctions.ns);
        functions.putAll(StringFunctions.ns);
        functions.putAll(RegexFunctions.ns);
        functions.putAll(ArrayFunctions.ns);
        functions.putAll(MathFunctions.ns);
        functions.putAll(IOFunctions.ns);
        functions.putAll(IOFunctionsFileWatcher.ns);
        functions.putAll(IOFunctionsSpitSlurp.ns);
        functions.putAll(IOFunctionsStreams.ns);
        functions.putAll(IPCFunctions.ns);
        functions.putAll(ZipFunctions.ns);
        functions.putAll(TimeFunctions.ns);
        functions.putAll(ShellFunctions.ns);
        functions.putAll(SystemFunctions.ns);
        functions.putAll(MBeanFunctions.ns);
        functions.putAll(SandboxFunctions.ns);
        functions.putAll(ScheduleFunctions.ns);
        functions.putAll(CronSchedulerFunctions.ns);
        functions.putAll(ConcurrencyFunctions.ns);
        functions.putAll(JsonFunctions.ns);
        functions.putAll(PdfFunctions.ns);
        functions.putAll(JavaInteropFunctions.ns);
        functions.putAll(InetFunctions.ns);
        functions.putAll(CidrFunctions.ns);
        functions.putAll(CsvFunctions.ns);
        functions.putAll(DagFunctions.ns);
    }
}

