/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;

public class FunctionMetaBuilder {
    private final HashMap<VncVal, VncVal> meta = new HashMap();

    public FunctionMetaBuilder arglists(String ... arglists) {
        this.meta.put(MetaUtil.ARGLIST, this.toVncList(arglists));
        return this;
    }

    public FunctionMetaBuilder doc(String doc) {
        this.meta.put(MetaUtil.DOC, new VncString(doc));
        return this;
    }

    public FunctionMetaBuilder added(String version) {
        this.meta.put(MetaUtil.ADDED, new VncString(version));
        return this;
    }

    public FunctionMetaBuilder examples(String ... examples) {
        this.meta.put(MetaUtil.EXAMPLES, this.toVncList(examples));
        return this;
    }

    public FunctionMetaBuilder seeAlso(String ... refs) {
        this.meta.put(MetaUtil.SEE_ALSO, this.toVncList(refs));
        return this;
    }

    public FunctionMetaBuilder functionRefs(String ... refs) {
        this.meta.put(MetaUtil.FUNCTION_REFS, this.toVncList(refs));
        return this;
    }

    public FunctionMetaBuilder privateFn() {
        this.meta.put(MetaUtil.PRIVATE, VncBoolean.True);
        return this;
    }

    public VncHashMap build() {
        return new VncHashMap(this.meta);
    }

    private VncList toVncList(String ... strings) {
        return VncList.ofList(Arrays.stream(strings).map(r -> new VncString((String)r)).collect(Collectors.toList()));
    }
}

