/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.examples;

import com.github.jlangch.venice.IPreCompiled;
import com.github.jlangch.venice.Parameters;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.javainterop.SandboxRules;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class Embed_15_RuleEngine {
    public static void main(String[] args) {
        try {
            Embed_15_RuleEngine.run();
        }
        catch (VncException ex) {
            ex.printVeniceStackTrace();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public static void run() {
        Configuration config = new Configuration();
        config.setValue("rules.cart.discount", "(do                                                            \n  (defn calculate [cart coupon]                                \n    (case coupon                                               \n      ;; \"10% Off Coupon\"                                    \n      \"SUMMER10\"    { :discount  10.0, :freeship  false }    \n                                                               \n      ;; \"Free Shipping Coupon\"                              \n      \"FREESHIP\"    { :discount  0.0, :freeship  true }      \n                                                               \n      ;; \"Buy Many Get 30% Off\"                              \n      \"BMGOF\"       (if (>= (. cart :getItemCount) 2)        \n                        { :discount 30.0, :freeship false }    \n                        { :discount 0.0, :freeship false })    \n                                                               \n      { :discount  0.0, :freeship  false } ))                  \n                                                               \n  (calculate cart coupon))                                     ");
        Cart cart = new Cart();
        cart.addIem(new CartItem(new Product("Bottle of water", 1.4), 1));
        DiscountRules rules = new DiscountRules(config);
        rules.refresh();
        System.out.println("Discount #1: " + rules.calculate(cart, "SUMMER10"));
        System.out.println("Discount #2: " + rules.calculate(cart, "FREESHIP"));
        System.out.println("Discount #3: " + rules.calculate(cart, "BMGOF"));
        System.out.println("Discount #4: " + rules.calculate(cart, null));
    }

    public static class DiscountRules {
        private final Configuration config;
        private final Venice venice;
        private final AtomicReference<IPreCompiled> rule = new AtomicReference();

        public DiscountRules(Configuration config) {
            this.config = config;
            this.venice = new Venice(new SandboxRules().rejectAllUnsafeFunctions().withClasses("com.github.jlangch.venice.examples.*:*").whitelistVeniceFunctions(".").sandbox());
            this.rule.set(DiscountRules.compileRule(this.venice, config));
        }

        public Discount calculate(Cart cart, String coupon) {
            Map event = (Map)this.venice.eval(this.rule.get(), Parameters.of("cart", cart, "coupon", coupon));
            return new Discount((Double)event.get("discount"), (Boolean)event.get("freeship"));
        }

        public void refresh() {
            this.rule.set(DiscountRules.compileRule(this.venice, this.config));
        }

        private static IPreCompiled compileRule(Venice venice, Configuration config) {
            return venice.precompile("rule", config.getValue("rules.cart.discount"), true);
        }
    }

    public static class Discount {
        private final double discounPercentage;
        private final boolean freeshipping;

        public Discount(double discounPercentage, boolean freeshipping) {
            this.discounPercentage = discounPercentage;
            this.freeshipping = freeshipping;
        }

        public double getDiscounPercentage() {
            return this.discounPercentage;
        }

        public boolean isFreeshipping() {
            return this.freeshipping;
        }

        public String toString() {
            return String.format("discount: %.1f, free shipping: %b", this.discounPercentage, this.freeshipping);
        }
    }

    public static class Cart {
        private final List<CartItem> items = new ArrayList<CartItem>();

        public void addIem(CartItem item) {
            this.items.add(item);
        }

        public int getItemCount() {
            return this.items.size();
        }

        public List<CartItem> getItems() {
            return Collections.unmodifiableList(this.items);
        }
    }

    public static class CartItem {
        private final Product product;
        private final int quantity;

        public CartItem(Product product, int quantity) {
            this.product = product;
            this.quantity = quantity;
        }

        public Product getProduct() {
            return this.product;
        }

        public int getQuantity() {
            return this.quantity;
        }
    }

    public static class Product {
        private final String name;
        private final double price;

        public Product(String name, double price) {
            this.name = name;
            this.price = price;
        }

        public String getName() {
            return this.name;
        }

        public double getPrice() {
            return this.price;
        }
    }

    public static class Configuration {
        private final HashMap<String, String> config = new HashMap();

        public String getValue(String key) {
            return this.config.get(key);
        }

        public void setValue(String key, String value) {
            this.config.put(key, value);
        }
    }
}

