/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.servlet;

public enum HttpStatus {
    HTTP_CONTINUE(100, "Continue"),
    HTTP_SWITCHING_PROTOCOLS(101, "Switching Protocols"),
    HTTP_PROCESSING(102, "Processing"),
    HTTP_OK(200, "OK"),
    HTTP_CREATED(201, "Created"),
    HTTP_ACCEPTED(202, "Accepted"),
    HTTP_NOT_AUTHORITATIVE(203, "Non-Authoritative Information"),
    HTTP_NO_CONTENT(204, "No Content"),
    HTTP_RESET(205, "Reset Content"),
    HTTP_PARTIAL(206, "Partial Content"),
    HTTP_MULTI_STATUSL(207, "Multi-Status"),
    HTTP_ALREADY_REPORTED(208, "Already Reported"),
    HTTP_IM_USED(226, "IM Used"),
    HTTP_MULT_CHOICE(300, "Multiple Choices"),
    HTTP_MOVED_PERM(301, "Moved Permanently"),
    HTTP_MOVED_TEMP(302, "Temporary Redirect"),
    HTTP_SEE_OTHER(303, "See Other"),
    HTTP_NOT_MODIFIED(304, "Not Modified"),
    HTTP_USE_PROXY(305, "Use Proxy"),
    HTTP_TEMPORARY_REDIRECT(307, "Temporary Redirect"),
    HTTP_BAD_REQUEST(400, "Bad Request"),
    HTTP_UNAUTHORIZED(401, "Unauthorized"),
    HTTP_PAYMENT_REQUIRED(402, "Payment Required"),
    HTTP_FORBIDDEN(403, "Forbidden"),
    HTTP_NOT_FOUND(404, "Not Found"),
    HTTP_BAD_METHOD(405, "Method Not Allowed"),
    HTTP_NOT_ACCEPTABLE(406, "Not Acceptable"),
    HTTP_PROXY_AUTH(407, "Proxy Authentication Required"),
    HTTP_CLIENT_TIMEOUT(408, "Request Time-Out"),
    HTTP_CONFLICT(409, "Conflict"),
    HTTP_GONE(410, "Gone"),
    HTTP_LENGTH_REQUIRED(411, "Length Required"),
    HTTP_PRECON_FAILED(412, "Precondition Failed"),
    HTTP_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
    HTTP_REQ_TOO_LONG(414, "Request-URI Too Large"),
    HTTP_UNSUPPORTED_TYPE(415, "Unsupported Media Type"),
    HTTP_REQUESTED_RANGE_NOT_SATISFIABLE(416, "Requested Range Not Satisfiable"),
    HTTP_EXPECTATION_FAILED(417, "Expectation Failed"),
    HTTP_I_AM_A_TEAPOT(418, "I'm a teapot"),
    HTTP_INSUFFICIENT_SPACE_ON_RESOURCE(419, "Insufficient Space on Resource"),
    HTTP_METHOD_FAILURE(420, "Method Failure"),
    HTTP_DESTINATION_LOCKED(421, "Destination Locked"),
    HTTP_UNPROCESSABLE_ENTITY(422, "Unprocessable Entity"),
    HTTP_LOCKED(423, "Locked"),
    HTTP_FAILED_DEPENDENCY(424, "Failed Dependency"),
    HTTP_TOO_EARLY(425, "Too Early"),
    HTTP_UPGRADE_REQUIRED(426, "Upgrade Required"),
    HTTP_PRECONDITION_REQUIRED(428, "Precondition Required"),
    HTTP_TOO_MANY_REQUESTS(429, "Too Many Requests"),
    HTTP_REQUEST_HEADER_FIELDS_TOO_LARGE(431, "Request Header Fields Too Large"),
    HTTP_UNAVAILABLE_FOR_LEGAL_REASON(451, "Unavailable For Legal Reasons "),
    HTTP_INTERNAL_ERROR(500, "Internal Server Error"),
    HTTP_NOT_IMPLEMENTED(501, "Not Implemented"),
    HTTP_BAD_GATEWAY(502, "Bad Gateway"),
    HTTP_UNAVAILABLE(503, "Service Unavailable"),
    HTTP_GATEWAY_TIMEOUT(504, "Gateway Timeout"),
    HTTP_VERSION(505, "HTTP Version Not Supported"),
    HTTP_VARIANT_ALSO_NEGOTIATES(506, "Variant Also Negotiates"),
    HTTP_INSUFFICIENT_STORAGE(507, "Insufficient Storage"),
    HTTP_LOOP_DETECTED(508, "Loop Detected"),
    HTTP_NOT_EXTENDED(510, "Not Extended"),
    HTTP_NETWORK_AUTH_REQUIRED(511, "Network Authentication Required");

    private final int code;
    private final String description;

    public int code() {
        return this.code;
    }

    public String description() {
        return this.description;
    }

    public static HttpStatus of(int code) {
        for (HttpStatus s : HttpStatus.values()) {
            if (s.code() != code) continue;
            return s;
        }
        throw new RuntimeException("Invalid HttpStatus code " + code);
    }

    public static boolean isOkRange(int code) {
        return code >= 200 && code <= 299;
    }

    public static boolean isRedirectRange(int code) {
        return code >= 300 && code <= 399;
    }

    public static boolean isClientRange(int code) {
        return code >= 400 && code <= 499;
    }

    public static boolean isServerErrorRange(int code) {
        return code >= 500 && code <= 599;
    }

    public String toString() {
        return this.name();
    }

    private HttpStatus(int code, String description) {
        this.code = code;
        this.description = description;
    }
}

