/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.excel;

import com.github.jlangch.venice.impl.util.excel.ExcelColumnDef;
import com.github.jlangch.venice.impl.util.excel.ExcelSheet;
import com.github.jlangch.venice.util.excel.CellAddr;
import com.github.jlangch.venice.util.excel.CellRangeAddr;
import com.github.jlangch.venice.util.excel.DataRecord;
import com.github.jlangch.venice.util.excel.ExcelColumnBuilder;
import com.github.jlangch.venice.util.excel.ExcelFacade;
import com.github.jlangch.venice.util.excel.ExcelSumFormulaBuilder;
import com.github.jlangch.venice.util.excel.Formula;
import com.github.jlangch.venice.util.excel.HeaderFooterPosition;
import com.github.jlangch.venice.util.excel.PageOrientation;
import com.github.jlangch.venice.util.excel.PaperSize;
import com.github.jlangch.venice.util.excel.chart.AreaDataSeries;
import com.github.jlangch.venice.util.excel.chart.BarDataSeries;
import com.github.jlangch.venice.util.excel.chart.BarGrouping;
import com.github.jlangch.venice.util.excel.chart.ImageType;
import com.github.jlangch.venice.util.excel.chart.LineDataSeries;
import com.github.jlangch.venice.util.excel.chart.PieDataSeries;
import com.github.jlangch.venice.util.excel.chart.Position;
import com.github.jlangch.venice.util.pdf.HtmlColor;
import java.awt.Color;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.util.CellAddress;

public class ExcelSheetFacade<T> {
    public static final int DEFAULT_FONT_SIZE = 11;
    private final ExcelFacade parentBuilder;
    private final ExcelSheet sheet;
    private final List<ExcelColumnDef<T>> columnDefs = new ArrayList<ExcelColumnDef<T>>();
    private boolean noHeader = false;
    private boolean headerRendered = false;
    private int currRow0 = 0;
    private int skipRows = 0;
    private Integer columnWidth;
    private String defaultHeaderStyle;
    private String defaultBodyStyle;
    private String defaultFooterStyle;

    public ExcelSheetFacade(ExcelFacade excelBuilder, ExcelSheet sheet) {
        this.parentBuilder = excelBuilder;
        this.sheet = sheet;
    }

    public String getName() {
        return this.sheet.getName();
    }

    public int getIndex() {
        return this.sheet.getIndex() + 1;
    }

    public void setPrintLayout(PaperSize paperSize, PageOrientation orientation, double headerMarginInches, double footerMarginInches, boolean gridLines, boolean fitToWidthOnly, boolean fitToPage) {
        this.sheet.setPrintLayout(paperSize, orientation, headerMarginInches, footerMarginInches, gridLines, fitToWidthOnly, fitToPage);
    }

    public void setPageMargins(double leftInches, double rightInches, double topInches, double bottomInches) {
        this.sheet.setPageMargins(leftInches, rightInches, topInches, bottomInches);
    }

    public void setHeaderMargin(double inches) {
        this.sheet.setHeaderMargin(inches);
    }

    public void setFooterMargin(double inches) {
        this.sheet.setFooterMargin(inches);
    }

    public void setHeader(String text, HeaderFooterPosition position, int fontSizePts, boolean bold) {
        this.sheet.setHeader(text, position, fontSizePts, bold);
    }

    public void setFooter(String text, HeaderFooterPosition position, int fontSizePts, boolean bold) {
        this.sheet.setFooter(text, position, fontSizePts, bold);
    }

    public void setDisplayGridlines(boolean display) {
        this.sheet.setDisplayGridlines(display);
    }

    public int getFirstRowNum() {
        int n = this.sheet.getFirstRowNum();
        return n < 0 ? n : n + 1;
    }

    public int getLastRowNum() {
        int n = this.sheet.getLastRowNum();
        return n < 0 ? n : n + 1;
    }

    public int getFirstCellNum(int row1) {
        int n = this.sheet.getFirstCellNum(row1 - 1);
        return n < 0 ? n : n + 1;
    }

    public int getLastCellNum(int row1) {
        int n = this.sheet.getLastCellNum(row1 - 1);
        return n;
    }

    public void protectSheet(String password) {
        this.sheet.protectSheet(password);
    }

    public boolean isCellEmpty(int row1, int col1) {
        return this.sheet.isCellEmpty(row1 - 1, col1 - 1);
    }

    public String getCellType(int row1, int col1) {
        return this.sheet.getCellType(row1 - 1, col1 - 1);
    }

    public void lock(int row1, int col1, boolean locked) {
        this.sheet.lock(row1 - 1, col1 - 1, locked);
    }

    public boolean isLocked(int row1, int col1) {
        return this.sheet.isLocked(row1 - 1, col1 - 1);
    }

    public boolean isHidden(int row1, int col1) {
        return this.sheet.isHidden(row1 - 1, col1 - 1);
    }

    public boolean isColumnHidden(int col1) {
        return this.sheet.isColumnHidden(col1 - 1);
    }

    public String getFormula(int row1, int col1) {
        return this.sheet.getFormula(row1 - 1, col1 - 1);
    }

    public String getDataFormatString(int row1, int col1) {
        return this.sheet.getDataFormatString(row1 - 1, col1 - 1);
    }

    public ExcelSheetFacade<T> evaluateAllFormulas() {
        this.sheet.evaluateAllFormulas();
        return this;
    }

    public void evaluateCell(int row1, int col1) {
        this.sheet.evaluateCell(row1 - 1, col1 - 1);
    }

    public ExcelFacade end() {
        return this.parentBuilder;
    }

    public void deleteRow(int row1) {
        this.sheet.deleteRow(row1 - 1);
    }

    public void copyRow(int row1From, int row1To, boolean copyValues, boolean copyStyles) {
        this.sheet.copyRow(row1From - 1, row1To - 1, copyValues, copyStyles);
    }

    public void copyRowToEndOfSheet(int row1, boolean copyValues, boolean copyStyles) {
        this.sheet.copyRowToEndOfSheet(row1 - 1, copyValues, copyStyles);
    }

    public void clearRow(int row1, boolean clearValues, boolean clearStyles) {
        this.sheet.clearRow(row1 - 1, clearValues, clearStyles);
    }

    public void insertEmptyRow(int row1) {
        this.sheet.insertEmptyRow(row1 - 1);
    }

    public void insertEmptyRows(int row1, int count) {
        this.sheet.insertEmptyRows(row1 - 1, count);
    }

    public void copyCellStyle(int cellRowFrom1, int cellColFrom1, int cellRowTo1, int cellColTo1) {
        this.sheet.copyCellStyle(cellRowFrom1 - 1, cellColFrom1 - 1, cellRowTo1 - 1, cellColTo1 - 1);
    }

    public void addConditionalBackgroundColor(String condRule, String colorHtml, int regionFirstRow1, int regionLastRow1, int regionFirstCol1, int regionLastCol1) {
        this.sheet.addConditionalBackgroundColor(condRule, colorHtml, regionFirstRow1 - 1, regionLastRow1 - 1, regionFirstCol1 - 1, regionLastCol1 - 1);
    }

    public void addConditionalFontColor(String condRule, String colorHtml, int regionFirstRow1, int regionLastRow1, int regionFirstCol1, int regionLastCol1) {
        this.sheet.addConditionalFontColor(condRule, colorHtml, regionFirstRow1 - 1, regionLastRow1 - 1, regionFirstCol1 - 1, regionLastCol1 - 1);
    }

    public void addConditionalBorder(String condRule, BorderStyle borderTopStyle, BorderStyle borderRightStyle, BorderStyle borderBottomStyle, BorderStyle borderLeftStyle, String borderTopColorHtml, String borderRightColorHtml, String borderBottomColorHtml, String borderLeftColorHtml, int regionFirstRow1, int regionLastRow1, int regionFirstCol1, int regionLastCol1) {
        this.sheet.addConditionalBorder(condRule, borderTopStyle, borderRightStyle, borderBottomStyle, borderLeftStyle, borderTopColorHtml, borderRightColorHtml, borderBottomColorHtml, borderLeftColorHtml, regionFirstRow1 - 1, regionLastRow1 - 1, regionFirstCol1 - 1, regionLastCol1 - 1);
    }

    public void addTextDataValidation(List<String> validValues, boolean emptyCellAllowed, String errTitle, String errText, int regionFirstRow1, int regionLastRow1, int regionFirstCol1, int regionLastCol1) {
        this.sheet.addTextDataValidation(validValues, emptyCellAllowed, errTitle, errText, regionFirstRow1 - 1, regionLastRow1 - 1, regionFirstCol1 - 1, regionLastCol1 - 1);
    }

    public ExcelSheetFacade<T> noHeader() {
        this.noHeader = true;
        return this;
    }

    public ExcelSheetFacade<T> createFreezePane(int cols, int rows) {
        this.sheet.createFreezePane(Math.max(0, cols), Math.max(0, rows));
        return this;
    }

    public ExcelSheetFacade<T> defaultHeaderStyle(String style) {
        this.defaultHeaderStyle = style;
        return this;
    }

    public ExcelSheetFacade<T> defaultBodyStyle(String style) {
        this.defaultBodyStyle = style;
        return this;
    }

    public ExcelSheetFacade<T> defaultFooterStyle(String style) {
        this.defaultFooterStyle = style;
        return this;
    }

    public ExcelColumnBuilder<T> withColumn(String colHeaderName) {
        return new ExcelColumnBuilder<T>(this, this.columnDefs, colHeaderName);
    }

    public ExcelColumnBuilder<T> withColumn(String colHeaderName, Function<? super T, ?> colMapper) {
        return new ExcelColumnBuilder<T>(this, this.columnDefs, colHeaderName).colMapper(colMapper);
    }

    public ExcelColumnBuilder<T> withColumn(String colHeaderName, String fieldName) {
        return new ExcelColumnBuilder<Object>(this, this.columnDefs, colHeaderName).colMapper(e -> ((DataRecord)e).get(fieldName));
    }

    public ExcelSheetFacade<T> renderItems(List<T> items) {
        this.renderHeader();
        int bodyRowStart = this.currRow0;
        items.forEach(v -> this.renderBodyItem(v));
        int bodyRowEnd = this.currRow0 - 1;
        this.renderFooter(bodyRowStart, bodyRowEnd);
        return this;
    }

    public ExcelSheetFacade<T> renderItem(T item) {
        this.renderHeader();
        this.renderBodyItem(item);
        return this;
    }

    public ExcelSheetFacade<T> value(int row1, int col1, Object value) {
        this.sheet.setValue(row1 - 1, col1 - 1, value);
        return this;
    }

    public ExcelSheetFacade<T> value(int row1, int col1, Object value, String stylename) {
        this.sheet.setValue(row1 - 1, col1 - 1, value, stylename);
        return this;
    }

    public ExcelSheetFacade<T> valueKeepCellStyle(int row1, int col1, Object value) {
        this.sheet.setValueKeepCellStyle(row1 - 1, col1 - 1, value);
        return this;
    }

    public ExcelSheetFacade<T> image(int row1, int col1, byte[] data, ImageType type, Double scaleX, Double scaleY) {
        this.sheet.addImage(new CellAddr(row1, col1), data, type, scaleX, scaleY);
        return this;
    }

    public ExcelSheetFacade<T> lineChart(String title, CellRangeAddr areaCellRangeAddr, Position legendPosition, String categoryAxisTitle, Position categoryAxisPosition, String valueAxisTitle, Position valueAxisPosition, boolean threeDimensional, boolean varyColors, CellRangeAddr categoriesCellRangeAddr, List<LineDataSeries> series) {
        CellRangeAddr area = areaCellRangeAddr.mapToZeroBased();
        this.sheet.addLineChart(title, new CellRangeAddr(area.getFirstRow(), area.getLastRow() + 1, area.getFirstCol(), area.getLastCol() + 1), legendPosition, categoryAxisTitle, categoryAxisPosition, valueAxisTitle, valueAxisPosition, threeDimensional, varyColors, categoriesCellRangeAddr.mapToZeroBased(), series.stream().map(s -> s.mapToZeroBasedAddresses()).collect(Collectors.toList()));
        return this;
    }

    public ExcelSheetFacade<T> barChart(String title, CellRangeAddr areaCellRangeAddr, Position legendPosition, String categoryAxisTitle, Position categoryAxisPosition, String valueAxisTitle, Position valueAxisPosition, boolean threeDimensional, boolean directionBar, BarGrouping grouping, boolean varyColors, CellRangeAddr categoriesCellRangeAddr, List<BarDataSeries> series) {
        CellRangeAddr area = areaCellRangeAddr.mapToZeroBased();
        this.sheet.addBarChart(title, new CellRangeAddr(area.getFirstRow(), area.getLastRow() + 1, area.getFirstCol(), area.getLastCol() + 1), legendPosition, categoryAxisTitle, categoryAxisPosition, valueAxisTitle, valueAxisPosition, threeDimensional, directionBar, grouping, varyColors, categoriesCellRangeAddr.mapToZeroBased(), series.stream().map(s -> s.mapToZeroBasedAddresses()).collect(Collectors.toList()));
        return this;
    }

    public ExcelSheetFacade<T> areaChart(String title, CellRangeAddr areaCellRangeAddr, Position legendPosition, String categoryAxisTitle, Position categoryAxisPosition, String valueAxisTitle, Position valueAxisPosition, boolean threeDimensional, CellRangeAddr categoriesCellRangeAddr, List<AreaDataSeries> series) {
        CellRangeAddr area = areaCellRangeAddr.mapToZeroBased();
        this.sheet.addAreaChart(title, new CellRangeAddr(area.getFirstRow(), area.getLastRow() + 1, area.getFirstCol(), area.getLastCol() + 1), legendPosition, categoryAxisTitle, categoryAxisPosition, valueAxisTitle, valueAxisPosition, threeDimensional, categoriesCellRangeAddr.mapToZeroBased(), series.stream().map(s -> s.mapToZeroBasedAddresses()).collect(Collectors.toList()));
        return this;
    }

    public ExcelSheetFacade<T> pieChart(String title, CellRangeAddr areaCellRangeAddr, Position legendPosition, boolean threeDimensional, boolean varyColors, CellRangeAddr categoriesCellRangeAddr, List<PieDataSeries> series) {
        CellRangeAddr area = areaCellRangeAddr.mapToZeroBased();
        this.sheet.addPieChart(title, new CellRangeAddr(area.getFirstRow(), area.getLastRow() + 1, area.getFirstCol(), area.getLastCol() + 1), legendPosition, threeDimensional, varyColors, categoriesCellRangeAddr.mapToZeroBased(), series.stream().map(s -> s.mapToZeroBasedAddresses()).collect(Collectors.toList()));
        return this;
    }

    public ExcelSheetFacade<T> formula(int row1, int col1, String formula) {
        this.sheet.setFormula(row1 - 1, col1 - 1, formula);
        return this;
    }

    public ExcelSheetFacade<T> formula(int row1, int col1, String formula, String stylename) {
        this.sheet.setFormula(row1 - 1, col1 - 1, formula, stylename);
        return this;
    }

    public ExcelSheetFacade<T> style(int row1, int col1, String stylename) {
        this.sheet.setStyle(row1 - 1, col1 - 1, stylename);
        return this;
    }

    public ExcelSheetFacade<T> bgColor(int row1, int col1, Color bgColor) {
        this.sheet.setBgColor(row1 - 1, col1 - 1, bgColor);
        return this;
    }

    public ExcelSheetFacade<T> bgColor(int row1, int col1, String bgColorHtml) {
        this.sheet.setBgColor(row1 - 1, col1 - 1, HtmlColor.getColor(bgColorHtml));
        return this;
    }

    public ExcelSheetFacade<T> bgColor(int row1, int col1, short bgColor) {
        this.sheet.setBgColorIndex(row1 - 1, col1 - 1, bgColor);
        return this;
    }

    public ExcelSumFormulaBuilder<T> withSum(int row1, int col1) {
        return new ExcelSumFormulaBuilder(this, this.sheet, row1, col1);
    }

    public ExcelSheetFacade<T> skipRows(int count) {
        this.skipRows = Math.max(0, count);
        return this;
    }

    public ExcelSheetFacade<T> rowHeightInPoints(int row1, int height) {
        this.sheet.setRowHeightInPoints(row1 - 1, height);
        return this;
    }

    public ExcelSheetFacade<T> colWidthInPoints(int row1, int width) {
        this.sheet.setColumnWidthInPoints(row1 - 1, width);
        return this;
    }

    public ExcelSheetFacade<T> autoSizeColumns() {
        this.sheet.autoSizeColumns();
        return this;
    }

    public ExcelSheetFacade<T> autoSizeColumn(int col1) {
        this.sheet.autoSizeColumn(col1 - 1);
        return this;
    }

    public ExcelSheetFacade<T> hideColumn(int col1) {
        this.sheet.setColumnHidden(col1 - 1, true);
        return this;
    }

    public ExcelSheetFacade<T> hideColumns(int ... col1s) {
        for (int c : col1s) {
            this.hideColumn(c);
        }
        return this;
    }

    public ExcelSheetFacade<T> hideColumn(String colID) {
        if (colID != null) {
            int colNr1 = 1;
            for (ExcelColumnDef<T> colDef : this.columnDefs) {
                if (colID.equals(colDef.id)) {
                    this.hideColumn(colNr1);
                    break;
                }
                ++colNr1;
            }
        }
        return this;
    }

    public ExcelSheetFacade<T> hideColumns(String ... colIDs) {
        for (String id : colIDs) {
            this.hideColumn(id);
        }
        return this;
    }

    public ExcelSheetFacade<T> addMergedRegion(int rowFrom1, int rowTo1, int colFrom1, int colTo1) {
        this.sheet.addMergedRegion(rowFrom1 - 1, rowTo1 - 1, colFrom1 - 1, colTo1 - 1);
        return this;
    }

    public ExcelSheetFacade<T> displayZeros(boolean value) {
        this.sheet.setDisplayZeros(value);
        return this;
    }

    public ExcelSheetFacade<T> setDefaultColumnWidthInPoints(int width) {
        this.columnWidth = width;
        return this;
    }

    public String sumFormula(int rowFrom1, int rowTo1, int colFrom1, int colTo1) {
        return String.format("SUM(%s:%s)", this.sheet.getCellAddress_A1_style(rowFrom1 - 1, colFrom1 - 1), this.sheet.getCellAddress_A1_style(rowTo1 - 1, colTo1 - 1));
    }

    public void setUrlHyperlink(int row1, int col1, String text, String urlAddress) {
        this.sheet.setUrlHyperlink(row1 - 1, col1 - 1, text, urlAddress);
    }

    public void setEmailHyperlink(int row1, int col1, String text, String emailAddress) {
        this.sheet.setEmailHyperlink(row1 - 1, col1 - 1, text, emailAddress);
    }

    public void removeFormula(int row1, int col1) {
        this.sheet.removeFormula(row1 - 1, col1 - 1);
    }

    public void removeHyperlink(int row1, int col1) {
        this.sheet.removeHyperlink(row1 - 1, col1 - 1);
    }

    public void removeComment(int row1, int col1) {
        this.sheet.removeComment(row1 - 1, col1 - 1);
    }

    public Map<String, Object> getCellStyleInfo(int row1, int col1) {
        return this.sheet.getCellStyleInfo(row1 - 1, col1 - 1);
    }

    public String cellAddress_A1_style(int row1, int col1) {
        return this.sheet.getCellAddress_A1_style(row1 - 1, col1 - 1);
    }

    public String getCellFormulaResultType(int row1, int col1) {
        return this.sheet.getCellFormulaResultType(row1 - 1, col1 - 1);
    }

    public String getCellAddress_A1_style(int row1, int col1) {
        return this.sheet.getCellAddress_A1_style(row1 - 1, col1 - 1);
    }

    public Object getValue(int row1, int col1) {
        return this.sheet.getValue(row1 - 1, col1 - 1);
    }

    public String getString(int row1, int col1) {
        return this.sheet.getString(row1 - 1, col1 - 1);
    }

    public Boolean getBoolean(int row1, int col1) {
        return this.sheet.getBoolean(row1 - 1, col1 - 1);
    }

    public Long getInteger(int row1, int col1) {
        return this.sheet.getInteger(row1 - 1, col1 - 1);
    }

    public Double getFloat(int row1, int col1) {
        return this.sheet.getFloat(row1 - 1, col1 - 1);
    }

    public LocalDateTime getDate(int row1, int col1) {
        return this.sheet.getDate(row1 - 1, col1 - 1);
    }

    public String getErrorCode(int row1, int col1) {
        return this.sheet.getErrorCode(row1 - 1, col1 - 1);
    }

    private String getColumnHeaderStyle(int col0) {
        String style = col0 < 0 || col0 > this.columnDefs.size() - 1 ? null : this.columnDefs.get((int)col0).headerStyle;
        return style == null ? this.defaultHeaderStyle : style;
    }

    private String getColumnBodyStyle(int col0) {
        String style = col0 < 0 || col0 > this.columnDefs.size() - 1 ? null : this.columnDefs.get((int)col0).bodyStyle;
        return style == null ? this.defaultBodyStyle : style;
    }

    private String getColumnFooterStyle(int col0) {
        String style = col0 < 0 || col0 > this.columnDefs.size() - 1 ? null : this.columnDefs.get((int)col0).footerStyle;
        return style == null ? this.defaultFooterStyle : style;
    }

    private List<String> getHeaderStrings() {
        return this.columnDefs.stream().map(c -> c.header).collect(Collectors.toList());
    }

    private void setHeaderValues(int row0, List<?> values) {
        int col0 = 0;
        for (Object v : values) {
            if (v != null) {
                this.sheet.setValue(row0, col0, v, this.getColumnHeaderStyle(col0));
            }
            ++col0;
        }
    }

    private boolean hasFooter() {
        return this.columnDefs.stream().anyMatch(c -> c.footerType != ExcelColumnDef.FooterType.NONE);
    }

    private void renderHeader() {
        if (!this.headerRendered) {
            this.renderColumnWidths();
            if (!this.noHeader) {
                this.setHeaderValues(this.currRow0++, this.getHeaderStrings());
            }
            this.headerRendered = true;
        }
    }

    private void renderFooter(int bodyRowFrom0, int bodyRowTo0) {
        boolean emptyBody;
        boolean bl = emptyBody = bodyRowTo0 < bodyRowFrom0;
        if (this.hasFooter()) {
            int col0 = 0;
            for (ExcelColumnDef<T> colDef : this.columnDefs) {
                switch (colDef.footerType) {
                    case NONE: {
                        this.sheet.setValue(this.currRow0, col0, null, null);
                        break;
                    }
                    case TEXT: {
                        this.sheet.setValue(this.currRow0, col0, colDef.footerValue, this.getColumnFooterStyle(col0));
                        break;
                    }
                    case NUMBER: {
                        this.sheet.setValue(this.currRow0, col0, colDef.footerValue, this.getColumnFooterStyle(col0));
                        break;
                    }
                    case FORMULA: {
                        this.sheet.setValue(this.currRow0, col0, null, null);
                        break;
                    }
                    case SUM: {
                        if (emptyBody) {
                            this.sheet.setValue(this.currRow0, col0, null, null);
                            break;
                        }
                        String formula = String.format("SUM(%s:%s)", new CellAddress(bodyRowFrom0, col0).formatAsString(), new CellAddress(bodyRowTo0, col0).formatAsString());
                        this.sheet.setFormula(this.currRow0, col0, formula, this.getColumnFooterStyle(col0));
                        break;
                    }
                    case MIN: {
                        if (emptyBody) {
                            this.sheet.setValue(this.currRow0, col0, null, this.getColumnFooterStyle(col0));
                            break;
                        }
                        String formula = String.format("MIN(%s:%s)", new CellAddress(bodyRowFrom0, col0).formatAsString(), new CellAddress(bodyRowTo0, col0).formatAsString());
                        this.sheet.setFormula(this.currRow0, col0, formula, this.getColumnFooterStyle(col0));
                        break;
                    }
                    case MAX: {
                        if (emptyBody) {
                            this.sheet.setValue(this.currRow0, col0, null, this.getColumnFooterStyle(col0));
                            break;
                        }
                        String formula = String.format("MAX(%s:%s)", new CellAddress(bodyRowFrom0, col0).formatAsString(), new CellAddress(bodyRowTo0, col0).formatAsString());
                        this.sheet.setFormula(this.currRow0, col0, formula, this.getColumnFooterStyle(col0));
                        break;
                    }
                    case AVERAGE: {
                        if (emptyBody) {
                            this.sheet.setValue(this.currRow0, col0, null, this.getColumnFooterStyle(col0));
                            break;
                        }
                        String formula = String.format("AVERAGE(%s:%s)", new CellAddress(bodyRowFrom0, col0).formatAsString(), new CellAddress(bodyRowTo0, col0).formatAsString());
                        this.sheet.setFormula(this.currRow0, col0, formula, this.getColumnFooterStyle(col0));
                    }
                }
                ++col0;
            }
        }
        ++this.currRow0;
    }

    private void renderBodyItem(T item) {
        if (this.skipRows > 0) {
            --this.skipRows;
        } else {
            if (item != null) {
                int col0 = 0;
                for (ExcelColumnDef<T> colDef : this.columnDefs) {
                    if (colDef.colMapper != null) {
                        Object cellVal = colDef.colMapper.apply(item);
                        if (cellVal instanceof Formula) {
                            this.sheet.setFormula(this.currRow0, col0, ((Formula)cellVal).getFormula());
                        } else {
                            this.sheet.setValue(this.currRow0, col0, cellVal, this.getColumnBodyStyle(col0));
                        }
                    }
                    ++col0;
                }
            }
            ++this.currRow0;
        }
    }

    private void renderColumnWidths() {
        int col0 = 0;
        for (ExcelColumnDef<T> colDef : this.columnDefs) {
            if (colDef.width != null) {
                this.sheet.setColumnWidthInPoints(col0, colDef.width);
            } else if (this.columnWidth != null) {
                this.sheet.setColumnWidthInPoints(col0, this.columnWidth);
            }
            ++col0;
        }
    }
}

