/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util;

import java.util.concurrent.TimeUnit;

public class StopWatch {
    private long startTime = 0L;
    private long elapsedTime = 0L;
    private long limitTime = 0L;

    public StopWatch() {
        this(System.currentTimeMillis(), 0L, 0L);
    }

    public StopWatch(TimeUnit unit, long n) {
        this(System.currentTimeMillis(), 0L, unit == null ? n : TimeUnit.MILLISECONDS.convert(n, unit));
    }

    private StopWatch(long startTime, long elapsedTime, long limitMilliseconds) {
        this.startTime = startTime;
        this.elapsedTime = elapsedTime;
        this.limitTime = startTime + limitMilliseconds;
    }

    public StopWatch copy() {
        return new StopWatch(this.startTime, this.elapsedTime, this.limitTime);
    }

    public StopWatch start() {
        this.startTime = System.currentTimeMillis();
        this.elapsedTime = 0L;
        return this;
    }

    public StopWatch resume() {
        this.startTime = System.currentTimeMillis();
        return this;
    }

    public StopWatch stop() {
        this.elapsedTime += this.splitTime();
        this.startTime = System.currentTimeMillis();
        return this;
    }

    public long elapsed(TimeUnit unit) {
        return unit == null ? this.elapsedTime : unit.convert(this.elapsedTime, TimeUnit.MILLISECONDS);
    }

    public long splitTime(TimeUnit unit) {
        return unit == null ? this.splitTime() : unit.convert(this.splitTime(), TimeUnit.MILLISECONDS);
    }

    public long splitTime() {
        return Math.max(0L, System.currentTimeMillis() - this.startTime);
    }

    public String elapsedMillisFormatted() {
        return StopWatch.formatMillis(this.elapsedTime);
    }

    public boolean hasExpired() {
        return this.limitTime == 0L ? false : System.currentTimeMillis() > this.limitTime;
    }

    public String toString() {
        return StopWatch.formatMillis(this.elapsedTime);
    }

    public static String formatMillis(long millis) {
        if (millis < 1000L) {
            return String.format("%dms", millis);
        }
        if (millis < 60000L) {
            return String.format("%ds %dms", millis / 1000L, millis % 1000L);
        }
        long seconds = millis / 1000L;
        return String.format("%dm %ds", seconds / 60L, seconds % 60L);
    }
}

