/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util;

import com.github.jlangch.venice.util.NullOutputStream;
import java.io.PrintStream;
import java.util.function.Consumer;

public class CallbackPrintStream
extends PrintStream {
    private final Consumer<String> printer;
    private final StringBuilder sb = new StringBuilder();
    private final boolean autoFlush;

    public CallbackPrintStream(boolean autoFlush, Consumer<String> printer) {
        super(new NullOutputStream());
        this.autoFlush = autoFlush;
        this.printer = printer;
    }

    @Override
    public PrintStream append(CharSequence csq) {
        this.print(csq == null ? "null" : csq.toString());
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.print(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.print(c);
        return this;
    }

    @Override
    public void print(boolean x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(int x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(long x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(float x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(double x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(char x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(char[] x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(Object x) {
        this.print(String.valueOf(x));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(String s) {
        CallbackPrintStream callbackPrintStream = this;
        synchronized (callbackPrintStream) {
            this.sb.append(s);
            if (this.autoFlush && s.indexOf(10) >= 0) {
                this.flush();
            }
        }
    }

    @Override
    public void println() {
        this.println("");
    }

    @Override
    public void println(boolean x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(int x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(long x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(float x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(double x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(char x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(char[] x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(Object x) {
        this.println(String.valueOf(x));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String s) {
        CallbackPrintStream callbackPrintStream = this;
        synchronized (callbackPrintStream) {
            this.sb.append(s).append(System.lineSeparator());
            if (this.autoFlush) {
                this.flush();
            }
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        throw new RuntimeException("Method write(byte[],int,int) is not supported");
    }

    @Override
    public void write(int b) {
        throw new RuntimeException("Method write(int) is not supported");
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        CallbackPrintStream callbackPrintStream = this;
        synchronized (callbackPrintStream) {
            if (this.sb.length() > 0) {
                this.printer.accept(this.sb.toString());
                this.sb.setLength(0);
            }
        }
    }
}

