/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util;

import java.util.ArrayList;
import java.util.List;

public class AsciiCanvas {
    private static final String ESC = "\u001b";
    private static final String ANSI_RESET = "\u001b[0m";
    private final int width;
    private final int height;
    private final Cell[][] canvas;

    public AsciiCanvas(int width, int height) {
        if (width < 1 || width > 1000) {
            throw new IllegalArgumentException("A width must be in the range [1..1000]");
        }
        if (height < 1 || height > 1000) {
            throw new IllegalArgumentException("A height must be in the range [1..1000]");
        }
        this.width = width;
        this.height = height;
        this.canvas = new Cell[height][width];
        this.clear();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public char getCharAt(int x, int y) {
        if (x < 0 || x >= this.width) {
            throw new IndexOutOfBoundsException("The x is out of bounds [0," + (this.width - 1) + "]");
        }
        if (y < 0 || y >= this.height) {
            throw new IndexOutOfBoundsException("The y is out of bounds [0," + (this.height - 1) + "]");
        }
        return this.getCellAt(x, y).val;
    }

    public String getFormatAt(int x, int y) {
        if (x < 0 || x >= this.width) {
            throw new IndexOutOfBoundsException("The x is out of bounds [0," + (this.width - 1) + "]");
        }
        if (y < 0 || y >= this.height) {
            throw new IndexOutOfBoundsException("The y is out of bounds [0," + (this.height - 1) + "]");
        }
        return this.getCellAt(x, y).format;
    }

    public AsciiCanvas clear() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.canvas[y][x] = new Cell();
            }
        }
        return this;
    }

    public AsciiCanvas draw(char ch, int x, int y) {
        this.draw(ch, x, y, "");
        return this;
    }

    public AsciiCanvas draw(char ch, int x, int y, String ansiFormat) {
        if (this.inbound(x, y)) {
            this.canvas[y][x] = new Cell(ch, ansiFormat);
        }
        return this;
    }

    public AsciiCanvas drawText(String text, int x, int y) {
        this.drawHorizontalRight(text, x, y, "");
        return this;
    }

    public AsciiCanvas drawText(String text, int x, int y, String ansiFormat) {
        this.drawHorizontalRight(text, x, y, ansiFormat);
        return this;
    }

    public AsciiCanvas drawHorizontalRight(String str, int x, int y) {
        this.drawHorizontalRight(str, x, y, "");
        return this;
    }

    public AsciiCanvas drawHorizontalRight(String str, int x, int y, String ansiFormat) {
        if (str == null) {
            return this;
        }
        int ii = 0;
        for (char ch : str.toCharArray()) {
            this.draw(ch, x + ii++, y, ansiFormat);
        }
        return this;
    }

    public AsciiCanvas drawHorizontalRight(char ch, int repeat, int x, int y) {
        this.drawHorizontalRight(ch, repeat, x, y, "");
        return this;
    }

    public AsciiCanvas drawHorizontalRight(char ch, int repeat, int x, int y, String ansiFormat) {
        for (int ii = 0; ii < repeat; ++ii) {
            this.draw(ch, x + ii, y, ansiFormat);
        }
        return this;
    }

    public AsciiCanvas drawHorizontalLeft(String str, int x, int y) {
        this.drawHorizontalLeft(str, x, y, "");
        return this;
    }

    public AsciiCanvas drawHorizontalLeft(String str, int x, int y, String ansiFormat) {
        if (str == null) {
            return this;
        }
        int ii = 0;
        for (char ch : str.toCharArray()) {
            this.draw(ch, x + ii--, y, ansiFormat);
        }
        return this;
    }

    public AsciiCanvas drawHorizontalLeft(char ch, int repeat, int x, int y) {
        this.drawHorizontalLeft(ch, repeat, x, y, "");
        return this;
    }

    public AsciiCanvas drawHorizontalLeft(char ch, int repeat, int x, int y, String ansiFormat) {
        for (int ii = 0; ii < repeat; ++ii) {
            this.draw(ch, x - ii, y, ansiFormat);
        }
        return this;
    }

    public AsciiCanvas drawVerticalUp(String str, int x, int y) {
        if (str == null) {
            return this;
        }
        this.drawVerticalUp(str, x, y, "");
        return this;
    }

    public AsciiCanvas drawVerticalUp(String str, int x, int y, String ansiFormat) {
        if (str == null) {
            return this;
        }
        int ii = 0;
        for (char ch : str.toCharArray()) {
            this.draw(ch, x, y + ii++, ansiFormat);
        }
        return this;
    }

    public AsciiCanvas drawVerticalUp(char ch, int repeat, int x, int y) {
        this.drawVerticalUp(ch, repeat, x, y, "");
        return this;
    }

    public AsciiCanvas drawVerticalUp(char ch, int repeat, int x, int y, String ansiFormat) {
        for (int ii = 0; ii < repeat; ++ii) {
            this.draw(ch, x, y + ii, ansiFormat);
        }
        return this;
    }

    public AsciiCanvas drawVerticalDown(String str, int x, int y) {
        if (str == null) {
            return this;
        }
        this.drawVerticalDown(str, x, y, "");
        return this;
    }

    public AsciiCanvas drawVerticalDown(String str, int x, int y, String ansiFormat) {
        if (str == null) {
            return this;
        }
        int ii = 0;
        for (char ch : str.toCharArray()) {
            this.draw(ch, x, y + ii--, ansiFormat);
        }
        return this;
    }

    public AsciiCanvas drawVerticalDown(char ch, int repeat, int x, int y) {
        this.drawVerticalDown(ch, repeat, x, y, "");
        return this;
    }

    public AsciiCanvas drawVerticalDown(char ch, int repeat, int x, int y, String ansiFormat) {
        for (int ii = 0; ii < repeat; ++ii) {
            this.draw(ch, x, y - ii, ansiFormat);
        }
        return this;
    }

    public AsciiCanvas box(int x, int y, int w, int h, String border) {
        this.box(x, y, w, h, border, "");
        return this;
    }

    public AsciiCanvas box(int x, int y, int w, int h, String border, String ansiFormat) {
        if (border == null || border.length() != 8) {
            throw new IllegalArgumentException("The box' border must have 8 chars: [topLeft,topRight,bottomRight,bottomLeft,topBar,rightBar,bottomBar,leftBar]. E.g. \"\u250c\u2510\u2518\u2514\u2500\u2502\u2500\u2502\"");
        }
        char topLeft = border.charAt(0);
        char topRight = border.charAt(1);
        char bottomRight = border.charAt(2);
        char bottomLeft = border.charAt(3);
        char topBar = border.charAt(4);
        char rightBar = border.charAt(5);
        char bottomBar = border.charAt(6);
        char leftBar = border.charAt(7);
        this.draw(topLeft, x, y + h - 1, ansiFormat);
        this.draw(topRight, x + w - 1, y + h - 1, ansiFormat);
        this.draw(bottomLeft, x, y, ansiFormat);
        this.draw(bottomRight, x + w - 1, y, ansiFormat);
        this.drawHorizontalRight(topBar, w - 2, x + 1, y + h - 1, ansiFormat);
        this.drawHorizontalRight(bottomBar, w - 2, x + 1, y, ansiFormat);
        this.drawVerticalUp(leftBar, h - 2, x, y + 1, ansiFormat);
        this.drawVerticalUp(rightBar, h - 2, x + w - 1, y + 1, ansiFormat);
        return this;
    }

    public AsciiCanvas fill(char ch, int x, int y, int w, int h) {
        this.fill(ch, x, y, w, h, "");
        return this;
    }

    public AsciiCanvas fill(char ch, int x, int y, int w, int h, String ansiFormat) {
        for (int y_ = y; y_ < y + h; ++y_) {
            for (int x_ = x; x_ < x + w; ++x_) {
                this.draw(ch, x_, y_, ansiFormat);
            }
        }
        return this;
    }

    public List<String> toAnsiLines() {
        ArrayList<String> lines = new ArrayList<String>();
        for (int y = this.height - 1; y >= 0; --y) {
            StringBuilder line = new StringBuilder();
            for (int x = 0; x < this.width; ++x) {
                line.append(this.getCellAt(x, y).toAnsi());
            }
            lines.add(line.toString());
        }
        return lines;
    }

    public List<String> toAsciiLines() {
        ArrayList<String> lines = new ArrayList<String>();
        for (int y = this.height - 1; y >= 0; --y) {
            StringBuilder line = new StringBuilder();
            for (int x = 0; x < this.width; ++x) {
                line.append(this.getCellAt(x, y).toAscii());
            }
            lines.add(line.toString());
        }
        return lines;
    }

    public String toAsciiString() {
        return String.join((CharSequence)"\n", this.toAsciiLines());
    }

    public String toAnsiString() {
        return String.join((CharSequence)"\n", this.toAnsiLines());
    }

    public String toString() {
        return String.join((CharSequence)"\n", this.toAnsiLines());
    }

    private Cell getCellAt(int x, int y) {
        if (x < 0 || x >= this.width) {
            throw new IndexOutOfBoundsException("The x is out of bounds [0," + (this.width - 1) + "]");
        }
        if (y < 0 || y >= this.height) {
            throw new IndexOutOfBoundsException("The y is out of bounds [0," + (this.height - 1) + "]");
        }
        return this.canvas[y][x];
    }

    private boolean inbound(int x, int y) {
        return y >= 0 && y < this.height && x >= 0 && x < this.width;
    }

    private static class Cell {
        private final char val;
        private final String format;

        public Cell() {
            this(' ', "");
        }

        public Cell(char val, String format) {
            this.val = val;
            this.format = format;
        }

        public String toAnsi() {
            return this.format + String.valueOf(this.val) + AsciiCanvas.ANSI_RESET;
        }

        public String toAscii() {
            return String.valueOf(this.val);
        }
    }
}

