/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.time;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.VncKeyword;
import java.util.concurrent.TimeUnit;

public class TimeUnitUtil {
    public static TimeUnit toTimeUnit(VncKeyword unit) {
        if (unit == null) {
            throw new VncException("No time-unit! Use one of :millis, :seconds, :minutes, :hours, :days.");
        }
        switch (unit.getValue()) {
            case "milli": {
                return TimeUnit.MILLISECONDS;
            }
            case "millis": {
                return TimeUnit.MILLISECONDS;
            }
            case "milliseconds": {
                return TimeUnit.MILLISECONDS;
            }
            case "second": {
                return TimeUnit.SECONDS;
            }
            case "seconds": {
                return TimeUnit.SECONDS;
            }
            case "minute": {
                return TimeUnit.MINUTES;
            }
            case "minutes": {
                return TimeUnit.MINUTES;
            }
            case "hour": {
                return TimeUnit.HOURS;
            }
            case "hours": {
                return TimeUnit.HOURS;
            }
            case "day": {
                return TimeUnit.DAYS;
            }
            case "days": {
                return TimeUnit.DAYS;
            }
        }
        throw new VncException("Invalid time-unit " + unit.getValue() + "! Use one of :millis, :seconds, :minutes, :hours, :days.");
    }
}

