/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.chunk;

import com.github.jlangch.venice.impl.util.markdown.chunk.Chunk;

public class TextChunk
implements Chunk {
    private final String text;
    private final Format format;

    public TextChunk() {
        this("", Format.NORMAL);
    }

    public TextChunk(String text) {
        this(text, Format.NORMAL);
    }

    public TextChunk(String text, Format format) {
        this.text = text == null ? "" : this.collapseWhitespaces(text);
        this.format = format == null ? Format.NORMAL : format;
    }

    @Override
    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    public String getText() {
        return this.text;
    }

    public Format getFormat() {
        return this.format;
    }

    private String collapseWhitespaces(String s) {
        return s.replaceAll("[ \t]+", " ");
    }

    public static enum Format {
        NORMAL,
        ITALIC,
        BOLD,
        BOLD_ITALIC;

    }
}

