/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.dag;

import com.github.jlangch.venice.impl.util.dag.DagCycleException;
import com.github.jlangch.venice.impl.util.dag.Edge;
import com.github.jlangch.venice.impl.util.dag.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;

public class TopologicalSort<T> {
    private final List<Edge<Node<T>>> edges = new ArrayList<Edge<Node<T>>>();
    private final List<Node<T>> nodes;

    public TopologicalSort(Collection<Edge<Node<T>>> edges, List<Node<T>> isolatedNodes) {
        this.edges.addAll(edges);
        HashSet<Node<T>> nodes = new HashSet<Node<T>>(isolatedNodes);
        for (Edge<Node<T>> e : edges) {
            nodes.add(e.getParent());
            nodes.add(e.getChild());
        }
        this.nodes = new ArrayList<Node<T>>(nodes);
    }

    public List<T> sort() throws DagCycleException {
        if (this.nodes.isEmpty()) {
            throw new RuntimeException("The graph is empty!");
        }
        HashMap adjList = new HashMap();
        this.nodes.forEach(n -> {
            List cfr_ignored_0 = adjList.put(n, new ArrayList());
        });
        HashMap<Node, Integer> indegree = new HashMap<Node, Integer>();
        for (Edge<Node<T>> e : this.edges) {
            ((List)adjList.get(e.getParent())).add(e.getChild());
            indegree.put(e.getChild(), indegree.getOrDefault(e.getChild(), 0) + 1);
        }
        ArrayList sorted = new ArrayList();
        Stack<Node> stack = new Stack<Node>();
        this.nodes.stream().filter(n -> indegree.getOrDefault(n, 0) == 0).forEach(n -> stack.push((Node)n));
        while (!stack.isEmpty()) {
            Node n2 = (Node)stack.pop();
            sorted.add(n2);
            for (Node m : (List)adjList.get(n2)) {
                indegree.put(m, indegree.getOrDefault(m, 0) - 1);
                if (indegree.getOrDefault(m, 0) != 0) continue;
                stack.push(m);
            }
        }
        for (Node<T> node : this.nodes) {
            if (indegree.getOrDefault(node, 0) == 0) continue;
            throw new DagCycleException("The graph has at least one cycle!");
        }
        return Node.toValues(sorted);
    }
}

