/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.cidr;

import com.github.jlangch.venice.impl.util.cidr.CIDR;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class CidrTrieNode<V> {
    private final CIDR key;
    private final V value;
    private final AtomicReferenceArray<CidrTrieNode<V>> children = new AtomicReferenceArray(2);

    public CidrTrieNode() {
        this(null, null, null, null);
    }

    public CidrTrieNode(CIDR key, V value) {
        this(key, value, null, null);
    }

    public CidrTrieNode(CIDR key, V value, CidrTrieNode<V> left, CidrTrieNode<V> right) {
        this.key = key;
        this.value = value;
        this.children.set(0, left);
        this.children.set(1, right);
    }

    public CIDR getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public CidrTrieNode<V> getChild(boolean left) {
        return this.children.get(left ? 0 : 1);
    }

    public void setChild(boolean left, CidrTrieNode<V> child) {
        this.children.set(left ? 0 : 1, child);
    }

    public CidrTrieNode<V> withData(CIDR key, V value) {
        return new CidrTrieNode<V>(key, value, this.children.get(0), this.children.get(1));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key == null ? "<null>" : this.key.getNotation()).append(", [").append(this.children.get(0) != null ? "+" : "-").append(",").append(this.children.get(1) != null ? "+" : "-").append("]");
        return sb.toString();
    }
}

