/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.reader.Token;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;

public class MetaUtil {
    public static final VncKeyword ARGLIST = new VncKeyword(":arglists");
    public static final VncKeyword DOC = new VncKeyword(":doc");
    public static final VncKeyword ADDED = new VncKeyword(":added");
    public static final VncKeyword EXAMPLES = new VncKeyword(":examples");
    public static final VncKeyword SEE_ALSO = new VncKeyword(":see-also");
    public static final VncKeyword FUNCTION_REFS = new VncKeyword(":function-refs");
    public static final VncKeyword FILE = new VncKeyword(":file");
    public static final VncKeyword LINE = new VncKeyword(":line");
    public static final VncKeyword COLUMN = new VncKeyword(":column");
    public static final VncKeyword MACRO = new VncKeyword(":macro");
    public static final VncKeyword NS = new VncKeyword(":ns");
    public static final VncKeyword PRIVATE = new VncKeyword(":private");
    public static final VncKeyword DYNAMIC = new VncKeyword(":dynamic");
    public static final VncKeyword TYPE = new VncKeyword(":type_");
    public static final VncKeyword SUPERTYPES = new VncKeyword(":supertypes_");

    public static VncVal addDefMeta(VncVal val, VncMap meta) {
        VncVal valMeta = val.getMeta();
        if (valMeta == Constants.Nil) {
            valMeta = meta;
        } else if (Types.isVncMap(valMeta)) {
            valMeta = ((VncMap)valMeta).assoc(meta.toVncList());
        }
        return val.withMeta(valMeta);
    }

    public static VncVal toMeta(Token token) {
        return VncHashMap.of(FILE, new VncString(token.getFile()), LINE, new VncLong(token.getLine()), COLUMN, new VncLong(token.getColumn()));
    }

    public static VncVal addMetaVal(VncVal meta, VncVal ... mvs) {
        if (meta == Constants.Nil) {
            return VncHashMap.of(mvs);
        }
        if (Types.isVncMap(meta)) {
            return ((VncMap)meta).assoc(mvs);
        }
        return meta;
    }

    public static VncVal mergeMeta(VncVal meta1, VncVal meta2) {
        if (meta1 == Constants.Nil || meta1 == null) {
            return meta2 == null ? Constants.Nil : meta2;
        }
        if (meta2 == Constants.Nil || meta2 == null) {
            return meta1;
        }
        if (Types.isVncMap(meta1) && Types.isVncMap(meta2)) {
            return ((VncMap)meta1).putAll((VncMap)meta2);
        }
        throw new VncException(String.format("Failed to merge meta data on incompatible old (%s) and new (%s) meta data types", Types.getType(meta1), Types.getType(meta2)));
    }

    public static boolean isPrivate(VncVal meta) {
        if (meta instanceof VncHashMap) {
            return VncBoolean.isTrue(((VncHashMap)meta).get(PRIVATE));
        }
        return false;
    }

    public static boolean isDynamic(VncVal meta) {
        if (meta instanceof VncHashMap) {
            return VncBoolean.isTrue(((VncHashMap)meta).get(DYNAMIC));
        }
        return false;
    }

    public static VncVal markAsPrivate(VncVal meta) {
        if (meta == null || meta == Constants.Nil) {
            return VncHashMap.of(PRIVATE, VncBoolean.True);
        }
        if (meta instanceof VncHashMap) {
            ((VncHashMap)meta).assoc(PRIVATE, VncBoolean.True);
            return meta;
        }
        throw new VncException(String.format("Failed to add :private flag to meta data. The meta data (%s) is not a map!", Types.getType(meta)));
    }

    public static VncVal markAsDynamic(VncVal meta) {
        if (meta == null || meta == Constants.Nil) {
            return VncHashMap.of(DYNAMIC, VncBoolean.True);
        }
        if (meta instanceof VncHashMap) {
            ((VncHashMap)meta).assoc(DYNAMIC, VncBoolean.True);
            return meta;
        }
        throw new VncException(String.format("Failed to add :dynamic flag to meta data. The meta data (%s) is not a map!", Types.getType(meta)));
    }

    public static String getNamespace(VncVal meta) {
        if (meta instanceof VncHashMap) {
            VncVal ns = ((VncHashMap)meta).get(NS);
            return ns == Constants.Nil ? null : ((VncString)ns).getValue();
        }
        return null;
    }

    public static VncVal setNamespace(VncVal meta, String ns) {
        return MetaUtil.addMetaVal(meta, NS, new VncString(ns));
    }

    public static String getFile(VncVal meta) {
        VncVal vFile = MetaUtil.getMetaVal(meta, FILE);
        String file = vFile == Constants.Nil ? null : Coerce.toVncString(vFile).getValue();
        return file == null || file.isEmpty() ? null : file;
    }

    public static int getLine(VncVal meta) {
        VncVal vLine = MetaUtil.getMetaVal(meta, LINE);
        return vLine == Constants.Nil ? -1 : Coerce.toVncLong(vLine).getValue().intValue();
    }

    public static int getCol(VncVal meta) {
        VncVal vCol = MetaUtil.getMetaVal(meta, COLUMN);
        return vCol == Constants.Nil ? -1 : Coerce.toVncLong(vCol).getValue().intValue();
    }

    public static VncVal getMetaVal(VncVal meta, VncString key) {
        return meta instanceof VncHashMap ? ((VncHashMap)meta).get(key) : Constants.Nil;
    }

    public static boolean isType(VncVal meta) {
        return MetaUtil.getMetaVal(meta, TYPE) != Constants.Nil;
    }

    public static VncVal typeMeta(VncKeyword ... supertypes) {
        return VncHashMap.of(TYPE, VncBoolean.True, SUPERTYPES, supertypes == null ? VncList.empty() : VncList.of(supertypes));
    }

    public static VncList getSupertypes(VncVal meta) {
        VncVal v = MetaUtil.getMetaVal(meta, SUPERTYPES);
        return v instanceof VncList ? (VncList)v : VncList.empty();
    }
}

