/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.impl.util.StringUtil;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.repackage.org.jline.reader.Candidate;
import org.repackage.org.jline.reader.ParsedLine;

public class FilePathCompleter {
    private final Pattern p0 = Pattern.compile("^.*[(]load-file\\s*$");
    private final Pattern p1 = Pattern.compile("^.*[(]load-file\\s*[\"]([^\"]*)$");
    private final List<File> loadPaths;

    public FilePathCompleter(List<File> loadPaths) {
        List<File> list = this.loadPaths = loadPaths == null ? new ArrayList<File>() : new ArrayList<File>(loadPaths);
        if (this.loadPaths.isEmpty()) {
            this.loadPaths.add(new File("."));
        }
    }

    public final List<Candidate> getCandidates(ParsedLine cmdLine) {
        Matcher m;
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        String line = cmdLine.line();
        if (this.p0.matcher(line).matches()) {
            candidates.add(this.candidate("\"", false));
        } else if (this.p1.matcher(line).matches() && (m = this.p1.matcher(line)).matches() && m.groupCount() > 0) {
            String path = m.group(1);
            if (path.endsWith(".venice")) {
                candidates.add(this.candidate("\"", true));
            } else {
                this.loadPaths.stream().map(dir -> this.listFiles((File)dir, path)).flatMap(Collection::stream).sorted().forEach(f -> candidates.add(this.candidate((String)f, (String)f, true)));
            }
        }
        return candidates;
    }

    private List<String> listFiles(File root, String dir) {
        try {
            File root_ = root.getAbsoluteFile().getCanonicalFile();
            String sRoot_ = root_.getPath() + "/";
            File start = new File(root_, dir);
            if (start.isFile()) {
                return Arrays.asList(this.makeRelativeFile(sRoot_, start));
            }
            if (start.isDirectory()) {
                return Files.walk(start.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(f -> f.getName().endsWith(".venice")).map(f -> this.makeRelativeFile(sRoot_, (File)f)).filter(f -> f != null).sorted().collect(Collectors.toList());
            }
            return new ArrayList<String>();
        }
        catch (Exception ex) {
            return new ArrayList<String>();
        }
    }

    private String makeRelativeFile(String root, File file) {
        try {
            return StringUtil.removeStart(file.getAbsoluteFile().getCanonicalPath(), root);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Candidate candidate(String value, boolean complete) {
        return new Candidate(value, value, null, null, null, null, complete);
    }

    private Candidate candidate(String value, String display, boolean complete) {
        return new Candidate(value, display, null, null, null, null, complete);
    }
}

