/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClassVersionChecker {
    private static int MAGIC = -889275714;

    public static int getClassResourceMajorVersion(String classResource) {
        try {
            return ClassVersionChecker.readMajorVersion(new ClassPathResource(classResource).getInputStream(), classResource);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to retrieve Java major version for class resource '" + classResource + "'!");
        }
    }

    public static int getClassFileMajorVersion(String filename) {
        try {
            return ClassVersionChecker.readMajorVersion(new FileInputStream(filename), filename);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to retrieve Java major version for file '" + filename + "'!");
        }
    }

    private static int readMajorVersion(InputStream in, String source) throws IOException {
        try (DataInputStream din = new DataInputStream(in);){
            int major;
            int magic = din.readInt();
            if (magic != MAGIC) {
                throw new RuntimeException(source + " is not a valid class!");
            }
            int minor = din.readUnsignedShort();
            int n = major = din.readUnsignedShort();
            return n;
        }
    }
}

