/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.env;

import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;

public class DynamicVar
extends Var {
    private static final long serialVersionUID = 1598432086227773369L;
    private final VncKeyword th_keyword;

    public DynamicVar(VncSymbol name, VncVal val, Var.Scope scope) {
        super(name, val, scope);
        this.th_keyword = new VncKeyword(name.getQualifiedName());
    }

    @Override
    public VncVal getVal() {
        return this.peekVal();
    }

    public void setVal(VncVal val) {
        ThreadContext.setValue(this.th_keyword, val == null ? Constants.Nil : val);
    }

    public void pushVal(VncVal val) {
        ThreadContext.pushValue(this.th_keyword, val == null ? Constants.Nil : val);
    }

    public VncVal peekVal() {
        VncVal thVal = ThreadContext.peekValue(this.th_keyword);
        return thVal == Constants.Nil ? super.getVal() : thVal;
    }

    public VncVal popVal() {
        VncVal thVal = ThreadContext.popValue(this.th_keyword);
        return thVal == Constants.Nil ? super.getVal() : thVal;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public String toString(boolean print_readably) {
        return super.toString(print_readably);
    }
}

