/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen.util;

import com.github.jlangch.venice.impl.docgen.util.ColorTheme;
import com.github.jlangch.venice.impl.reader.HighlightClass;
import com.github.jlangch.venice.impl.reader.HighlightParser;
import com.github.jlangch.venice.impl.util.StringEscapeUtil;
import java.util.stream.Collectors;

public class CodeHighlighter {
    private final ColorTheme theme;
    private static final String TEMPLATE = "<span style=\"color: %s\">%s</span>";

    public CodeHighlighter(ColorTheme theme) {
        this.theme = theme;
    }

    public String highlight(String form) {
        return HighlightParser.parse(form).stream().map(it -> this.style(it.getForm(), it.getClazz())).collect(Collectors.joining());
    }

    public static String style(String text, String htmlColor) {
        return htmlColor == null ? StringEscapeUtil.escapeXml(text) : String.format(TEMPLATE, htmlColor, StringEscapeUtil.escapeXml(text));
    }

    private String style(String text, HighlightClass clazz) {
        return CodeHighlighter.style(text, this.theme.getColor(clazz));
    }
}

