/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen.runtime;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.ansi.AnsiColorTheme;
import com.github.jlangch.venice.impl.ansi.AnsiColorThemes;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.EnvSymbolLookupUtil;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.modules.ModuleLoader;
import com.github.jlangch.venice.impl.modules.Modules;
import com.github.jlangch.venice.impl.reader.HighlightItem;
import com.github.jlangch.venice.impl.reader.HighlightParser;
import com.github.jlangch.venice.impl.specialforms.SpecialFormsDoc;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.custom.VncChoiceTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncCustomBaseTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncCustomTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncProtocol;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.markdown.Markdown;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class DocForm {
    private static final boolean MARKDOWN_FN_DESCR = true;
    private static final String NO_DOC = "<no documentation available>";

    public static VncString doc(VncVal ref, Env env) {
        if (Types.isVncSymbol(ref)) {
            return DocForm.docForSymbol((VncSymbol)ref, env);
        }
        if (Types.isVncKeyword(ref)) {
            return DocForm.docForKeyword((VncKeyword)ref, env);
        }
        if (Types.isVncString(ref)) {
            return DocForm.docForSymbol(((VncString)ref).toSymbol(), env);
        }
        try {
            VncString name = (VncString)CoreFunctions.name.apply(VncList.of(ref));
            return DocForm.docForSymbol(name.toSymbol(), env);
        }
        catch (RuntimeException ex) {
            throw new VncException(String.format("Function 'doc' does not allow a parameter of type %s! Expected a symbol, keyword, or string.", Types.getType(ref)));
        }
    }

    public static VncString highlight(VncString form, Env env) {
        AnsiColorTheme theme = AnsiColorThemes.getTheme(DocForm.getColorTheme(env));
        if (theme == null) {
            return form;
        }
        List<HighlightItem> items = HighlightParser.parse(form.getValue());
        return new VncString(AnsiColorTheme.ANSI_RESET + items.stream().map(it -> theme.style(it.getForm(), it.getClazz())).collect(Collectors.joining()));
    }

    private static VncString docForSymbol(VncSymbol sym, Env env) {
        VncVal docVal = SpecialFormsDoc.ns.get(sym);
        if (docVal != null) {
            return DocForm.docForSymbolVal(docVal, env);
        }
        try {
            docVal = env.get(sym);
            return DocForm.docForSymbolVal(docVal, env);
        }
        catch (VncException ex) {
            if (sym.hasNamespace()) {
                throw ex;
            }
            String simpleName = sym.getSimpleName();
            List<VncSymbol> candidates = EnvSymbolLookupUtil.getGlobalSymbolCandidates(simpleName, env, 5);
            if (candidates.isEmpty()) {
                throw ex;
            }
            return new VncString(EnvSymbolLookupUtil.getSymbolNotFoundMsg(sym, candidates));
        }
    }

    private static VncString docForSymbolVal(VncVal symVal, Env env) {
        boolean repl = DocForm.isREPL(env);
        int width = repl ? DocForm.replTerminalWidth(env) : 80;
        return DocForm.formatDoc(symVal, width);
    }

    private static VncString docForKeyword(VncKeyword keyword, Env env) {
        if (keyword.getValue().endsWith(".venice")) {
            if (ModuleLoader.isLoadedClasspathFile(keyword.getValue())) {
                return DocForm.docForLoadedClasspathFile(keyword, env);
            }
            if (ModuleLoader.isLoadedExternalFile(keyword.getValue())) {
                return DocForm.docForLoadedExternalFile(keyword, env);
            }
            throw new VncException(String.format("'%s' is not a loaded classpath file or an external file. No documentation available!", keyword.getValue()));
        }
        if (Modules.isValidModule(keyword)) {
            return DocForm.docForModule(keyword, env);
        }
        return DocForm.docForCustomType(keyword, env);
    }

    private static VncString docForModule(VncKeyword module, Env env) {
        String form = ModuleLoader.loadModule(module.getValue());
        return DocForm.highlightVeniceSource(form, env);
    }

    private static VncString docForLoadedClasspathFile(VncString file, Env env) {
        String form = ModuleLoader.getCachedClasspathFile(file.getValue());
        if (form == null) {
            throw new VncException(String.format("The Venice source file '%s' has not been loaded yet from the classpath!", file.getValue()));
        }
        return DocForm.highlightVeniceSource(form, env);
    }

    private static VncString docForLoadedExternalFile(VncString file, Env env) {
        String form = ModuleLoader.getCachedExternalFile(file.getValue());
        if (form == null) {
            throw new VncException(String.format("The Venice source file '%s' has not been loaded from the filesystem yet!", file.getValue()));
        }
        return DocForm.highlightVeniceSource(form, env);
    }

    private static VncString docForCustomType(VncKeyword type, Env env) {
        VncVal tdef = env.getGlobalOrNull(type.toSymbol());
        if (tdef == null) {
            if (type.hasNamespace()) {
                throw new VncException(String.format(":%s is not a custom type. No documentation available!", type.getValue()));
            }
            throw new VncException(String.format(":%s is not a custom type. Please qualify the type with its namespace!", type.getValue()));
        }
        if (tdef instanceof VncCustomTypeDef) {
            VncCustomTypeDef typeDef = (VncCustomTypeDef)tdef;
            List<VncProtocol> protocols = DocForm.getAllEnvProtocols(typeDef, env);
            return new VncString(DocForm.getDoc(type, typeDef, protocols));
        }
        if (tdef instanceof VncWrappingTypeDef) {
            VncWrappingTypeDef typeDef = (VncWrappingTypeDef)tdef;
            List<VncProtocol> protocols = DocForm.getAllEnvProtocols(typeDef, env);
            return new VncString(DocForm.getDoc(type, typeDef, protocols));
        }
        if (tdef instanceof VncChoiceTypeDef) {
            VncChoiceTypeDef typeDef = (VncChoiceTypeDef)tdef;
            List<VncProtocol> protocols = DocForm.getAllEnvProtocols(typeDef, env);
            return new VncString(DocForm.getDoc(type, typeDef, protocols));
        }
        throw new VncException(String.format(":%s is not a custom type. Please qualify the type with its namespace!", type.getValue()));
    }

    private static String getDoc(VncKeyword type, VncCustomTypeDef typeDef, List<VncProtocol> protocols) {
        StringBuilder sb = new StringBuilder();
        int maxFieldLen = typeDef.getFieldDefs().stream().mapToInt(f -> f.getName().getValue().length()).max().orElse(0);
        sb.append(String.format("Custom type: %s", typeDef.getType()));
        sb.append("\n\n");
        sb.append("Fields: \n");
        typeDef.getFieldDefs().forEach(f -> sb.append(String.format("   %s: %s\n", StringUtil.padRight(f.getName().getValue(), maxFieldLen), f.isNillable() ? f.getType().getValue() + "?" : f.getType().getValue())));
        if (typeDef.getValidationFn() != null) {
            sb.append("\n\n");
            sb.append(String.format("Validation function: %s", typeDef.getValidationFn().getQualifiedName()));
        }
        if (!protocols.isEmpty()) {
            protocols.forEach(p -> {
                sb.append("\n").append("Protocol: ").append(p.getName().getName()).append("\n");
                p.getFunctions().entries().stream().map(e -> (VncFunction)e.getValue()).sorted(Comparator.comparing(VncFunction::getSimpleName)).forEach(f -> {
                    VncList argsList = f.getArgLists();
                    sb.append("   ").append(f.getSimpleName()).append(": ").append(argsList.stream().map(s -> DocForm.toString(s)).collect(Collectors.joining(", "))).append("\n");
                });
            });
        }
        return sb.append("\n").toString();
    }

    private static String getDoc(VncKeyword type, VncWrappingTypeDef typeDef, List<VncProtocol> protocols) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Custom wrapped type: %s\n", type.getValue()));
        sb.append(String.format("Base type: %s\n", typeDef.getBaseType().getValue()));
        if (typeDef.getValidationFn() != null) {
            sb.append(String.format("Validation function: %s\n", typeDef.getValidationFn().getQualifiedName()));
        }
        return sb.toString();
    }

    private static String getDoc(VncKeyword type, VncChoiceTypeDef typeDef, List<VncProtocol> protocols) {
        VncSet types = typeDef.typesOnly();
        VncSet values = typeDef.valuesOnly();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Custom choice type: %s\n", type.getValue()));
        if (!types.isEmpty()) {
            sb.append("Types: \n");
            typeDef.typesOnly().forEach(v -> sb.append(String.format("   %s\n", v.toString())));
        }
        if (!values.isEmpty()) {
            sb.append("Values: \n");
            typeDef.valuesOnly().forEach(v -> sb.append(String.format("   %s\n", v.toString())));
        }
        return sb.toString();
    }

    private static String getColorTheme(Env env) {
        if (DocForm.isREPL(env)) {
            VncVal theme;
            VncVal fn = env.get(new VncSymbol("repl/color-theme"));
            if (Types.isVncFunction(fn) && Types.isVncKeyword(theme = ((VncFunction)fn).applyOf(new VncVal[0]))) {
                return ((VncKeyword)theme).getValue();
            }
            return "light";
        }
        return null;
    }

    private static boolean isREPL(Env env) {
        VncVal runMode = env.get(new VncSymbol("*run-mode*"));
        if (Types.isVncKeyword(runMode)) {
            String sRunMode = ((VncKeyword)runMode).getValue();
            return "repl".equals(sRunMode);
        }
        return false;
    }

    private static int replTerminalWidth(Env env) {
        VncVal cols;
        VncVal fn = env.get(new VncSymbol("repl/term-cols"));
        if (Types.isVncFunction(fn) && Types.isVncLong(cols = ((VncFunction)fn).applyOf(new VncVal[0]))) {
            int termWidth = ((VncLong)cols).getIntValue();
            if (termWidth <= 100) {
                return termWidth;
            }
            return 100 + (termWidth - 100) / 2;
        }
        return -1;
    }

    private static VncString formatDoc(VncVal val, int width) {
        if (val != null) {
            if (Types.isVncFunction(val)) {
                try {
                    return DocForm.formatDoc((VncFunction)val, width);
                }
                catch (RuntimeException ex) {
                    throw new RuntimeException("Failed to format function doc: " + ((VncFunction)val).getQualifiedName(), ex);
                }
            }
            if (Types.isVncSpecialForm(val)) {
                try {
                    return DocForm.formatDoc((VncSpecialForm)val, width);
                }
                catch (RuntimeException ex) {
                    throw new RuntimeException("Failed to format special form doc: " + ((VncSpecialForm)val).getName(), ex);
                }
            }
            if (Types.isVncProtocol(val)) {
                try {
                    return DocForm.formatDoc((VncProtocol)val, width);
                }
                catch (RuntimeException ex) {
                    throw new RuntimeException("Failed to format protocol doc: " + ((VncProtocol)val).getName(), ex);
                }
            }
        }
        return new VncString(NO_DOC);
    }

    private static VncString formatDoc(VncFunction fn, int width) {
        String fnDescr;
        VncVal doc = fn.getDoc();
        VncList argsList = fn.getArgLists();
        VncList examples = fn.getExamples();
        VncList seeAlso = fn.getSeeAlso();
        StringBuilder sb = new StringBuilder();
        if (!argsList.isEmpty()) {
            sb.append(argsList.stream().map(s -> DocForm.toString(s)).collect(Collectors.joining(", ")));
            sb.append("\n\n");
        }
        if (!(fnDescr = DocForm.toString(doc)).isEmpty()) {
            sb.append(Markdown.parse(fnDescr).renderToText(width));
        }
        if (!examples.isEmpty()) {
            sb.append("\n\n");
            sb.append("EXAMPLES:\n");
            sb.append(examples.stream().map(s -> DocForm.toString(s)).map(e -> DocForm.indent(e, "   ")).collect(Collectors.joining("\n\n")));
        }
        if (!seeAlso.isEmpty()) {
            sb.append("\n\n");
            sb.append("SEE ALSO:\n   ");
            sb.append(seeAlso.stream().map(s -> DocForm.toString(s)).collect(Collectors.joining(", ")));
        }
        if (sb.length() > 0) {
            sb.append("\n");
            return new VncString(sb.toString());
        }
        return new VncString(NO_DOC);
    }

    private static VncString formatDoc(VncSpecialForm fn, int width) {
        String fnDescr;
        VncVal doc = fn.getDoc();
        VncList argsList = fn.getArgLists();
        VncList examples = fn.getExamples();
        VncList seeAlso = fn.getSeeAlso();
        StringBuilder sb = new StringBuilder();
        if (!argsList.isEmpty()) {
            sb.append(argsList.stream().map(s -> DocForm.toString(s)).collect(Collectors.joining(", ")));
            sb.append("\n\n");
        }
        if (!(fnDescr = DocForm.toString(doc)).isEmpty()) {
            sb.append(Markdown.parse(fnDescr).renderToText(width));
        }
        if (!examples.isEmpty()) {
            sb.append("\n\n");
            sb.append("EXAMPLES:\n");
            sb.append(examples.stream().map(s -> DocForm.toString(s)).map(e -> DocForm.indent(e, "   ")).collect(Collectors.joining("\n\n")));
        }
        if (!seeAlso.isEmpty()) {
            sb.append("\n\n");
            sb.append("SEE ALSO:\n   ");
            sb.append(seeAlso.stream().map(s -> DocForm.toString(s)).collect(Collectors.joining(", ")));
        }
        if (sb.length() > 0) {
            sb.append("\n");
            return new VncString(sb.toString());
        }
        return new VncString(NO_DOC);
    }

    private static VncString formatDoc(VncProtocol protocol, int width) {
        VncList examples_;
        VncVal doc = MetaUtil.getMetaVal(protocol.getMeta(), MetaUtil.DOC);
        VncVal examples = MetaUtil.getMetaVal(protocol.getMeta(), MetaUtil.EXAMPLES);
        boolean empty = true;
        StringBuilder sb = new StringBuilder();
        if (Types.isVncString(doc)) {
            empty = false;
            String descr = ((VncString)doc).getValue();
            sb.append(Markdown.parse(descr).renderToText(width));
        }
        if (Types.isVncList(examples) && !(examples_ = (VncList)examples).isEmpty()) {
            empty = false;
            sb.append("\n\n");
            sb.append("EXAMPLES:\n");
            sb.append(examples_.stream().map(s -> DocForm.toString(s)).map(e -> DocForm.indent(e, "   ")).collect(Collectors.joining("\n\n")));
            sb.append("\n");
        }
        if (empty) {
            sb.append("Protocol: " + protocol.getName().getValue() + "\n\n");
            sb.append("Functions:\n");
            protocol.getFunctions().entries().stream().map(e -> (VncFunction)e.getValue()).sorted(Comparator.comparing(VncFunction::getSimpleName)).forEach(f -> {
                VncList argsList = f.getArgLists();
                sb.append("   ").append(f.getSimpleName()).append(": ").append(argsList.stream().map(s -> DocForm.toString(s)).collect(Collectors.joining(", "))).append("\n");
            });
            return new VncString(sb.toString());
        }
        return new VncString(sb.toString());
    }

    private static String indent(String text, String indent) {
        if (StringUtil.isBlank(text)) {
            return text;
        }
        return StringUtil.splitIntoLines(text).stream().map(s -> indent + s).collect(Collectors.joining("\n"));
    }

    private static String toString(VncVal val) {
        return val == Constants.Nil ? "" : ((VncString)val).getValue();
    }

    private static VncString highlightVeniceSource(String form, Env env) {
        AnsiColorTheme theme = AnsiColorThemes.getTheme(DocForm.getColorTheme(env));
        if (theme == null) {
            return new VncString(form);
        }
        List<HighlightItem> items = HighlightParser.parse("(do " + form + ")");
        items = items.subList(3, items.size() - 1);
        return new VncString(AnsiColorTheme.ANSI_RESET + items.stream().map(it -> theme.style(it.getForm(), it.getClazz())).collect(Collectors.joining()));
    }

    private static List<VncProtocol> getAllEnvProtocols(VncCustomBaseTypeDef typeDef, Env env) {
        return env.getAllGlobalSymbols().entrySet().stream().filter(s -> ((Var)s.getValue()).getVal() instanceof VncProtocol).map(s -> (VncProtocol)((Var)s.getValue()).getVal()).filter(p -> p.isRegistered(typeDef.getType())).sorted().collect(Collectors.toList());
    }
}

