/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.io.vavr.collection;

import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.repackage.io.vavr.Tuple;
import org.repackage.io.vavr.Tuple2;
import org.repackage.io.vavr.collection.Collections;
import org.repackage.io.vavr.collection.LinearSeq;
import org.repackage.io.vavr.collection.List;
import org.repackage.io.vavr.collection.Traversable;

interface LinearSeqModule {

    public static interface Search {
        public static <T> int linearSearch(LinearSeq<T> seq, ToIntFunction<T> comparison) {
            int idx = 0;
            for (Object current : seq) {
                int cmp = comparison.applyAsInt(current);
                if (cmp == 0) {
                    return idx;
                }
                if (cmp < 0) {
                    return -(idx + 1);
                }
                ++idx;
            }
            return -(idx + 1);
        }
    }

    public static class Slice {
        static <T> int indexOfSlice(LinearSeq<T> source, Iterable<? extends T> slice, int from) {
            if (source.isEmpty()) {
                return from == 0 && Collections.isEmpty(slice) ? 0 : -1;
            }
            LinearSeq<? extends T> _slice = Slice.toLinearSeq(slice);
            return Slice.findFirstSlice(source, _slice, Math.max(from, 0));
        }

        static <T> int lastIndexOfSlice(LinearSeq<T> source, Iterable<? extends T> slice, int end) {
            if (end < 0) {
                return -1;
            }
            if (source.isEmpty()) {
                return Collections.isEmpty(slice) ? 0 : -1;
            }
            if (Collections.isEmpty(slice)) {
                int len = source.length();
                return len < end ? len : end;
            }
            int index = 0;
            int result = -1;
            LinearSeq<T> _slice = Slice.toLinearSeq(slice);
            while (source.length() >= _slice.length()) {
                Tuple2<LinearSeq<? extends T>, Integer> r = Slice.findNextSlice(source, _slice);
                if (r == null) {
                    return result;
                }
                if (index + (Integer)r._2 <= end) {
                    result = index + (Integer)r._2;
                    index += (Integer)r._2 + 1;
                    source = ((LinearSeq)r._1).tail();
                    continue;
                }
                return result;
            }
            return result;
        }

        private static <T> int findFirstSlice(LinearSeq<T> source, LinearSeq<T> slice, int from) {
            Predicate<LinearSeq> hasMore;
            int index = 0;
            int sliceLength = slice.length();
            Predicate<LinearSeq> predicate = hasMore = source.isLazy() ? Traversable::nonEmpty : seq -> seq.length() >= sliceLength;
            while (hasMore.test((LinearSeq)source)) {
                if (index >= from && source.startsWith(slice)) {
                    return index;
                }
                ++index;
                source = source.tail();
            }
            return -1;
        }

        private static <T> Tuple2<LinearSeq<T>, Integer> findNextSlice(LinearSeq<T> source, LinearSeq<T> slice) {
            int index = 0;
            while (source.length() >= slice.length()) {
                if (source.startsWith(slice)) {
                    return Tuple.of(source, index);
                }
                ++index;
                source = source.tail();
            }
            return null;
        }

        private static <T> LinearSeq<T> toLinearSeq(Iterable<? extends T> iterable) {
            return iterable instanceof LinearSeq ? (List<? extends T>)iterable : List.ofAll(iterable);
        }
    }
}

