/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.LoadPaths;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class LoadPathsFactory {
    public static ILoadPaths acceptAll() {
        return LoadPaths.of(null, true);
    }

    public static ILoadPaths rejectAll() {
        return LoadPaths.of(null, false);
    }

    public static ILoadPaths of(List<File> paths) {
        return LoadPaths.of(paths, false);
    }

    public static ILoadPaths of(List<File> paths, boolean unlimitedAccess) {
        return LoadPaths.of(paths, unlimitedAccess);
    }

    public static ILoadPaths parseDelimitedLoadPath(String loadPaths) {
        return LoadPathsFactory.parseDelimitedLoadPath(loadPaths, false);
    }

    public static ILoadPaths parseDelimitedLoadPath(String loadPaths, boolean unlimitedAccess) {
        if (loadPaths == null) {
            return LoadPathsFactory.of(null, unlimitedAccess);
        }
        return LoadPaths.of(Arrays.stream(loadPaths.trim().split(";")).map(p -> StringUtil.trimToNull(p)).filter(p -> p != null).map(p -> new File((String)p)).collect(Collectors.toList()), unlimitedAccess);
    }
}

