/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.transducer;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncQueue;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.transducer.Reduced;

public class Reducer {
    public static VncVal reduce(IVncFunction reduceFn, VncVal init, Iterable<VncVal> coll, MeterRegistry meterRegistry) {
        VncVal value = init;
        for (VncVal v : coll) {
            value = meterRegistry.enabled ? VncFunction.applyWithMeter(reduceFn, VncList.of(value, v), meterRegistry) : reduceFn.apply(VncList.of(value, v));
            if (!Reduced.isReduced(value)) continue;
            return Reduced.unreduced(value);
        }
        return value;
    }

    public static VncVal reduce(IVncFunction reduceFn, VncVal init, VncQueue queue, MeterRegistry meterRegistry) {
        VncVal v;
        VncVal value = init;
        while ((v = queue.take()) != Constants.Nil) {
            if (!Reduced.isReduced(value = VncFunction.applyWithMeter(reduceFn, VncList.of(value, v), meterRegistry))) continue;
            return Reduced.unreduced(value);
        }
        return value;
    }
}

