/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.io.zip;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.util.io.zip.Zipper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;

public class ZipFileSystemUtil {
    public static FileSystem mountZip(File zip) throws IOException {
        try {
            return FileSystems.newFileSystem(zip.toPath(), Zipper.class.getClassLoader());
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to mount ZIP filesystem from '%s'", zip.getPath()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VncByteBuffer loadBinaryFileFromZip(File zip, File file) {
        if (!zip.exists()) {
            throw new VncException(String.format("The ZIP file '%s' does not exist", zip.getPath()));
        }
        try (FileSystem zipFS = ZipFileSystemUtil.mountZip(zip);){
            byte[] data = Files.readAllBytes(zipFS.getPath(file.getPath(), new String[0]));
            VncByteBuffer vncByteBuffer = new VncByteBuffer(data);
            return vncByteBuffer;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load binary file '%s' from ZIP '%s'", file.getPath(), zip.getPath()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VncString loadTextFileFromZip(File zip, File file, String encoding) {
        if (!zip.exists()) {
            throw new VncException(String.format("The ZIP file '%s' does not exist", zip.getPath()));
        }
        try (FileSystem zipFS = ZipFileSystemUtil.mountZip(zip);){
            byte[] data = Files.readAllBytes(zipFS.getPath(file.getPath(), new String[0]));
            VncString vncString = new VncString(new String(data, encoding == null ? "utf-8" : encoding));
            return vncString;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load file '%s' from ZIP '%s'", file.getPath(), zip.getPath()));
        }
    }
}

