/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.HashMap;
import java.util.Map;

public class SymbolMapBuilder {
    private HashMap<VncVal, VncVal> map = new HashMap();

    public SymbolMapBuilder add(VncFunction fn) {
        if (fn.isPrivate()) {
            this.map.put(new VncSymbol(fn.getQualifiedName(), (VncVal)VncHashMap.of(MetaUtil.PRIVATE, VncBoolean.True)), fn);
        } else {
            this.map.put(new VncSymbol(fn.getQualifiedName()), fn);
        }
        return this;
    }

    public SymbolMapBuilder add(VncSpecialForm sf) {
        this.map.put(new VncSymbol(sf.getName()), sf);
        return this;
    }

    public SymbolMapBuilder put(VncSymbol key, VncVal val) {
        this.map.put(key, val);
        return this;
    }

    public VncHashMap build() {
        return new VncHashMap(this.map);
    }

    public Map<VncVal, VncVal> toMap() {
        return this.map;
    }
}

