/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.reader.Token;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.util.MetaUtil;

public class ErrorMessage {
    public static String buildErrLocation(String file, int line, int column) {
        return String.format("File <%s> (%d,%d)", file == null ? "unknown" : file, line, column);
    }

    public static String buildErrLocation(Token token) {
        return token != null ? ErrorMessage.buildErrLocation(token.getFile(), token.getLine(), token.getColumn()) : "File <unknown> (1,1)";
    }

    public static String buildErrLocation(VncVal val) {
        VncVal meta = val.getMeta();
        String file = MetaUtil.getFile(meta);
        int line = MetaUtil.getLine(meta);
        int column = MetaUtil.getCol(meta);
        return String.format("File <%s> (%d,%d)", file == null || file.isEmpty() ? "unknown" : file, line == -1 ? 1 : line, column == -1 ? 1 : column);
    }
}

