/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.MetaUtil;
import com.github.jlangch.venice.util.StackFrame;

public class CallFrame {
    private final String fnName;
    private final VncList args;
    private final VncVal meta;
    private final Env env;

    public CallFrame(VncFunction fn) {
        this.fnName = fn.getQualifiedName();
        this.args = null;
        this.meta = fn.getMeta();
        this.env = null;
    }

    public CallFrame(VncFunction fn, VncList args) {
        this.fnName = fn.getQualifiedName();
        this.args = args;
        this.meta = fn.getMeta();
        this.env = null;
    }

    public CallFrame(String fnName, VncVal meta) {
        this.fnName = fnName;
        this.args = null;
        this.meta = meta;
        this.env = null;
    }

    public CallFrame(String fnName, VncList args, VncVal meta) {
        this.fnName = fnName;
        this.args = args;
        this.meta = meta;
        this.env = null;
    }

    public CallFrame(String fnName, VncList args, VncVal meta, Env env) {
        this.fnName = fnName;
        this.args = args;
        this.meta = meta;
        this.env = env;
    }

    public static CallFrame from(VncSymbol sym) {
        return new CallFrame(sym.getQualifiedName(), sym.getMeta());
    }

    public String getFnName() {
        return this.fnName;
    }

    public VncList getArgs() {
        return this.args;
    }

    public Env getEnv() {
        return this.env;
    }

    public boolean hasFnName(String fnName) {
        return this.fnName.equals(fnName);
    }

    public String getFile() {
        String file = MetaUtil.getFile(this.meta);
        return file == null || file.isEmpty() ? "unknown" : file;
    }

    public int getLine() {
        return MetaUtil.getLine(this.meta);
    }

    public int getCol() {
        return MetaUtil.getCol(this.meta);
    }

    public StackFrame toStackFrame() {
        return new StackFrame(this.getFnName(), this.getFile(), this.getLine(), this.getCol());
    }

    public String getSourcePosInfo() {
        return String.format("%s: line %d, col %d", this.getFile(), this.getLine(), this.getCol());
    }

    public String toString() {
        return this.fnName == null ? this.getSourcePosInfo() : String.format("%s (%s)", this.fnName, this.getSourcePosInfo());
    }
}

