/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.util;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.StringUtil;

public class QualifiedName {
    private final String qualifiedName;
    private final String namespace;
    private final String simpleName;

    private QualifiedName(String qualifiedName, String namespace, String simpleName) {
        this.qualifiedName = qualifiedName;
        this.namespace = namespace;
        this.simpleName = simpleName;
    }

    public static QualifiedName of(String namespace, String simpleName) {
        String namespace_ = StringUtil.trimToNull(namespace);
        String simpleName_ = StringUtil.trimToNull(simpleName);
        if (namespace_ != null && namespace_.indexOf("/") >= 0) {
            throw new VncException(String.format("A namespace ('%s') must not contain a '/'", namespace_));
        }
        if (simpleName_ == null) {
            throw new VncException("A simple name of a qualified name must not be blank");
        }
        if (!simpleName_.equals("/") && simpleName_.indexOf("/") >= 0) {
            throw new VncException(String.format("A simple name ('%s') of a qualified name must not contain a '/'", simpleName_));
        }
        String qualifiedName_ = namespace_ == null ? simpleName_ : namespace_ + "/" + simpleName_;
        return new QualifiedName(qualifiedName_, namespace_, simpleName_);
    }

    public static QualifiedName parse(String name) {
        String simpleName;
        String name_ = StringUtil.trimToNull(name);
        if (name_ == null) {
            throw new VncException("A name must not be blank");
        }
        if (name_.equals("/")) {
            return new QualifiedName("/", null, "/");
        }
        if (name_.equals("core//")) {
            return new QualifiedName("/", null, "/");
        }
        int pos = name_.lastIndexOf("/");
        String namespace = pos < 0 ? null : StringUtil.trimToNull(name_.substring(0, pos));
        String string = simpleName = pos < 0 ? name_ : StringUtil.trimToNull(name_.substring(pos + 1));
        if (namespace != null && namespace.indexOf("/") >= 0) {
            throw new VncException(String.format("A namespace ('%s') of a qualified name ('%s') must not contain a '/'", namespace, name));
        }
        if (simpleName == null) {
            throw new VncException(String.format("A simple name ('%s') of a qualified name ('%s') name must not be blank", simpleName, name));
        }
        String qualifiedName = namespace == null ? simpleName : namespace + "/" + simpleName;
        return new QualifiedName(qualifiedName, namespace, simpleName);
    }

    public QualifiedName withOtherNamespace(String namespace) {
        return QualifiedName.of(namespace, this.simpleName);
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.qualifiedName == null ? 0 : this.qualifiedName.hashCode());
        result = 31 * result + (this.simpleName == null ? 0 : this.simpleName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedName other = (QualifiedName)obj;
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        if (this.qualifiedName == null ? other.qualifiedName != null : !this.qualifiedName.equals(other.qualifiedName)) {
            return false;
        }
        return !(this.simpleName == null ? other.simpleName != null : !this.simpleName.equals(other.simpleName));
    }
}

