/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.custom;

import com.github.jlangch.venice.AssertionException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.custom.VncCustomBaseTypeDef;

public class VncWrappingTypeDef
extends VncCustomBaseTypeDef {
    private static final long serialVersionUID = -1848883965231344442L;
    private final VncKeyword baseType;
    private final VncFunction validationFn;

    public VncWrappingTypeDef(VncKeyword type, VncKeyword baseType) {
        this(type, baseType, null);
    }

    public VncWrappingTypeDef(VncKeyword type, VncKeyword baseType, VncFunction validationFn) {
        super(type);
        this.baseType = baseType;
        this.validationFn = validationFn;
    }

    public VncKeyword getBaseType() {
        return this.baseType;
    }

    public VncFunction getValidationFn() {
        return this.validationFn;
    }

    public void validate(VncVal val) {
        if (this.validationFn != null) {
            try {
                VncVal valid = this.validationFn.apply(VncList.of(val));
                if (valid == Constants.Nil || VncBoolean.isFalse(valid)) {
                    throw new AssertionException(String.format("Invalid value for custom type :%s", this.getType().getValue()));
                }
            }
            catch (AssertionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new AssertionException(String.format("Invalid value for custom type :%s", this.getType().getValue()), ex);
            }
        }
    }

    @Override
    public VncMap toMap() {
        return VncHashMap.of(new VncKeyword(":type"), this.getType(), new VncKeyword(":custom-type"), new VncKeyword(":wrapping"), new VncKeyword(":base-type"), this.baseType, new VncKeyword(":validation-fn"), this.validationFn == null ? Constants.Nil : this.validationFn);
    }
}

