/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class VncSequence
extends VncCollection
implements Iterable<VncVal> {
    public static final String TYPE = ":core/sequence";
    private static final long serialVersionUID = -1848883965231344442L;

    public VncSequence(VncVal meta) {
        super(meta);
    }

    @Override
    public abstract VncSequence emptyWithMeta();

    public abstract VncSequence withVariadicValues(VncVal ... var1);

    public abstract VncSequence withValues(List<? extends VncVal> var1);

    public abstract VncSequence withValues(List<? extends VncVal> var1, VncVal var2);

    @Override
    public abstract VncSequence withMeta(VncVal var1);

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/collection"), new VncKeyword(":core/val")));
    }

    public abstract List<VncVal> getJavaList();

    public abstract VncVal nth(int var1);

    public abstract VncVal nthOrDefault(int var1, VncVal var2);

    public VncVal first() {
        return this.nthOrDefault(0, Constants.Nil);
    }

    public VncVal second() {
        return this.nthOrDefault(1, Constants.Nil);
    }

    public VncVal third() {
        return this.nthOrDefault(2, Constants.Nil);
    }

    public VncVal fourth() {
        return this.nthOrDefault(3, Constants.Nil);
    }

    public abstract VncVal last();

    public abstract VncSequence rest();

    public abstract VncSequence butlast();

    public abstract VncSequence drop(int var1);

    public abstract VncSequence dropWhile(Predicate<? super VncVal> var1);

    public abstract VncSequence dropRight(int var1);

    public abstract VncSequence take(int var1);

    public abstract VncSequence takeWhile(Predicate<? super VncVal> var1);

    public abstract VncSequence takeRight(int var1);

    public abstract VncSequence slice(int var1, int var2);

    public abstract VncSequence slice(int var1);

    public abstract VncSequence setAt(int var1, VncVal var2);

    public abstract VncSequence addAtStart(VncVal var1);

    public abstract VncSequence addAllAtStart(VncSequence var1, boolean var2);

    public abstract VncSequence addAtEnd(VncVal var1);

    public abstract VncSequence addAllAtEnd(VncSequence var1);

    public abstract VncSequence removeAt(int var1);

    public abstract VncSequence reverse();

    public abstract VncSequence shuffle();

    public abstract VncSequence distinct();

    @Override
    public abstract Iterator<VncVal> iterator();

    public abstract Stream<VncVal> stream();

    @Override
    public abstract void forEach(Consumer<? super VncVal> var1);

    public abstract VncSequence filter(Predicate<? super VncVal> var1);

    public abstract VncSequence map(Function<? super VncVal, ? extends VncVal> var1);

    public static VncSequence coerceToSequence(VncVal val) {
        if (Types.isVncMap(val)) {
            return VncList.ofList(((VncMap)val).entries());
        }
        if (Types.isVncSet(val)) {
            return ((VncSet)val).toVncList();
        }
        if (Types.isVncString(val)) {
            return ((VncString)val).toVncList();
        }
        return Coerce.toVncSequence(val);
    }
}

