/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.thread;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.debug.agent.DebugAgent;
import com.github.jlangch.venice.impl.namespaces.Namespace;
import com.github.jlangch.venice.impl.thread.ThreadContextSnapshot;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncStack;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.CallFrameFnData;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.RejectAllInterceptor;
import java.io.PrintStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class ThreadContext {
    private Map<VncKeyword, VncVal> values = new HashMap<VncKeyword, VncVal>();
    private CallStack callStack = new CallStack();
    private Namespace ns = new Namespace(DEFAULT_NS);
    private DebugAgent debugAgent = null;
    private IInterceptor interceptor = REJECT_ALL_INTERCEPTOR;
    private MeterRegistry meterRegistry = new MeterRegistry(false);
    private CallFrameFnData callFrameFnData = null;
    private boolean inUse = false;
    private static final VncSymbol DEFAULT_NS = new VncSymbol("user");
    private static final IInterceptor REJECT_ALL_INTERCEPTOR = new RejectAllInterceptor();
    private static final VncKeyword STD_IN = new VncKeyword("*in*");
    private static final VncKeyword STD_OUT = new VncKeyword("*out*");
    private static final VncKeyword STD_ERR = new VncKeyword("*err*");
    private static ThreadLocal<ThreadContext> context = ThreadLocal.withInitial(() -> new ThreadContext());

    public Namespace getCurrNS_() {
        return this.ns;
    }

    public void setCurrNS_(Namespace ns) {
        this.ns = ns;
    }

    public DebugAgent getDebugAgent_() {
        return this.debugAgent;
    }

    public CallStack getCallStack_() {
        return this.callStack;
    }

    public CallFrameFnData getAndClearCallFrameFnData_() {
        CallFrameFnData data = this.callFrameFnData;
        this.callFrameFnData = null;
        return data;
    }

    public CallFrameFnData getCallFrameFnData_() {
        return this.callFrameFnData;
    }

    public void setCallFrameFnData_(CallFrameFnData data) {
        this.callFrameFnData = data;
    }

    public static VncVal getValue(VncKeyword key) {
        return ThreadContext.getValue(key, Constants.Nil);
    }

    public static VncVal getValue(VncKeyword key, VncVal defaultValue) {
        if (key == null) {
            return Constants.Nil;
        }
        VncVal v = ThreadContext.get().values.get(key);
        if (v instanceof VncStack) {
            VncVal thVal = ((VncStack)v).peek();
            return thVal == Constants.Nil ? defaultValue : thVal;
        }
        return v == null ? defaultValue : v;
    }

    public static void setValue(VncKeyword key, VncVal val) {
        if (key != null) {
            ThreadContext ctx = ThreadContext.get();
            VncVal v = ctx.values.get(key);
            if (v == null) {
                ctx.values.put(key, val == null ? Constants.Nil : val);
            } else if (v instanceof VncStack) {
                ((VncStack)v).clear();
                ((VncStack)v).push(val == null ? Constants.Nil : val);
            } else {
                ctx.values.put(key, val);
            }
        }
    }

    public static void removeValue(VncKeyword key) {
        if (key != null) {
            ThreadContext.get().values.remove(key);
        }
    }

    public static boolean containsKey(VncKeyword key) {
        return key == null ? false : ThreadContext.get().values.containsKey(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void pushValue(VncKeyword key, VncVal val) {
        if (key == null) return;
        ThreadContext ctx = ThreadContext.get();
        if (ctx.values.containsKey(key)) {
            VncVal v = ctx.values.get(key);
            if (!(v instanceof VncStack)) throw new VncException(String.format("The var %s is not defined as dynamic on the thread-local context", key.getValue()));
            ((VncStack)v).push(val == null ? Constants.Nil : val);
            return;
        } else {
            VncStack stack = new VncStack();
            stack.push(val == null ? Constants.Nil : val);
            ctx.values.put(key, stack);
        }
    }

    public static VncVal popValue(VncKeyword key) {
        if (key != null) {
            ThreadContext ctx = ThreadContext.get();
            if (ctx.values.containsKey(key)) {
                VncVal v = ctx.values.get(key);
                if (v instanceof VncStack) {
                    return ((VncStack)v).pop();
                }
                throw new VncException(String.format("The var %s is not defined as dynamic on the thread-local context", key.getValue()));
            }
        }
        return Constants.Nil;
    }

    public static VncVal peekValue(VncKeyword key) {
        if (key != null) {
            ThreadContext ctx = ThreadContext.get();
            if (ctx.values.containsKey(key)) {
                VncVal v = ctx.values.get(key);
                if (v instanceof VncStack) {
                    return ((VncStack)v).peek();
                }
                throw new VncException(String.format("The var %s is not defined as dynamic on the thread-local context", key.getValue()));
            }
        }
        return Constants.Nil;
    }

    public static Map<VncKeyword, VncVal> getValues() {
        HashMap<VncKeyword, VncVal> copy = new HashMap<VncKeyword, VncVal>();
        ThreadContext.copyValues(ThreadContext.get().values, copy);
        return copy;
    }

    public static void clearCallStack() {
        ThreadContext.get().callStack = new CallStack();
    }

    public static CallStack getCallStack() {
        return ThreadContext.get().callStack;
    }

    public static Namespace getCurrNS() {
        return ThreadContext.get().ns;
    }

    public static void setCurrNS(Namespace ns) {
        ThreadContext.get().ns = ns;
    }

    public static DebugAgent getDebugAgent() {
        return ThreadContext.get().debugAgent;
    }

    public static void setDebugAgent(DebugAgent agent) {
        ThreadContext.get().debugAgent = agent;
    }

    public static MeterRegistry getMeterRegistry() {
        return ThreadContext.get().meterRegistry;
    }

    public static void setMeterRegistry(MeterRegistry registry) {
        ThreadContext.get().meterRegistry = registry == null ? new MeterRegistry(false) : registry;
    }

    public static IInterceptor getInterceptor() {
        return ThreadContext.get().interceptor;
    }

    public static void setInterceptor(IInterceptor interceptor) {
        ThreadContext.get().interceptor = interceptor == null ? REJECT_ALL_INTERCEPTOR : interceptor;
    }

    public static boolean isSandboxed() {
        return !(ThreadContext.get().interceptor instanceof AcceptAllInterceptor);
    }

    public static void clearValues(boolean preserveSystemValues) {
        try {
            if (preserveSystemValues) {
                ThreadContext ctx = ThreadContext.get();
                VncVal stdIn = ctx.values.get(STD_IN);
                VncVal stdOut = ctx.values.get(STD_OUT);
                VncVal stdErr = ctx.values.get(STD_ERR);
                ctx.values = new HashMap<VncKeyword, VncVal>();
                ctx.values.put(STD_IN, stdIn);
                ctx.values.put(STD_OUT, stdOut);
                ctx.values.put(STD_ERR, stdErr);
            } else {
                ThreadContext.get().values = new HashMap<VncKeyword, VncVal>();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void clear(boolean inUse) {
        ThreadContext ctx = ThreadContext.get();
        if (inUse && ctx.inUse) {
            throw new SecurityException("Rejected to start a second VeniceInterpreter within the same thread!");
        }
        try {
            ctx.interceptor = REJECT_ALL_INTERCEPTOR;
            ctx.debugAgent = null;
            ctx.values = new HashMap<VncKeyword, VncVal>();
            ctx.callStack = new CallStack();
            ctx.meterRegistry = new MeterRegistry(false);
            ctx.ns = new Namespace(DEFAULT_NS);
            ctx.inUse = inUse;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void remove() {
        try {
            ThreadContext.clear(false);
            context.set(null);
            context.remove();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ThreadContext get() {
        return context.get();
    }

    public static PrintStream getStdOut() {
        return Coerce.toVncJavaObject(ThreadContext.peekValue(STD_OUT), PrintStream.class);
    }

    public static PrintStream getStdErr() {
        return Coerce.toVncJavaObject(ThreadContext.peekValue(STD_ERR), PrintStream.class);
    }

    public static Reader getStdIn() {
        return Coerce.toVncJavaObject(ThreadContext.peekValue(STD_IN), Reader.class);
    }

    public static ThreadContextSnapshot snapshot() {
        ThreadContext ctx = ThreadContext.get();
        HashMap<VncKeyword, VncVal> vals = new HashMap<VncKeyword, VncVal>();
        ThreadContext.copyValues(ctx.values, vals);
        return new ThreadContextSnapshot(Thread.currentThread().getId(), ctx.ns, vals, ctx.debugAgent, ctx.interceptor, ctx.meterRegistry);
    }

    public static void inheritFrom(ThreadContextSnapshot snapshot) {
        ThreadContext ctx = ThreadContext.get();
        ThreadContext.copyValues(snapshot.getValues(), ctx.values);
        ctx.ns = snapshot.getNamespace();
        ctx.debugAgent = snapshot.getAgent();
        ctx.meterRegistry = snapshot.getMeterRegistry();
        ctx.interceptor = snapshot.getInterceptor();
    }

    private static void copyValues(Map<VncKeyword, VncVal> from, Map<VncKeyword, VncVal> to) {
        to.clear();
        for (Map.Entry<VncKeyword, VncVal> e : from.entrySet()) {
            VncVal val = e.getValue();
            if (val instanceof VncStack) {
                VncStack copyStack = new VncStack();
                if (!((VncStack)val).isEmpty()) {
                    copyStack.push(((VncStack)val).peek());
                }
                to.put(e.getKey(), copyStack);
                continue;
            }
            to.put(e.getKey(), val);
        }
    }
}

