/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms.util;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsContext;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.WithCallStack;

public class SpecialFormsUtil {
    public static void specialFormCallValidation(String name) {
        ThreadContext.getInterceptor().validateVeniceFunction(name);
    }

    public static VncSymbol evaluateSymbolMetaData(VncVal symVal, Env env, SpecialFormsContext ctx) {
        VncSymbol sym = Coerce.toVncSymbol(symVal);
        SpecialFormsUtil.validateNotReservedSymbol(sym);
        return sym.withMeta(ctx.getEvaluator().evaluate(sym.getMeta(), env, false));
    }

    public static VncSymbol validateSymbolWithCurrNS(VncSymbol sym, String specialFormName) {
        String ns;
        if (sym != null && (ns = sym.getNamespace()) != null && !ns.equals(Namespaces.getCurrentNS().getName())) {
            CallFrame cf = new CallFrame(specialFormName, sym.getMeta());
            WithCallStack cs = new WithCallStack(cf);
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("Special form '%s': Invalid use of namespace. The symbol '%s' can only be defined for the current namespace '%s'.", specialFormName, sym.getSimpleName(), Namespaces.getCurrentNS().toString()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        return sym;
    }

    public static VncVal evaluateBody(VncList body, SpecialFormsContext ctx, Env env, boolean withTailPosition) {
        ctx.getValuesEvaluator().evaluate_values(body.butlast(), env);
        return ctx.getEvaluator().evaluate(body.last(), env, withTailPosition);
    }

    public static String resolveClassName(String className) {
        return Namespaces.getCurrentNamespace().getJavaImports().resolveClassName(className);
    }

    private static void validateNotReservedSymbol(VncSymbol symbol) {
        if (symbol != null) {
            if (symbol.isSpecialFormName()) {
                WithCallStack cs = new WithCallStack(new CallFrame(symbol.getQualifiedName(), symbol.getMeta()));
                Throwable throwable = null;
                try {
                    try {
                        throw new VncException(String.format("The special form name '%s' can not be used a symbol.", symbol.getName()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (cs != null) {
                        if (throwable != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            cs.close();
                        }
                    }
                    throw throwable3;
                }
            }
            if (symbol.isReservedName()) {
                WithCallStack cs = new WithCallStack(new CallFrame(symbol.getQualifiedName(), symbol.getMeta()));
                Throwable throwable = null;
                try {
                    try {
                        throw new VncException(String.format("Reserved name '%s' can not be used a symbol.", symbol.getName()));
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                catch (Throwable throwable6) {
                    if (cs != null) {
                        if (throwable != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            cs.close();
                        }
                    }
                    throw throwable6;
                }
            }
        }
    }
}

