/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.ValueException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.javainterop.JavaImports;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.util.StackFrame;
import java.util.Map;

public class ExceptionFunctions {
    public static VncFunction throw_ = new VncFunction("throw", (VncVal)VncFunction.meta().arglists("(throw)", "(throw val)", "(throw ex)").doc("Throws an exception.\n\n`(throw)`\u00b6\nThrows a :ValueException with `nil` as its value.\n\n`(throw val)`\u00b6\nWith *val* as a Venice value throws a :ValueException with *val* as its value.\u00b6\nE.g: `(throw [1 2 3])`\n\n`(throw ex)`\u00b6\nWith a *ex* as an exception type throws the exception.\u00b6\nE.g: `(throw (ex :VncException \"invalid data\"))`").examples("(try                                                  \n   (+ 100 200)                                        \n   (catch :Exception e                                \n          \"caught ~(ex-message e)\"))                  ", "(try                                                  \n   (+ 100 200)                                        \n   (throw)                                            \n   (catch :ValueException e                           \n          \"caught ~(pr-str (ex-value e))\"))          ", "(try                                                  \n   (+ 100 200)                                        \n   (throw 100)                                        \n   (catch :ValueException e                           \n          \"caught ~(ex-value e)\"))                   ", ";; The finally block is just for side effects, like  \n;; closing resources. It never returns a value!      \n(try                                                 \n   (+ 100 200)                                       \n   (throw [100 {:a 3}])                              \n   (catch :ValueException e                          \n          \"caught ~(ex-value e)\")                  \n   (finally (println \"#finally\")                   \n            :finally))                                ", "(try                                                 \n   (throw (ex :RuntimeException \"#test\"))          \n   (catch :RuntimeException e                        \n          \"caught ~(ex-message e)\"))                ", ";; Venice wraps thrown checked exceptions with a RuntimeException! \n(do                                                                \n   (import :java.io.IOException)                                   \n   (try                                                            \n      (throw (ex :IOException \"#test\"))                          \n      (catch :RuntimeException e                                   \n             \"caught ~(ex-message (ex-cause e))\")))                ").seeAlso("ex", "try", "try-with").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1);
            if (args.isEmpty()) {
                throw new ValueException(Constants.Nil);
            }
            if (Types.isVncJavaObject(args.first(), Exception.class)) {
                Exception ex = (Exception)((VncJavaObject)args.first()).getDelegate();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
            throw new ValueException(args.first());
        }
    };
    public static VncFunction ex = new VncFunction("ex", (VncVal)VncFunction.meta().arglists("(ex class)", "(ex class args*)").doc("Creates an exception of type *class* with optional *args*. The *class* must be a subclass of :java.lang.Exception\n\nThe exception types:\n\n  * :java.lang.Exception \n  * :java.lang.RuntimeException \n  * :com.github.jlangch.venice.VncException \n  * :com.github.jlangch.venice.ValueException \n\nare imported implicitly so its alias :Exception, :RuntimeException, :VncException, and :ValueException can be used.\n\n**Checked vs unchecked exceptions**\n\nAll exceptions in Venice are *unchecked*.\n\nIf *checked* exceptions are thrown in Venice they are immediately wrapped in a :RuntimeException before being thrown!\u00b6If Venice catches a *checked* exception from a Java Interop call it wraps it in a :RuntimeException before handling it by the catch block selectors.").examples("(try                                                  \n   (throw (ex :VncException))                         \n   (catch :VncException e \"caught :VncException\"))   ", "(try                                                  \n   (throw (ex :RuntimeException \"#test\"))           \n   (catch :Exception e                                \n          \"msg: ~(ex-message e)\"))                   ", "(try                                                  \n   (throw (ex :ValueException 100))                   \n   (catch :ValueException e                           \n          \"value: ~(ex-value e)\"))                     ", "(do                                                                         \n   (defn throw-ex-with-cause []                                             \n      (try                                                                  \n         (throw (ex :java.io.IOException \"I/O failure\"))                  \n         (catch :Exception e                                                \n                (throw (ex :VncException \"failure\" (ex-cause e))))))      \n   (try                                                                     \n      (throw-ex-with-cause)                                                 \n      (catch :Exception e                                                   \n             \"msg: ~(ex-message e), cause: ~(ex-message (ex-cause e))\")))   ").seeAlso("throw", "try", "try-with", "ex?", "ex-venice?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            JavaImports javaImports = Namespaces.getCurrentNamespace().getJavaImports();
            Class<?> excClass = JavaInteropUtil.toClass(args.first(), javaImports);
            if (!Exception.class.isAssignableFrom(excClass)) {
                throw new VncException("Function 'ex' expects a 'class' arg as a subtype of :java.lang.Exception!");
            }
            VncList newExArgs = VncList.of(args.first(), new VncKeyword("new")).addAllAtEnd(args.rest());
            return JavaInteropUtil.applyJavaAccess(newExArgs, javaImports);
        }
    };
    public static VncFunction ex_Q = new VncFunction("ex?", (VncVal)VncFunction.meta().arglists("(ex? x)").doc("Returns true if x is a an instance of :java.lang.Throwable").examples("(ex? (ex :RuntimeException))").seeAlso("ex", "ex-venice?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (Types.isVncJavaObject(args.first(), Throwable.class)) {
                Throwable ex = (Throwable)((VncJavaObject)args.first()).getDelegate();
                return VncBoolean.of(ex instanceof Throwable);
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction ex_venice_Q = new VncFunction("ex-venice?", (VncVal)VncFunction.meta().arglists("(ex-venice? x)").doc("Returns true if x is a an instance of :VncException").examples("(ex-venice? (ex :VncException))", "(ex-venice? (ex :RuntimeException))").seeAlso("ex", "ex?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (Types.isVncJavaObject(args.first(), Throwable.class)) {
                Throwable ex = (Throwable)((VncJavaObject)args.first()).getDelegate();
                return VncBoolean.of(ex instanceof VncException);
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction ex_message = new VncFunction("ex-message", (VncVal)VncFunction.meta().arglists("(ex-message x)").doc("Returns the message of the exception").examples("(ex-message (ex :VncException \"a message\"))", "(ex-message (ex :RuntimeException))").seeAlso("ex", "ex-cause", "ex-value").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (Types.isVncJavaObject(args.first(), Throwable.class)) {
                Throwable ex = (Throwable)((VncJavaObject)args.first()).getDelegate();
                String msg = ex.getMessage();
                return msg == null ? Constants.Nil : new VncString(ex.getMessage());
            }
            throw new VncException("Function 'ex-message' expects a :java.lang.Throwable as arg!");
        }
    };
    public static VncFunction ex_cause = new VncFunction("ex-cause", (VncVal)VncFunction.meta().arglists("(ex-cause x)").doc("Returns the exception cause or nil").examples("(ex-cause (ex :VncException \"a message\" (ex :RuntimeException \"..cause..\")))", "(ex-cause (ex :VncException \"a message\"))").seeAlso("ex", "ex-message", "ex-value").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (Types.isVncJavaObject(args.first(), Throwable.class)) {
                Throwable ex = (Throwable)((VncJavaObject)args.first()).getDelegate();
                Throwable cause = ex.getCause();
                return cause == null ? Constants.Nil : new VncJavaObject(cause);
            }
            throw new VncException("Function 'ex-cause' expects a :java.lang.Throwable as arg!");
        }
    };
    public static VncFunction ex_value = new VncFunction("ex-value", (VncVal)VncFunction.meta().arglists("(ex-value x)").doc("Returns the value associated with a :ValueException or nil if the exception is not a :ValueException").examples("(ex-value (ex :ValueException [10 20]))", "(ex-value (ex :RuntimeException))").seeAlso("ex", "ex-message", "ex-cause").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (Types.isVncJavaObject(args.first(), Throwable.class)) {
                VncConstant value;
                Throwable ex = (Throwable)((VncJavaObject)args.first()).getDelegate();
                VncConstant vncConstant = value = ex instanceof ValueException ? ((ValueException)ex).getValue() : Constants.Nil;
                if (value == null || value == Constants.Nil) {
                    return Constants.Nil;
                }
                return value instanceof VncVal ? (VncVal)value : JavaInteropUtil.convertToVncVal(value);
            }
            throw new VncException("Function 'ex-value' expects a :java.lang.Throwable as arg!");
        }
    };
    public static VncFunction ex_venice_stacktrace = new VncFunction("ex-venice-stacktrace", (VncVal)VncFunction.meta().arglists("(ex-venice-stacktrace x)", "(ex-venice-stacktrace x format)").doc("Returns the Venice stacktrace for an exception or nil if the exception is not a venice exception.\n\nThe optional format (:string or :list) controls the format of the returned stacktrace. The default format is :string.").examples("(println (ex-venice-stacktrace (ex :ValueException [10 20])))", "(println (ex-venice-stacktrace (ex :RuntimeException \"message\")))", "(println (ex-venice-stacktrace (ex :ValueException [10 20]) :list))").seeAlso("ex", "ex-java-stacktrace").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Exception decompiling
         */
        @Override
        public VncVal apply(VncList args) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ VncOrderedMap lambda$apply$0(StackFrame s) {
            return VncOrderedMap.of(new VncKeyword("fn"), new VncString(s.getFnName()), new VncKeyword("file"), new VncString(s.getFile()), new VncKeyword("line"), new VncLong(s.getLine()), new VncKeyword("col"), new VncLong(s.getCol()));
        }
    };
    public static VncFunction ex_java_stacktrace = new VncFunction("ex-java-stacktrace", (VncVal)VncFunction.meta().arglists("(ex-java-stacktrace x)", "(ex-java-stacktrace x format)").doc("Returns the Java stacktrace for an exception.\n\nThe optional format (:string or :list) controls the format of the returned stacktrace. The default format is :string.").examples("(println (ex-java-stacktrace (ex :RuntimeException \"message\")))", "(println (ex-java-stacktrace (ex :VncException \"message\") :list))").seeAlso("ex", "ex-venice-stacktrace").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Exception decompiling
         */
        @Override
        public VncVal apply(VncList args) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ VncOrderedMap lambda$apply$0(StackTraceElement s) {
            return VncOrderedMap.of(new VncKeyword("class"), new VncString(s.getClassName()), new VncKeyword("method"), new VncString(s.getMethodName()), new VncKeyword("file"), new VncString(s.getFileName()), new VncKeyword("line"), new VncLong(s.getLineNumber()), new VncKeyword("native"), VncBoolean.of(s.isNativeMethod()));
        }
    };
    public static Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(throw_).add(ex).add(ex_Q).add(ex_venice_Q).add(ex_message).add(ex_cause).add(ex_value).add(ex_venice_stacktrace).add(ex_java_stacktrace).toMap();
}

