/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen.cheatsheet.section;

import com.github.jlangch.venice.impl.docgen.cheatsheet.DocItemBuilder;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.ISectionBuilder;

public class CollectionsSection
implements ISectionBuilder {
    private final DocItemBuilder diBuilder;

    public CollectionsSection(DocItemBuilder diBuilder) {
        this.diBuilder = diBuilder;
    }

    @Override
    public DocSection section() {
        DocSection section = new DocSection("Collections", "collections");
        DocSection collections = new DocSection("Collections", "collections.collections");
        section.addSection(collections);
        DocSection generic = new DocSection("Generic", "collections.collections.generic");
        collections.addSection(generic);
        generic.addItem(this.diBuilder.getDocItem("count"));
        generic.addItem(this.diBuilder.getDocItem("compare"));
        generic.addItem(this.diBuilder.getDocItem("empty-to-nil"));
        generic.addItem(this.diBuilder.getDocItem("empty"));
        generic.addItem(this.diBuilder.getDocItem("into"));
        generic.addItem(this.diBuilder.getDocItem("into!"));
        generic.addItem(this.diBuilder.getDocItem("cons"));
        generic.addItem(this.diBuilder.getDocItem("conj"));
        generic.addItem(this.diBuilder.getDocItem("conj!"));
        generic.addItem(this.diBuilder.getDocItem("remove"));
        generic.addItem(this.diBuilder.getDocItem("repeat"));
        generic.addItem(this.diBuilder.getDocItem("repeatedly"));
        generic.addItem(this.diBuilder.getDocItem("cycle"));
        generic.addItem(this.diBuilder.getDocItem("replace"));
        generic.addItem(this.diBuilder.getDocItem("range"));
        generic.addItem(this.diBuilder.getDocItem("group-by"));
        generic.addItem(this.diBuilder.getDocItem("frequencies"));
        generic.addItem(this.diBuilder.getDocItem("get-in"));
        generic.addItem(this.diBuilder.getDocItem("seq"));
        generic.addItem(this.diBuilder.getDocItem("reverse"));
        generic.addItem(this.diBuilder.getDocItem("shuffle"));
        DocSection coll_test = new DocSection("Tests", "collections.collections.tests");
        collections.addSection(coll_test);
        coll_test.addItem(this.diBuilder.getDocItem("empty?"));
        coll_test.addItem(this.diBuilder.getDocItem("not-empty?"));
        coll_test.addItem(this.diBuilder.getDocItem("coll?"));
        coll_test.addItem(this.diBuilder.getDocItem("list?"));
        coll_test.addItem(this.diBuilder.getDocItem("vector?"));
        coll_test.addItem(this.diBuilder.getDocItem("set?"));
        coll_test.addItem(this.diBuilder.getDocItem("sorted-set?"));
        coll_test.addItem(this.diBuilder.getDocItem("mutable-set?"));
        coll_test.addItem(this.diBuilder.getDocItem("map?"));
        coll_test.addItem(this.diBuilder.getDocItem("sequential?"));
        coll_test.addItem(this.diBuilder.getDocItem("hash-map?"));
        coll_test.addItem(this.diBuilder.getDocItem("ordered-map?"));
        coll_test.addItem(this.diBuilder.getDocItem("sorted-map?"));
        coll_test.addItem(this.diBuilder.getDocItem("mutable-map?"));
        coll_test.addItem(this.diBuilder.getDocItem("bytebuf?"));
        DocSection coll_process = new DocSection("Process", "collections.collections.process");
        collections.addSection(coll_process);
        coll_process.addItem(this.diBuilder.getDocItem("map"));
        coll_process.addItem(this.diBuilder.getDocItem("map-indexed"));
        coll_process.addItem(this.diBuilder.getDocItem("filter"));
        coll_process.addItem(this.diBuilder.getDocItem("reduce"));
        coll_process.addItem(this.diBuilder.getDocItem("keep"));
        coll_process.addItem(this.diBuilder.getDocItem("docoll"));
        DocSection lists = new DocSection("Lists", "collections.lists");
        section.addSection(lists);
        DocSection list_create = new DocSection("Create", "collections.lists.create");
        lists.addSection(list_create);
        list_create.addItem(this.diBuilder.getDocItem("()"));
        list_create.addItem(this.diBuilder.getDocItem("list"));
        list_create.addItem(this.diBuilder.getDocItem("list*"));
        list_create.addItem(this.diBuilder.getDocItem("mutable-list"));
        DocSection list_access = new DocSection("Access", "collections.lists.access");
        lists.addSection(list_access);
        list_access.addItem(this.diBuilder.getDocItem("first"));
        list_access.addItem(this.diBuilder.getDocItem("second"));
        list_access.addItem(this.diBuilder.getDocItem("third"));
        list_access.addItem(this.diBuilder.getDocItem("fourth"));
        list_access.addItem(this.diBuilder.getDocItem("nth"));
        list_access.addItem(this.diBuilder.getDocItem("last"));
        list_access.addItem(this.diBuilder.getDocItem("peek"));
        list_access.addItem(this.diBuilder.getDocItem("rest"));
        list_access.addItem(this.diBuilder.getDocItem("butlast"));
        list_access.addItem(this.diBuilder.getDocItem("nfirst"));
        list_access.addItem(this.diBuilder.getDocItem("nlast"));
        list_access.addItem(this.diBuilder.getDocItem("sublist"));
        list_access.addItem(this.diBuilder.getDocItem("some"));
        DocSection list_modify = new DocSection("Modify", "collections.lists.modify");
        lists.addSection(list_modify);
        list_modify.addItem(this.diBuilder.getDocItem("cons"));
        list_modify.addItem(this.diBuilder.getDocItem("conj"));
        list_modify.addItem(this.diBuilder.getDocItem("conj!"));
        list_modify.addItem(this.diBuilder.getDocItem("rest"));
        list_modify.addItem(this.diBuilder.getDocItem("pop"));
        list_modify.addItem(this.diBuilder.getDocItem("into"));
        list_modify.addItem(this.diBuilder.getDocItem("into!"));
        list_modify.addItem(this.diBuilder.getDocItem("concat"));
        list_modify.addItem(this.diBuilder.getDocItem("distinct"));
        list_modify.addItem(this.diBuilder.getDocItem("dedupe"));
        list_modify.addItem(this.diBuilder.getDocItem("partition"));
        list_modify.addItem(this.diBuilder.getDocItem("partition-by"));
        list_modify.addItem(this.diBuilder.getDocItem("interpose"));
        list_modify.addItem(this.diBuilder.getDocItem("interleave"));
        list_modify.addItem(this.diBuilder.getDocItem("cartesian-product"));
        list_modify.addItem(this.diBuilder.getDocItem("combinations"));
        list_modify.addItem(this.diBuilder.getDocItem("mapcat"));
        list_modify.addItem(this.diBuilder.getDocItem("flatten"));
        list_modify.addItem(this.diBuilder.getDocItem("sort"));
        list_modify.addItem(this.diBuilder.getDocItem("sort-by"));
        list_modify.addItem(this.diBuilder.getDocItem("take"));
        list_modify.addItem(this.diBuilder.getDocItem("take-while"));
        list_modify.addItem(this.diBuilder.getDocItem("take-last"));
        list_modify.addItem(this.diBuilder.getDocItem("drop"));
        list_modify.addItem(this.diBuilder.getDocItem("drop-while"));
        list_modify.addItem(this.diBuilder.getDocItem("drop-last"));
        list_modify.addItem(this.diBuilder.getDocItem("split-at"));
        list_modify.addItem(this.diBuilder.getDocItem("split-with"));
        DocSection list_test = new DocSection("Test", "collections.lists.test");
        lists.addSection(list_test);
        list_test.addItem(this.diBuilder.getDocItem("list?"));
        list_test.addItem(this.diBuilder.getDocItem("mutable-list?"));
        list_test.addItem(this.diBuilder.getDocItem("every?"));
        list_test.addItem(this.diBuilder.getDocItem("not-every?"));
        list_test.addItem(this.diBuilder.getDocItem("any?"));
        list_test.addItem(this.diBuilder.getDocItem("not-any?"));
        DocSection vectors = new DocSection("Vectors", "collections.vectors");
        section.addSection(vectors);
        DocSection vec_create = new DocSection("Create", "collections.vectors.create");
        vectors.addSection(vec_create);
        vec_create.addItem(this.diBuilder.getDocItem("[]"));
        vec_create.addItem(this.diBuilder.getDocItem("vector"));
        vec_create.addItem(this.diBuilder.getDocItem("vector*"));
        vec_create.addItem(this.diBuilder.getDocItem("mutable-vector"));
        vec_create.addItem(this.diBuilder.getDocItem("mapv"));
        DocSection vec_access = new DocSection("Access", "collections.vectors.access");
        vectors.addSection(vec_access);
        vec_access.addItem(this.diBuilder.getDocItem("first"));
        vec_access.addItem(this.diBuilder.getDocItem("second"));
        vec_access.addItem(this.diBuilder.getDocItem("third"));
        vec_access.addItem(this.diBuilder.getDocItem("nth"));
        vec_access.addItem(this.diBuilder.getDocItem("last"));
        vec_access.addItem(this.diBuilder.getDocItem("peek"));
        vec_access.addItem(this.diBuilder.getDocItem("butlast"));
        vec_access.addItem(this.diBuilder.getDocItem("rest"));
        vec_access.addItem(this.diBuilder.getDocItem("nfirst"));
        vec_access.addItem(this.diBuilder.getDocItem("nlast"));
        vec_access.addItem(this.diBuilder.getDocItem("subvec"));
        vec_access.addItem(this.diBuilder.getDocItem("some"));
        DocSection vec_modify = new DocSection("Modify", "collections.vectors.modify");
        vectors.addSection(vec_modify);
        vec_modify.addItem(this.diBuilder.getDocItem("cons"));
        vec_modify.addItem(this.diBuilder.getDocItem("conj"));
        vec_modify.addItem(this.diBuilder.getDocItem("conj!"));
        vec_modify.addItem(this.diBuilder.getDocItem("rest"));
        vec_modify.addItem(this.diBuilder.getDocItem("pop"));
        vec_modify.addItem(this.diBuilder.getDocItem("into"));
        vec_modify.addItem(this.diBuilder.getDocItem("into!"));
        vec_modify.addItem(this.diBuilder.getDocItem("concat"));
        vec_modify.addItem(this.diBuilder.getDocItem("distinct"));
        vec_modify.addItem(this.diBuilder.getDocItem("dedupe"));
        vec_modify.addItem(this.diBuilder.getDocItem("partition"));
        vec_modify.addItem(this.diBuilder.getDocItem("partition-by"));
        vec_modify.addItem(this.diBuilder.getDocItem("interpose"));
        vec_modify.addItem(this.diBuilder.getDocItem("interleave"));
        vec_modify.addItem(this.diBuilder.getDocItem("cartesian-product"));
        vec_modify.addItem(this.diBuilder.getDocItem("combinations"));
        vec_modify.addItem(this.diBuilder.getDocItem("mapcat"));
        vec_modify.addItem(this.diBuilder.getDocItem("flatten"));
        vec_modify.addItem(this.diBuilder.getDocItem("sort"));
        vec_modify.addItem(this.diBuilder.getDocItem("sort-by"));
        vec_modify.addItem(this.diBuilder.getDocItem("take"));
        vec_modify.addItem(this.diBuilder.getDocItem("take-while"));
        vec_modify.addItem(this.diBuilder.getDocItem("take-last"));
        vec_modify.addItem(this.diBuilder.getDocItem("drop"));
        vec_modify.addItem(this.diBuilder.getDocItem("drop-while"));
        vec_modify.addItem(this.diBuilder.getDocItem("drop-last"));
        vec_modify.addItem(this.diBuilder.getDocItem("update"));
        vec_modify.addItem(this.diBuilder.getDocItem("update!"));
        vec_modify.addItem(this.diBuilder.getDocItem("assoc"));
        vec_modify.addItem(this.diBuilder.getDocItem("assoc!"));
        vec_modify.addItem(this.diBuilder.getDocItem("split-with"));
        DocSection vec_nested = new DocSection("Nested", "collections.vectors.nested");
        vectors.addSection(vec_nested);
        vec_nested.addItem(this.diBuilder.getDocItem("get-in"));
        vec_nested.addItem(this.diBuilder.getDocItem("assoc-in"));
        vec_nested.addItem(this.diBuilder.getDocItem("update-in"));
        vec_nested.addItem(this.diBuilder.getDocItem("dissoc-in"));
        DocSection vec_test = new DocSection("Test", "collections.vectors.test");
        vectors.addSection(vec_test);
        vec_test.addItem(this.diBuilder.getDocItem("vector?"));
        vec_test.addItem(this.diBuilder.getDocItem("mutable-vector?"));
        vec_test.addItem(this.diBuilder.getDocItem("contains?"));
        vec_test.addItem(this.diBuilder.getDocItem("not-contains?"));
        vec_test.addItem(this.diBuilder.getDocItem("every?"));
        vec_test.addItem(this.diBuilder.getDocItem("not-every?"));
        vec_test.addItem(this.diBuilder.getDocItem("any?"));
        vec_test.addItem(this.diBuilder.getDocItem("not-any?"));
        DocSection sets = new DocSection("Sets", "collections.sets");
        section.addSection(sets);
        DocSection set_create = new DocSection("Create", "collections.sets.create");
        sets.addSection(set_create);
        set_create.addItem(this.diBuilder.getDocItem("#{}"));
        set_create.addItem(this.diBuilder.getDocItem("set"));
        set_create.addItem(this.diBuilder.getDocItem("sorted-set"));
        set_create.addItem(this.diBuilder.getDocItem("mutable-set"));
        DocSection set_modify = new DocSection("Modify", "collections.sets.modify");
        sets.addSection(set_modify);
        set_modify.addItem(this.diBuilder.getDocItem("into"));
        set_modify.addItem(this.diBuilder.getDocItem("into!"));
        set_modify.addItem(this.diBuilder.getDocItem("cons"));
        set_modify.addItem(this.diBuilder.getDocItem("cons!"));
        set_modify.addItem(this.diBuilder.getDocItem("conj"));
        set_modify.addItem(this.diBuilder.getDocItem("conj!"));
        set_modify.addItem(this.diBuilder.getDocItem("disj"));
        DocSection algebra = new DocSection("Algebra", "collections.sets.algebra");
        sets.addSection(algebra);
        algebra.addItem(this.diBuilder.getDocItem("difference"));
        algebra.addItem(this.diBuilder.getDocItem("union"));
        algebra.addItem(this.diBuilder.getDocItem("intersection"));
        algebra.addItem(this.diBuilder.getDocItem("subset?"));
        algebra.addItem(this.diBuilder.getDocItem("superset?"));
        DocSection set_test = new DocSection("Test", "collections.sets.test");
        sets.addSection(set_test);
        set_test.addItem(this.diBuilder.getDocItem("set?"));
        set_test.addItem(this.diBuilder.getDocItem("sorted-set?"));
        set_test.addItem(this.diBuilder.getDocItem("mutable-set?"));
        set_test.addItem(this.diBuilder.getDocItem("contains?"));
        set_test.addItem(this.diBuilder.getDocItem("not-contains?"));
        set_test.addItem(this.diBuilder.getDocItem("every?"));
        set_test.addItem(this.diBuilder.getDocItem("not-every?"));
        set_test.addItem(this.diBuilder.getDocItem("any?"));
        set_test.addItem(this.diBuilder.getDocItem("not-any?"));
        DocSection maps = new DocSection("Maps", "collections.maps");
        section.addSection(maps);
        DocSection maps_create = new DocSection("Create", "collections.maps.create");
        maps.addSection(maps_create);
        maps_create.addItem(this.diBuilder.getDocItem("{}"));
        maps_create.addItem(this.diBuilder.getDocItem("hash-map"));
        maps_create.addItem(this.diBuilder.getDocItem("ordered-map"));
        maps_create.addItem(this.diBuilder.getDocItem("sorted-map"));
        maps_create.addItem(this.diBuilder.getDocItem("mutable-map"));
        maps_create.addItem(this.diBuilder.getDocItem("zipmap"));
        DocSection map_access = new DocSection("Access", "collections.maps.access");
        maps.addSection(map_access);
        map_access.addItem(this.diBuilder.getDocItem("find"));
        map_access.addItem(this.diBuilder.getDocItem("get"));
        map_access.addItem(this.diBuilder.getDocItem("keys"));
        map_access.addItem(this.diBuilder.getDocItem("vals"));
        DocSection map_modify = new DocSection("Modify", "collections.maps.modify");
        maps.addSection(map_modify);
        map_modify.addItem(this.diBuilder.getDocItem("cons"));
        map_modify.addItem(this.diBuilder.getDocItem("conj"));
        map_modify.addItem(this.diBuilder.getDocItem("conj!"));
        map_modify.addItem(this.diBuilder.getDocItem("assoc"));
        map_modify.addItem(this.diBuilder.getDocItem("assoc!"));
        map_modify.addItem(this.diBuilder.getDocItem("update"));
        map_modify.addItem(this.diBuilder.getDocItem("update!"));
        map_modify.addItem(this.diBuilder.getDocItem("dissoc"));
        map_modify.addItem(this.diBuilder.getDocItem("dissoc!"));
        map_modify.addItem(this.diBuilder.getDocItem("into"));
        map_modify.addItem(this.diBuilder.getDocItem("into!"));
        map_modify.addItem(this.diBuilder.getDocItem("concat"));
        map_modify.addItem(this.diBuilder.getDocItem("flatten"));
        map_modify.addItem(this.diBuilder.getDocItem("filter-k"));
        map_modify.addItem(this.diBuilder.getDocItem("filter-kv"));
        map_modify.addItem(this.diBuilder.getDocItem("reduce-kv"));
        map_modify.addItem(this.diBuilder.getDocItem("merge"));
        map_modify.addItem(this.diBuilder.getDocItem("merge-with"));
        map_modify.addItem(this.diBuilder.getDocItem("merge-deep"));
        map_modify.addItem(this.diBuilder.getDocItem("map-invert"));
        map_modify.addItem(this.diBuilder.getDocItem("map-keys"));
        map_modify.addItem(this.diBuilder.getDocItem("map-vals"));
        map_modify.addItem(this.diBuilder.getDocItem("select-keys"));
        DocSection map_entries = new DocSection("Entries", "collections.maps.entries");
        maps.addSection(map_entries);
        map_entries.addItem(this.diBuilder.getDocItem("map-entry"));
        map_entries.addItem(this.diBuilder.getDocItem("key"));
        map_entries.addItem(this.diBuilder.getDocItem("val"));
        map_entries.addItem(this.diBuilder.getDocItem("entries"));
        map_entries.addItem(this.diBuilder.getDocItem("map-entry?"));
        DocSection map_nested = new DocSection("Nested", "collections.maps.nested");
        maps.addSection(map_nested);
        map_nested.addItem(this.diBuilder.getDocItem("get-in"));
        map_nested.addItem(this.diBuilder.getDocItem("assoc-in"));
        map_nested.addItem(this.diBuilder.getDocItem("update-in"));
        map_nested.addItem(this.diBuilder.getDocItem("dissoc-in"));
        DocSection map_test = new DocSection("Test", "collections.maps.test");
        maps.addSection(map_test);
        map_test.addItem(this.diBuilder.getDocItem("map?"));
        map_test.addItem(this.diBuilder.getDocItem("sequential?"));
        map_test.addItem(this.diBuilder.getDocItem("hash-map?"));
        map_test.addItem(this.diBuilder.getDocItem("ordered-map?"));
        map_test.addItem(this.diBuilder.getDocItem("sorted-map?"));
        map_test.addItem(this.diBuilder.getDocItem("mutable-map?"));
        map_test.addItem(this.diBuilder.getDocItem("contains?"));
        map_test.addItem(this.diBuilder.getDocItem("not-contains?"));
        DocSection stacks = new DocSection("Stack", "collections.stack");
        section.addSection(stacks);
        DocSection stacks_create = new DocSection("Create", "collections.stack.create");
        stacks.addSection(stacks_create);
        stacks_create.addItem(this.diBuilder.getDocItem("stack"));
        DocSection stacks_access = new DocSection("Access", "collections.stack.access");
        stacks.addSection(stacks_access);
        stacks_access.addItem(this.diBuilder.getDocItem("peek"));
        stacks_access.addItem(this.diBuilder.getDocItem("pop!"));
        stacks_access.addItem(this.diBuilder.getDocItem("push!"));
        stacks_access.addItem(this.diBuilder.getDocItem("into!"));
        stacks_access.addItem(this.diBuilder.getDocItem("conj!"));
        stacks_access.addItem(this.diBuilder.getDocItem("count"));
        DocSection stacks_test = new DocSection("Test", "collections.stack.test");
        stacks.addSection(stacks_test);
        stacks_test.addItem(this.diBuilder.getDocItem("empty?"));
        stacks_test.addItem(this.diBuilder.getDocItem("stack?"));
        DocSection queues = new DocSection("Queue", "collections.queue");
        section.addSection(queues);
        DocSection queues_create = new DocSection("Create", "collections.queue.create");
        queues.addSection(queues_create);
        queues_create.addItem(this.diBuilder.getDocItem("queue"));
        DocSection queues_access = new DocSection("Access", "collections.queue.access");
        queues.addSection(queues_access);
        queues_access.addItem(this.diBuilder.getDocItem("peek"));
        queues_access.addItem(this.diBuilder.getDocItem("into!"));
        queues_access.addItem(this.diBuilder.getDocItem("conj!"));
        queues_access.addItem(this.diBuilder.getDocItem("count"));
        DocSection queues_access_sync = new DocSection("Sync", "collections.queue.access.sync");
        queues.addSection(queues_access_sync);
        queues_access_sync.addItem(this.diBuilder.getDocItem("put!"));
        queues_access_sync.addItem(this.diBuilder.getDocItem("take!"));
        DocSection queues_access_async = new DocSection("Async", "collections.queue.access.async");
        queues.addSection(queues_access_async);
        queues_access_async.addItem(this.diBuilder.getDocItem("offer!"));
        queues_access_async.addItem(this.diBuilder.getDocItem("poll!"));
        DocSection queues_process = new DocSection("Process", "collections.queue.process");
        queues.addSection(queues_process);
        queues_process.addItem(this.diBuilder.getDocItem("docoll"));
        queues_process.addItem(this.diBuilder.getDocItem("transduce"));
        queues_process.addItem(this.diBuilder.getDocItem("reduce"));
        DocSection queues_test = new DocSection("Test", "collections.queue.test");
        queues.addSection(queues_test);
        queues_test.addItem(this.diBuilder.getDocItem("empty?"));
        queues_test.addItem(this.diBuilder.getDocItem("queue?"));
        DocSection dqueues = new DocSection("DelayQueue", "collections.delayqueue");
        section.addSection(dqueues);
        DocSection dqueues_create = new DocSection("Create", "collections.delayqueue.create");
        dqueues.addSection(dqueues_create);
        dqueues_create.addItem(this.diBuilder.getDocItem("delay-queue"));
        DocSection dqueues_access = new DocSection("Access", "collections.delayqueue.access");
        dqueues.addSection(dqueues_access);
        dqueues_access.addItem(this.diBuilder.getDocItem("peek"));
        dqueues_access.addItem(this.diBuilder.getDocItem("count"));
        DocSection dqueues_access_sync = new DocSection("Sync", "collections.delayqueue.access.sync");
        dqueues.addSection(dqueues_access_sync);
        dqueues_access_sync.addItem(this.diBuilder.getDocItem("put!"));
        dqueues_access_sync.addItem(this.diBuilder.getDocItem("take!"));
        DocSection dqueues_access_async = new DocSection("Async", "collections.delayqueue.access.async");
        dqueues.addSection(dqueues_access_async);
        dqueues_access_async.addItem(this.diBuilder.getDocItem("poll!"));
        DocSection dqueues_test = new DocSection("Test", "collections.delayqueue.test");
        dqueues.addSection(dqueues_test);
        dqueues_test.addItem(this.diBuilder.getDocItem("empty?"));
        dqueues_test.addItem(this.diBuilder.getDocItem("delay-queue?"));
        DocSection dag = new DocSection("DAG", "directed acyclic graph", "collections.dag");
        section.addSection(dag);
        DocSection dag_create = new DocSection("Create", "collections.dag.create");
        dag.addSection(dag_create);
        dag_create.addItem(this.diBuilder.getDocItem("dag/dag"));
        dag_create.addItem(this.diBuilder.getDocItem("dag/add-edges"));
        dag_create.addItem(this.diBuilder.getDocItem("dag/add-nodes"));
        DocSection dag_access = new DocSection("Access", "collections.dag.access");
        dag.addSection(dag_access);
        dag_access.addItem(this.diBuilder.getDocItem("dag/nodes"));
        dag_access.addItem(this.diBuilder.getDocItem("dag/edges"));
        dag_access.addItem(this.diBuilder.getDocItem("dag/roots"));
        dag_access.addItem(this.diBuilder.getDocItem("count"));
        DocSection dag_children = new DocSection("Children", "collections.dag.children");
        dag.addSection(dag_children);
        dag_children.addItem(this.diBuilder.getDocItem("dag/children"));
        dag_children.addItem(this.diBuilder.getDocItem("dag/direct-children"));
        DocSection dag_parents = new DocSection("Parents", "collections.dag.parents");
        dag.addSection(dag_parents);
        dag_parents.addItem(this.diBuilder.getDocItem("dag/parents"));
        dag_parents.addItem(this.diBuilder.getDocItem("dag/direct-parents"));
        DocSection dag_sort = new DocSection("Sort", "collections.dag.sort");
        dag.addSection(dag_sort);
        dag_sort.addItem(this.diBuilder.getDocItem("dag/topological-sort"));
        dag_sort.addItem(this.diBuilder.getDocItem("dag/compare-fn"));
        DocSection dag_test = new DocSection("Test", "collections.dag.test");
        dag.addSection(dag_test);
        dag_test.addItem(this.diBuilder.getDocItem("dag/dag?"));
        dag_test.addItem(this.diBuilder.getDocItem("dag/node?"));
        dag_test.addItem(this.diBuilder.getDocItem("dag/edge?"));
        dag_test.addItem(this.diBuilder.getDocItem("dag/parent-of?"));
        dag_test.addItem(this.diBuilder.getDocItem("dag/child-of?"));
        dag_test.addItem(this.diBuilder.getDocItem("empty?"));
        return section;
    }
}

