/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.debug.breakpoint;

import com.github.jlangch.venice.impl.debug.breakpoint.AncestorSelector;
import com.github.jlangch.venice.impl.debug.breakpoint.FunctionScope;
import com.github.jlangch.venice.impl.util.CollectionUtil;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Selector {
    private static final Set<FunctionScope> DEFAULT_SCOPES = CollectionUtil.toSet(FunctionScope.FunctionEntry);
    private final Set<FunctionScope> scopes;
    private final AncestorSelector ancestorSelector;

    public Selector() {
        this(null, null);
    }

    public Selector(Set<FunctionScope> scopes) {
        this(scopes, null);
    }

    public Selector(Set<FunctionScope> scopes, AncestorSelector ancestorSelector) {
        this.scopes = scopes == null || scopes.isEmpty() ? DEFAULT_SCOPES : new HashSet<FunctionScope>(scopes);
        this.ancestorSelector = ancestorSelector;
    }

    public boolean hasScope(FunctionScope scope) {
        return scope == null ? false : this.scopes.contains((Object)scope);
    }

    public AncestorSelector getAncestorSelector() {
        return this.ancestorSelector;
    }

    public boolean hasSameAncestorSelector(Selector other) {
        return Objects.equals(this.ancestorSelector, other.getAncestorSelector());
    }

    public String formatForBaseFn(String fnName, boolean useDescriptiveScopeNames) {
        String sScopes = this.format(this.scopes, useDescriptiveScopeNames);
        if (this.ancestorSelector != null) {
            return StringUtil.isBlank(sScopes) ? this.ancestorSelector.formatForBaseFn(fnName) : String.format("%s at level %s", this.ancestorSelector.formatForBaseFn(fnName), sScopes);
        }
        return StringUtil.isBlank(sScopes) ? fnName : String.format("%s at level %s", fnName, sScopes);
    }

    public String getFormattedScopes() {
        return this.format(this.scopes, false);
    }

    private String format(Set<FunctionScope> scopes, boolean useDescriptiveScopeNames) {
        if (scopes.size() == 1 && scopes.contains((Object)FunctionScope.FunctionEntry)) {
            return "";
        }
        String delimiter = useDescriptiveScopeNames ? ", " : "";
        return Arrays.asList(FunctionScope.FunctionCall, FunctionScope.FunctionEntry, FunctionScope.FunctionException, FunctionScope.FunctionExit).stream().filter(t -> scopes.contains(t)).map(t -> useDescriptiveScopeNames ? t.description() : t.symbol()).collect(Collectors.joining(delimiter));
    }
}

