/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.NotInTailPositionException;
import com.github.jlangch.venice.SecurityException;
import com.github.jlangch.venice.Version;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.FunctionBuilder;
import com.github.jlangch.venice.impl.IVeniceInterpreter;
import com.github.jlangch.venice.impl.InterruptChecker;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Modules;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.RecursionPoint;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.debug.agent.DebugAgent;
import com.github.jlangch.venice.impl.debug.breakpoint.BreakpointFnRef;
import com.github.jlangch.venice.impl.debug.breakpoint.FunctionScope;
import com.github.jlangch.venice.impl.env.ComputedVar;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.Functions;
import com.github.jlangch.venice.impl.functions.TransducerFunctions;
import com.github.jlangch.venice.impl.namespaces.Namespace;
import com.github.jlangch.venice.impl.namespaces.NamespaceRegistry;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.reader.Reader;
import com.github.jlangch.venice.impl.specialforms.SpecialForms_OtherFunctions;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsContext;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncScalar;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncLazySeq;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncMutableSet;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.CallFrameFnData;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.CollectionUtil;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.WithCallStack;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class VeniceInterpreter
implements IVeniceInterpreter,
Serializable {
    private static final long serialVersionUID = -8130740279914790685L;
    private final IInterceptor interceptor;
    private final boolean checkSandbox;
    private final MeterRegistry meterRegistry;
    private final NamespaceRegistry nsRegistry;
    private final SpecialFormsContext specialFormsContext;
    private final FunctionBuilder functionBuilder;
    private final AtomicBoolean sealedSystemNS;
    private final boolean optimized;
    private volatile boolean macroExpandOnLoad = false;

    public VeniceInterpreter(IInterceptor interceptor) {
        this(interceptor, null);
    }

    public VeniceInterpreter(IInterceptor interceptor, MeterRegistry meterRegistry) {
        if (interceptor == null) {
            throw new SecurityException("VeniceInterpreter can not run without an interceptor");
        }
        MeterRegistry mr = meterRegistry == null ? new MeterRegistry(false) : meterRegistry;
        this.interceptor = interceptor;
        this.meterRegistry = mr;
        this.nsRegistry = new NamespaceRegistry();
        this.sealedSystemNS = new AtomicBoolean(false);
        this.checkSandbox = !(interceptor instanceof AcceptAllInterceptor);
        this.optimized = false;
        this.functionBuilder = new FunctionBuilder(this::evaluate, this.optimized);
        this.specialFormsContext = new SpecialFormsContext(this, this::evaluate, this::evaluate_values, this::evaluate_sequence_values, this.functionBuilder, this.nsRegistry, this.meterRegistry, this.sealedSystemNS);
        ThreadContext.setInterceptor(interceptor);
        ThreadContext.setMeterRegistry(mr);
        if (this.optimized && this.checkSandbox) {
            throw new VncException("Venice interpreter supports optimized mode only with AcceptAllInterceptor!");
        }
    }

    @Override
    public void initNS() {
        this.nsRegistry.clear();
        Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent(Namespaces.NS_USER));
    }

    @Override
    public void sealSystemNS() {
        this.sealedSystemNS.set(true);
    }

    @Override
    public void setMacroExpandOnLoad(boolean macroExpandOnLoad, Env env) {
        this.macroExpandOnLoad = macroExpandOnLoad;
    }

    @Override
    public boolean isMacroExpandOnLoad() {
        return this.macroExpandOnLoad;
    }

    @Override
    public VncVal READ(String script, String filename) {
        if (this.meterRegistry.enabled) {
            long nanos = System.nanoTime();
            VncVal val = Reader.read_str(script, filename);
            this.meterRegistry.record("venice.read", System.nanoTime() - nanos);
            return val;
        }
        return Reader.read_str(script, filename);
    }

    @Override
    public VncVal EVAL(VncVal ast, Env env) {
        if (this.meterRegistry.enabled) {
            long nanos = System.nanoTime();
            VncVal val = this.evaluate(ast, env, false);
            this.meterRegistry.record("venice.eval", System.nanoTime() - nanos);
            return val;
        }
        return this.evaluate(ast, env, false);
    }

    @Override
    public VncVal MACROEXPAND(VncVal ast, Env env) {
        return this.macroexpand_all(new CallFrame("macroexpand-all", ast.getMeta()), ast, env);
    }

    @Override
    public VncVal RE(String script, String name, Env env) {
        VncVal ast = this.READ(script, name);
        if (this.macroExpandOnLoad) {
            ast = this.MACROEXPAND(ast, env);
        }
        return this.EVAL(ast, env);
    }

    @Override
    public String PRINT(VncVal exp) {
        return Printer.pr_str(exp, true);
    }

    @Override
    public Env createEnv(boolean macroexpandOnLoad, boolean ansiTerminal, RunMode runMode) {
        return this.createEnv(null, macroexpandOnLoad, ansiTerminal, runMode);
    }

    @Override
    public Env createEnv(List<String> preloadedExtensionModules, boolean macroExpandOnLoad, boolean ansiTerminal, RunMode runMode) {
        this.sealedSystemNS.set(false);
        Env env = new Env(null);
        VncMutableSet loadedModules = VncMutableSet.ofAll(Modules.PRELOADED_MODULES);
        for (Map.Entry<VncVal, VncVal> e : Functions.functions.entrySet()) {
            VncSymbol sym = (VncSymbol)e.getKey();
            VncVal val = e.getValue();
            if (val instanceof VncFunction) {
                VncFunction fn = (VncFunction)e.getValue();
                env.setGlobal(new Var(sym, fn, fn.isRedefinable()));
                continue;
            }
            if (val instanceof VncSpecialForm) {
                env.setGlobal(new Var(sym, val, false));
                continue;
            }
            env.setGlobal(new Var(sym, val, true));
        }
        env.setGlobal(new Var(new VncSymbol("*version*"), new VncString(Version.VERSION), false));
        env.setGlobal(new ComputedVar(new VncSymbol("*ns*"), () -> Namespaces.getCurrentNS(), false));
        env.setGlobal(new Var(new VncSymbol("*newline*"), new VncString(System.lineSeparator()), false));
        env.setGlobal(new Var(new VncSymbol("*ansi-term*"), VncBoolean.of(ansiTerminal), false));
        env.setGlobal(new Var(new VncSymbol("*run-mode*"), runMode == null ? Constants.Nil : runMode.mode, false));
        env.setGlobal(new Var(new VncSymbol("*loaded-modules*"), loadedModules, true));
        env.setGlobal(new Var(new VncSymbol("*loaded-files*"), new VncMutableSet(), true));
        env.setGlobal(new Var(new VncSymbol("*ARGV*"), Constants.Nil, true));
        this.initNS();
        this.setMacroExpandOnLoad(macroExpandOnLoad, env);
        this.loadModule("core", env, loadedModules);
        this.sealedSystemNS.set(true);
        CollectionUtil.toEmpty(preloadedExtensionModules).forEach(m -> this.loadModule((String)m, env, loadedModules));
        return env;
    }

    @Override
    public List<String> getAvailableModules() {
        ArrayList<String> modules = new ArrayList<String>(Modules.VALID_MODULES);
        modules.removeAll(Arrays.asList("core", "test", "http", "jackson"));
        Collections.sort(modules);
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private VncVal evaluate(VncVal ast_, Env env_, boolean inTailPosition) {
        orig_ast = ast_;
        env = env_;
        recursionPoint = null;
        tailPosition = inTailPosition;
        block118: while (true) {
            if (!(orig_ast instanceof VncList)) {
                return this.evaluate_values(orig_ast, env);
            }
            ast = (VncList)orig_ast;
            if (ast.isEmpty()) {
                return ast;
            }
            a0 = ast.first();
            a0meta = a0.getMeta();
            a0sym = a0 instanceof VncSymbol != false ? ((VncSymbol)a0).getName() : "__<*fn*>__";
            args = ast.rest();
            var13_13 = a0sym;
            var14_14 = -1;
            switch (var13_13.hashCode()) {
                case 3211: {
                    if (!var13_13.equals("do")) break;
                    var14_14 = 0;
                    break;
                }
                case 3357: {
                    if (!var13_13.equals("if")) break;
                    var14_14 = 1;
                    break;
                }
                case 107035: {
                    if (!var13_13.equals("let")) break;
                    var14_14 = 2;
                    break;
                }
                case 3327652: {
                    if (!var13_13.equals("loop")) break;
                    var14_14 = 3;
                    break;
                }
                case 108389165: {
                    if (!var13_13.equals("recur")) break;
                    var14_14 = 4;
                    break;
                }
                case 1896636553: {
                    if (!var13_13.equals("quasiquote")) break;
                    var14_14 = 5;
                    break;
                }
                case 820867430: {
                    if (!var13_13.equals("macroexpand")) break;
                    var14_14 = 6;
                    break;
                }
                case -544777552: {
                    if (!var13_13.equals("macroexpand-all*")) break;
                    var14_14 = 7;
                    break;
                }
                case -696667305: {
                    if (!var13_13.equals("tail-pos")) break;
                    var14_14 = 8;
                }
            }
            switch (var14_14) {
                case 0: {
                    expressions = args;
                    this.evaluate_sequence_values(expressions.butlast(), env);
                    orig_ast = expressions.last();
                    tailPosition = true;
                    break;
                }
                case 1: {
                    numArgs = args.size();
                    if (numArgs == 2 || numArgs == 3) {
                        cond = this.evaluate(args.first(), env, false);
                        if (!this.optimized && (debugAgent = (threadCtx = ThreadContext.get()).getDebugAgent_()) != null && debugAgent.hasBreakpointFor(BreakpointFnRef.IF)) {
                            debugAgent.onBreakSpecialForm("if", FunctionScope.FunctionEntry, VncVector.of(new VncVal[]{new VncString("cond")}), VncList.of(new VncVal[]{cond}), a0meta, env, threadCtx.getCallStack_());
                        }
                        orig_ast = VncBoolean.isFalseOrNil(cond) != false ? args.third() : args.second();
                        tailPosition = true;
                        break;
                    }
                    cf = new CallFrame("if", args, a0meta);
                    cs = new WithCallStack(cf);
                    debugAgent = null;
                    ArityExceptions.assertArity("if", ArityExceptions.FnType.SpecialForm, args, 2, 3);
                    if (cs == null) continue block118;
                    if (debugAgent == null) ** GOTO lbl83
                    try {
                        cs.close();
                    }
                    catch (Throwable var19_27) {
                        debugAgent.addSuppressed(var19_27);
                    }
                    continue block118;
lbl83:
                    // 1 sources

                    cs.close();
                    break;
                    catch (Throwable var19_28) {
                        try {
                            debugAgent = var19_28;
                            throw var19_28;
                        }
                        catch (Throwable var20_32) {
                            if (cs != null) {
                                if (debugAgent != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var21_36) {
                                        debugAgent.addSuppressed(var21_36);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var20_32;
                        }
                    }
                }
                case 2: {
                    if (args.isEmpty()) {
                        cf = new CallFrame("let", args, a0meta);
                        cs = new WithCallStack(cf);
                        cs = null;
                        try {
                            ArityExceptions.assertMinArity("let", ArityExceptions.FnType.SpecialForm, args, 1);
                        }
                        catch (Throwable debugAgent) {
                            cs = debugAgent;
                            throw debugAgent;
                        }
                        finally {
                            if (cs != null) {
                                if (cs != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable debugAgent) {
                                        cs.addSuppressed(debugAgent);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                        }
                    }
                    env = new Env(env);
                    threadCtx = ThreadContext.get();
                    debugAgent = threadCtx.getDebugAgent_();
                    bindings = Coerce.toVncVector(args.first());
                    expressions = args.rest();
                    if (bindings.size() % 2 != 0) {
                        cf = new CallFrame("let", args, a0meta);
                        cs = new WithCallStack(cf);
                        var21_35 = null;
                        try {
                            try {
                                throw new VncException("let requires an even number of forms in the binding vector!");
                            }
                            catch (Throwable var22_39) {
                                var21_35 = var22_39;
                                throw var22_39;
                            }
                        }
                        catch (Throwable var24_46) {
                            if (cs != null) {
                                if (var21_35 != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var25_48) {
                                        var21_35.addSuppressed(var25_48);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var24_46;
                        }
                    }
                    bindingsIter = bindings.iterator();
                    vars = new ArrayList<Var>();
                    while (bindingsIter.hasNext()) {
                        sym = bindingsIter.next();
                        symIsSymbol = sym instanceof VncSymbol;
                        if (symIsSymbol && ((VncSymbol)sym).hasNamespace()) {
                            s = (VncSymbol)sym;
                            cf = new CallFrame(s.getQualifiedName(), args, s.getMeta());
                            cs = new WithCallStack(cf);
                            var26_50 = null;
                            try {
                                try {
                                    throw new VncException("Can't use qualified symbols with let!");
                                }
                                catch (Throwable var27_54) {
                                    var26_50 = var27_54;
                                    throw var27_54;
                                }
                            }
                            catch (Throwable var28_57) {
                                if (cs != null) {
                                    if (var26_50 != null) {
                                        try {
                                            cs.close();
                                        }
                                        catch (Throwable var29_60) {
                                            var26_50.addSuppressed(var29_60);
                                        }
                                    } else {
                                        cs.close();
                                    }
                                }
                                throw var28_57;
                            }
                        }
                        val = this.evaluate((VncVal)bindingsIter.next(), env, false);
                        if (symIsSymbol) {
                            env.setLocal(new Var((VncSymbol)sym, val));
                            if (debugAgent == null) continue;
                            vars.add(new Var((VncSymbol)sym, val));
                            continue;
                        }
                        varTmp = Destructuring.destructure(sym, val);
                        env.addLocalVars(varTmp);
                        if (debugAgent == null) continue;
                        vars.addAll(varTmp);
                    }
                    if (debugAgent != null && debugAgent.hasBreakpointFor(BreakpointFnRef.LET)) {
                        callStack = threadCtx.getCallStack_();
                        debugAgent.onBreakSpecialForm("let", FunctionScope.FunctionEntry, vars, a0meta, env, callStack);
                    }
                    if (expressions.size() == 1) {
                        orig_ast = expressions.first();
                    } else {
                        this.evaluate_sequence_values(expressions.butlast(), env);
                        orig_ast = expressions.last();
                    }
                    tailPosition = true;
                    break;
                }
                case 3: {
                    recursionPoint = null;
                    if (args.size() < 2) {
                        cf = new CallFrame("loop", args, a0meta);
                        cs = new WithCallStack(cf);
                        bindings = null;
                        try {
                            ArityExceptions.assertMinArity("loop", ArityExceptions.FnType.SpecialForm, args, 2);
                        }
                        catch (Throwable expressions) {
                            bindings = expressions;
                            throw expressions;
                        }
                        finally {
                            if (cs != null) {
                                if (bindings != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable expressions) {
                                        bindings.addSuppressed(expressions);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                        }
                    }
                    env = new Env(env);
                    bindings = Coerce.toVncVector(args.first());
                    expressions = args.rest();
                    if (bindings.size() % 2 != 0) {
                        cf = new CallFrame("loop", args, a0meta);
                        cs = new WithCallStack(cf);
                        bindingsIter = null;
                        try {
                            try {
                                throw new VncException("loop requires an even number of forms in the binding vector!");
                            }
                            catch (Throwable vars) {
                                bindingsIter = vars;
                                throw vars;
                            }
                        }
                        catch (Throwable var32_64) {
                            if (cs != null) {
                                if (bindingsIter != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var33_65) {
                                        bindingsIter.addSuppressed(var33_65);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var32_64;
                        }
                    }
                    bindingNames = new ArrayList<E>(bindings.size() / 2);
                    bindingsIter = bindings.iterator();
                    while (bindingsIter.hasNext()) {
                        sym = Coerce.toVncSymbol(bindingsIter.next());
                        val = this.evaluate(bindingsIter.next(), env, false);
                        env.setLocal(new Var(sym, val));
                        bindingNames.add(sym);
                    }
                    threadCtx = ThreadContext.get();
                    debugAgent = threadCtx.getDebugAgent_();
                    recursionPoint = new RecursionPoint((List<VncSymbol>)bindingNames, expressions, env, a0meta, (DebugAgent)debugAgent);
                    if (debugAgent != null && debugAgent.hasBreakpointFor(BreakpointFnRef.LOOP)) {
                        cs = threadCtx.getCallStack_();
                        debugAgent.onBreakLoop(FunctionScope.FunctionEntry, recursionPoint, env, cs);
                    }
                    if (expressions.size() == 1) {
                        orig_ast = expressions.first();
                    } else {
                        this.evaluate_sequence_values(expressions.butlast(), env);
                        orig_ast = expressions.last();
                    }
                    tailPosition = true;
                    break;
                }
                case 4: {
                    if (recursionPoint == null) {
                        cf = new CallFrame("recur", args, a0meta);
                        cs = new WithCallStack(cf);
                        bindingNames = null;
                        try {
                            try {
                                throw new NotInTailPositionException("The recur expression is not in tail position!");
                            }
                            catch (Throwable bindingsIter) {
                                bindingNames = bindingsIter;
                                throw bindingsIter;
                            }
                        }
                        catch (Throwable var34_66) {
                            if (cs != null) {
                                if (bindingNames != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var35_67) {
                                        bindingNames.addSuppressed(var35_67);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var34_66;
                        }
                    }
                    if (args.size() != recursionPoint.getLoopBindingNamesCount()) {
                        cf = new CallFrame("recur", args, a0meta);
                        cs = new WithCallStack(cf);
                        bindingNames = null;
                        try {
                            try {
                                throw new VncException(String.format("The recur args (%d) do not match the loop args (%d) !", new Object[]{args.size(), recursionPoint.getLoopBindingNamesCount()}));
                            }
                            catch (Throwable bindingsIter) {
                                bindingNames = bindingsIter;
                                throw bindingsIter;
                            }
                        }
                        catch (Throwable var36_68) {
                            if (cs != null) {
                                if (bindingNames != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var37_69) {
                                        bindingNames.addSuppressed(var37_69);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var36_68;
                        }
                    }
                    env = this.buildRecursionEnv(args, env, recursionPoint);
                    if (recursionPoint.isDebuggingActive() && (debugAgent = recursionPoint.getDebugAgent()).hasBreakpointFor(BreakpointFnRef.LOOP)) {
                        cs = ThreadContext.getCallStack();
                        debugAgent.onBreakLoop(FunctionScope.FunctionEntry, recursionPoint, env, (CallStack)cs);
                    }
                    if ((expressions = recursionPoint.getLoopExpressions()).size() == 1) {
                        orig_ast = expressions.first();
                    } else {
                        this.evaluate_sequence_values(expressions.butlast(), env);
                        orig_ast = expressions.last();
                    }
                    tailPosition = true;
                    break;
                }
                case 5: {
                    orig_ast = SpecialForms_OtherFunctions.quasiquote.apply(a0meta, args, env, this.specialFormsContext);
                    break;
                }
                case 6: {
                    return this.macroexpand(args, env, a0meta);
                }
                case 7: {
                    return this.macroexpand_all(new CallFrame("macroexpand-all*", args, a0meta), this.evaluate(args.first(), env, false), env);
                }
                case 8: {
                    return this.tail_pos_check_(tailPosition, args, env, a0meta);
                }
                default: {
                    v0 = fn0 = a0 instanceof VncSymbol != false ? env.get((VncSymbol)a0) : this.evaluate(a0, env, false);
                    if (fn0 instanceof VncSpecialForm) {
                        sf = (VncSpecialForm)fn0;
                        if (sf.addCallFrame()) {
                            callframe = new CallFrame(sf.getName(), args, a0meta);
                            cs = new WithCallStack(callframe);
                            threadCtx = null;
                            try {
                                debugAgent = sf.apply(a0meta, args, env, this.specialFormsContext);
                                return debugAgent;
                            }
                            catch (Throwable debugAgent) {
                                threadCtx = debugAgent;
                                throw debugAgent;
                            }
                            finally {
                                if (cs != null) {
                                    if (threadCtx != null) {
                                        try {
                                            cs.close();
                                        }
                                        catch (Throwable cs) {
                                            threadCtx.addSuppressed(cs);
                                        }
                                    } else {
                                        cs.close();
                                    }
                                }
                            }
                        }
                        return sf.apply(a0meta, args, env, this.specialFormsContext);
                    }
                    if (!(fn0 instanceof VncFunction)) ** GOTO lbl452
                    fn = (VncFunction)fn0;
                    if (fn.isMacro()) {
                        expandedAst = this.doMacroexpand(ast, env);
                        if (expandedAst instanceof VncList) {
                            orig_ast = expandedAst;
                            continue block118;
                        }
                        return this.evaluate_values(expandedAst, env);
                    }
                    fnName = fn.getQualifiedName();
                    if (this.optimized) {
                        fnArgs = (VncList)this.evaluate_sequence_values(args, env);
                        return fn.apply(fnArgs);
                    }
                    threadCtx = ThreadContext.get();
                    callStack = threadCtx.getCallStack_();
                    debugAgent = threadCtx.getDebugAgent_();
                    if (debugAgent != null && debugAgent.hasBreakpointFor(new BreakpointFnRef(fnName))) {
                        debugAgent.onBreakFnCall(fnName, fn, args, env, callStack);
                    }
                    fnArgs = (VncList)this.evaluate_sequence_values(args, env);
                    v1 = nanos = this.meterRegistry.enabled != false ? System.nanoTime() : 0L;
                    if (!this.checkSandbox) ** GOTO lbl403
                    cf = new CallFrame(fnName, fnArgs, a0meta, env);
                    cs = new WithCallStack(cf);
                    var26_50 = null;
                    try {
                        this.interceptor.validateVeniceFunction(fnName);
                    }
                    catch (Throwable var27_55) {
                        var26_50 = var27_55;
                        throw var27_55;
                    }
                    finally {
                        if (cs != null) {
                            if (var26_50 != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var27_53) {
                                    var26_50.addSuppressed(var27_53);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                    this.interceptor.validateMaxExecutionTime();
lbl403:
                    // 2 sources

                    currThread = Thread.currentThread();
                    InterruptChecker.checkInterrupted(currThread, fn);
                    if (tailPosition && !fn.isNative() && !callStack.isEmpty() && fnName.equals(callStack.peek().getFnName())) {
                        effFn = fn.getFunctionForArgs(fnArgs);
                        env.addLocalVars(Destructuring.destructure(effFn.getParams(), fnArgs));
                        if (debugAgent != null && debugAgent.hasBreakpointFor(new BreakpointFnRef(fnName))) {
                            debugAgent.onBreakFnEnter(fnName, effFn, fnArgs, env, callStack);
                        }
                        body /* !! */  = (VncList)effFn.getBody();
                        this.evaluate_sequence_values(body /* !! */ .butlast(), env);
                        orig_ast = body /* !! */ .last();
                        break;
                    }
                    try {
                        if (fn.isNative()) {
                            callStack.push(new CallFrame(fnName, fnArgs, a0meta, env));
                            if (debugAgent != null && debugAgent.hasBreakpointFor(new BreakpointFnRef(fnName))) {
                                env.setLocal(new Var(new VncSymbol("debug::fn-args"), fnArgs));
                                try {
                                    debugAgent.onBreakFnEnter(fnName, fn, fnArgs, env, callStack);
                                    retVal = fn.apply(fnArgs);
                                    debugAgent.onBreakFnExit(fnName, fn, fnArgs, retVal, env, callStack);
                                    body /* !! */  = retVal;
                                    return body /* !! */ ;
                                }
                                catch (Exception ex) {
                                    debugAgent.onBreakFnException(fnName, fn, fnArgs, ex, env, callStack);
                                    throw ex;
                                }
                            }
                            var25_47 = fn.apply(fnArgs);
                            return var25_47;
                        }
                        threadCtx.setCallFrameFnData_(new CallFrameFnData(fnName, a0meta));
                        var25_47 = fn.apply(fnArgs);
                        return var25_47;
                    }
                    finally {
                        threadCtx.setCallFrameFnData_(null);
                        if (fn.isNative()) {
                            callStack.pop();
                        }
                        InterruptChecker.checkInterrupted(currThread, fn);
                        if (this.checkSandbox) {
                            this.interceptor.validateMaxExecutionTime();
                        }
                        if (this.meterRegistry.enabled) {
                            elapsed = System.nanoTime() - nanos;
                            if (fn instanceof VncMultiArityFunction) {
                                f = fn.getFunctionForArgs(fnArgs);
                                this.meterRegistry.record(fnName, f.getParams().size(), elapsed);
                            } else {
                                this.meterRegistry.record(fnName, elapsed);
                            }
                        }
                    }
lbl452:
                    // 1 sources

                    if (fn0 instanceof IVncFunction) {
                        cf = new CallFrame(fn0.getType().toString(), args, a0meta, env);
                        cs = new WithCallStack(cf);
                        var18_19 = null;
                        try {
                            fn = (IVncFunction)fn0;
                            fnArgs = (VncList)this.evaluate_sequence_values(args, env);
                            var21_35 = fn.apply(fnArgs);
                            return var21_35;
                        }
                        catch (Throwable var19_29) {
                            var18_19 = var19_29;
                            throw var19_29;
                        }
                        finally {
                            if (cs != null) {
                                if (var18_19 != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var22_42) {
                                        var18_19.addSuppressed(var22_42);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                        }
                    }
                    cf = new CallFrame("unknown", args, a0meta);
                    cs = new WithCallStack(cf);
                    var18_19 = null;
                    try {
                        try {
                            throw new VncException(String.format("Expected a function or keyword/set/map/vector as s-expression symbol value but got a value of type '%s'!", new Object[]{Types.getType(fn0)}));
                        }
                        catch (Throwable var19_30) {
                            var18_19 = var19_30;
                            throw var19_30;
                        }
                    }
                    catch (Throwable var48_79) {
                        if (cs != null) {
                            if (var18_19 != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var49_80) {
                                    var18_19.addSuppressed(var49_80);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw var48_79;
                    }
                }
            }
        }
    }

    private VncVal evaluate_values(VncVal ast, Env env) {
        if (ast == Constants.Nil) {
            return Constants.Nil;
        }
        if (ast instanceof VncSymbol) {
            return env.get((VncSymbol)ast);
        }
        if (ast instanceof VncSequence) {
            return this.evaluate_sequence_values((VncSequence)ast, env);
        }
        if (ast instanceof VncScalar) {
            return ast;
        }
        if (ast instanceof VncJavaObject) {
            return ast;
        }
        if (ast instanceof VncMap) {
            VncMap map = (VncMap)ast;
            HashMap<VncVal, VncVal> vals = new HashMap<VncVal, VncVal>(map.size());
            for (Map.Entry<VncVal, VncVal> e : map.getJavaMap().entrySet()) {
                vals.put(this.evaluate(e.getKey(), env, false), this.evaluate(e.getValue(), env, false));
            }
            return map.withValues(vals);
        }
        if (ast instanceof VncSet) {
            VncSet set = (VncSet)ast;
            ArrayList<VncVal> vals = new ArrayList<VncVal>(set.size());
            for (VncVal v : set) {
                vals.add(this.evaluate(v, env, false));
            }
            return set.withValues(vals);
        }
        return ast;
    }

    private VncSequence evaluate_sequence_values(VncSequence seq, Env env) {
        if (seq instanceof VncLazySeq) {
            return seq;
        }
        switch (seq.size()) {
            case 0: {
                return seq;
            }
            case 1: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env, false));
            }
            case 2: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env, false), this.evaluate(seq.second(), env, false));
            }
            case 3: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env, false), this.evaluate(seq.second(), env, false), this.evaluate(seq.third(), env, false));
            }
            case 4: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env, false), this.evaluate(seq.second(), env, false), this.evaluate(seq.third(), env, false), this.evaluate(seq.fourth(), env, false));
            }
        }
        return seq.map(v -> this.evaluate((VncVal)v, env, false));
    }

    private void loadModule(String module, Env env, VncMutableSet loadedModules) {
        try {
            long nanos = System.nanoTime();
            this.RE("(eval " + ModuleLoader.loadModule(module) + ")", module, env);
            if (this.meterRegistry.enabled) {
                this.meterRegistry.record("venice.module." + module + ".load", System.nanoTime() - nanos);
            }
            loadedModules.add(new VncKeyword(module));
        }
        catch (RuntimeException ex) {
            throw new VncException("Failed to load module '" + module + "'", ex);
        }
    }

    private VncVal doMacroexpand(VncVal ast, Env env) {
        VncVal fn;
        VncVal a0;
        long nanos = this.meterRegistry.enabled ? System.nanoTime() : 0L;
        VncVal ast_ = ast;
        int expandedMacros = 0;
        while (ast_ instanceof VncList && (a0 = ((VncList)ast_).first()) instanceof VncSymbol && (fn = env.getGlobalOrNull((VncSymbol)a0)) != null && fn instanceof VncFunction && ((VncFunction)fn).isMacro()) {
            VncFunction macro = (VncFunction)fn;
            VncList macroArgs = ((VncList)ast_).rest();
            if (this.checkSandbox) {
                this.interceptor.validateVeniceFunction(macro.getQualifiedName());
            }
            ++expandedMacros;
            CallFrame cf = new CallFrame(macro.getQualifiedName(), macroArgs, a0.getMeta());
            WithCallStack cs = new WithCallStack(cf);
            Throwable throwable = null;
            try {
                if (this.meterRegistry.enabled) {
                    long nanosRun = System.nanoTime();
                    ast_ = macro.apply(macroArgs);
                    this.meterRegistry.record(macro.getQualifiedName() + "[m]", System.nanoTime() - nanosRun);
                    continue;
                }
                ast_ = macro.apply(macroArgs);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cs == null) continue;
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                cs.close();
            }
        }
        if (expandedMacros > 0 && this.meterRegistry.enabled) {
            this.meterRegistry.record("macroexpand", System.nanoTime() - nanos);
        }
        return ast_;
    }

    private VncVal macroexpand(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("macroexpand", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("macroexpand", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal ast = this.evaluate(args.first(), env, false);
            VncVal vncVal = this.doMacroexpand(ast, env);
            return vncVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VncVal macroexpand_all(CallFrame callframe, VncVal form, final Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal vncVal;
            VncFunction handler = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-handler")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncList list;
                    VncVal first;
                    VncVal form = args.first();
                    if (Types.isVncList(form) && Types.isVncSymbol(first = (list = (VncList)form).first())) {
                        VncVal second = list.second();
                        if (list.size() == 2 && "ns".equals(((VncSymbol)first).getName()) && second instanceof VncSymbol) {
                            Namespaces.setCurrentNamespace(VeniceInterpreter.this.nsRegistry.computeIfAbsent((VncSymbol)second));
                        } else {
                            return VeniceInterpreter.this.doMacroexpand(list, env);
                        }
                    }
                    return form;
                }
            };
            final VncFunction walk = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-walk")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncFunction inner = (VncFunction)args.first();
                    VncVal form = args.second();
                    if (Types.isVncList(form)) {
                        return TransducerFunctions.map.applyOf(inner, form);
                    }
                    if (Types.isVncMapEntry(form)) {
                        return CoreFunctions.new_map_entry.applyOf(inner.applyOf(((VncMapEntry)form).getKey()), inner.applyOf(((VncMapEntry)form).getValue()));
                    }
                    if (Types.isVncCollection(form)) {
                        return CoreFunctions.into.applyOf(CoreFunctions.empty.applyOf(form), TransducerFunctions.map.applyOf(inner, form));
                    }
                    return form;
                }
            };
            VncFunction prewalk = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-prewalk")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncFunction f = (VncFunction)args.first();
                    VncVal form = args.second();
                    return walk.applyOf(CoreFunctions.partial.applyOf(this, f), f.applyOf(form));
                }
            };
            Namespace original_ns = Namespaces.getCurrentNamespace();
            try {
                vncVal = prewalk.applyOf(handler, form);
            }
            catch (Throwable throwable2) {
                try {
                    Namespaces.setCurrentNamespace(original_ns);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            Namespaces.setCurrentNamespace(original_ns);
            return vncVal;
        }
    }

    private VncVal tail_pos_check_(boolean inTailPosition, VncList args, Env env, VncVal meta) {
        if (!inTailPosition) {
            CallFrame callframe = new CallFrame("tail-pos", args, meta);
            VncString name = Coerce.toVncString(args.nthOrDefault(0, VncString.empty()));
            WithCallStack cs = new WithCallStack(callframe);
            Throwable throwable = null;
            try {
                try {
                    throw new NotInTailPositionException(name.isEmpty() ? "Not in tail position" : String.format("The tail-pos expression '%s' is not in tail position", name.getValue()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        return Constants.Nil;
    }

    private Env buildRecursionEnv(VncList args, Env env, RecursionPoint recursionPoint) {
        Env recur_env = recursionPoint.getLoopEnv();
        int argCount = args.size();
        switch (argCount) {
            case 0: {
                break;
            }
            case 1: {
                VncVal v = this.evaluate(args.first(), env, false);
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(0), v));
                break;
            }
            case 2: {
                VncVal v1 = this.evaluate(args.first(), env, false);
                VncVal v2 = this.evaluate(args.second(), env, false);
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(0), v1));
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(1), v2));
                break;
            }
            default: {
                int ii;
                VncVal[] newValues = new VncVal[argCount];
                for (ii = 0; ii < argCount; ++ii) {
                    newValues[ii] = this.evaluate(args.nth(ii), env, false);
                }
                for (ii = 0; ii < argCount; ++ii) {
                    recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(ii), newValues[ii]));
                }
            }
        }
        return recur_env;
    }
}

